<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.firewall'); ?>

<div class="borna-dashboard">
  <!-- Sidebar -->
  <div class="borna-sidebar">
    <div class="borna-sidebar-header">
      <h3>BORNA</h3>
      <p>Security Monitor</p>
    </div>
    
    <div class="borna-sidebar-content">
      <ul class="borna-nav">
        <li class="borna-nav-item <?= $active_page === 'test' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/test') ?>" class="borna-nav-link">
            <i class="fas fa-flask"></i> Test Suite
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('borna/security') ?>" class="borna-nav-link">
            <i class="fas fa-shield-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/overview') ?>" class="borna-nav-link">
            <i class="fas fa-tachometer-alt"></i> Overview
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'rules' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/rules') ?>" class="borna-nav-link">
            <i class="fas fa-list-alt"></i> Firewall Rules
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'ips' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/ips') ?>" class="borna-nav-link">
            <i class="fas fa-ban"></i> Blocked IPs
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'events' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/events') ?>" class="borna-nav-link">
            <i class="fas fa-history"></i> Security Events
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'settings' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/settings') ?>" class="borna-nav-link">
            <i class="fas fa-cog"></i> Settings
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'reports' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/reports') ?>" class="borna-nav-link">
            <i class="fas fa-chart-bar"></i> Reports
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="borna-main">
    <div class="borna-header">
      <h2>Firewall Rules</h2>
      <div class="borna-header-actions">
        <a href="<?= route('borna/security/rules') ?>?action=add" class="borna-btn primary">
          <i class="fas fa-plus"></i> Add New Rule
        </a>
      </div>
    </div>

    <!-- Alert Messages -->
    <?php if ($success): ?>
    <div class="borna-alert success">
      <i class="fas fa-check-circle"></i>
      <div>Rule has been successfully saved.</div>
    </div>
    <?php endif; ?>

    <?php if ($deleted): ?>
    <div class="borna-alert success">
      <i class="fas fa-check-circle"></i>
      <div>Rule has been successfully deleted.</div>
    </div>
    <?php endif; ?>

    <?php if ($toggled): ?>
    <div class="borna-alert success">
      <i class="fas fa-check-circle"></i>
      <div>Rule status has been updated.</div>
    </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
    <div class="borna-alert danger">
      <i class="fas fa-exclamation-circle"></i>
      <div><?= htmlspecialchars($_GET['error']); ?></div>
    </div>
    <?php endif; ?>

    <!-- Rule Form -->
    <?php if ($action === 'add' || $action === 'edit'): ?>
    <div class="borna-card rule-form-card">
      <div class="borna-card-header">
        <div class="borna-card-title">
          <i class="fas fa-<?= $action === 'add' ? 'plus' : 'edit'; ?>"></i> 
          <?= $action === 'add' ? 'Add New Rule' : 'Edit Rule'; ?>
        </div>
      </div>
      <div class="borna-card-body">
        <form action="<?= route('borna/security/rules') ?>?action=<?= $action; ?><?= $action === 'edit' && isset($_GET['id']) ? '&id=' . htmlspecialchars($_GET['id']) : ''; ?>" 
              method="post" class="rule-form">
          
          <div class="form-row">
            <div class="borna-form-group">
              <label for="name" class="borna-form-label">Rule Name</label>
              <input type="text" id="name" name="name" class="borna-form-control" 
                     value="<?= $editRule ? htmlspecialchars($editRule['name']) : ''; ?>" required>
            </div>
            
            <div class="borna-form-group">
              <label for="type" class="borna-form-label">Rule Type</label>
              <select id="type" name="type" class="borna-form-control" required>
                <option value="">Select Rule Type</option>
                <option value="path" <?= $editRule && $editRule['type'] === 'path' ? 'selected' : ''; ?>>Path</option>
                <option value="query" <?= $editRule && $editRule['type'] === 'query' ? 'selected' : ''; ?>>Query Parameter</option>
                <option value="header" <?= $editRule && $editRule['type'] === 'header' ? 'selected' : ''; ?>>HTTP Header</option>
                <option value="ip" <?= $editRule && $editRule['type'] === 'ip' ? 'selected' : ''; ?>>IP Address</option>
                <option value="method" <?= $editRule && $editRule['type'] === 'method' ? 'selected' : ''; ?>>HTTP Method</option>
              </select>
            </div>
          </div>
          
          <div class="borna-form-group">
            <label for="pattern" class="borna-form-label">Pattern</label>
            <input type="text" id="pattern" name="pattern" class="borna-form-control" 
                   value="<?= $editRule ? htmlspecialchars($editRule['pattern']) : ''; ?>" required>
            <small class="form-text">Use regular expressions for pattern matching</small>
          </div>
          
          <div class="form-row">
            <div class="borna-form-group">
              <label for="action" class="borna-form-label">Action</label>
              <select id="action" name="action" class="borna-form-control" required>
                <option value="">Select Action</option>
                <option value="block" <?= $editRule && $editRule['action'] === 'block' ? 'selected' : ''; ?>>Block</option>
                <option value="log" <?= $editRule && $editRule['action'] === 'log' ? 'selected' : ''; ?>>Log Only</option>
                <option value="captcha" <?= $editRule && $editRule['action'] === 'captcha' ? 'selected' : ''; ?>>CAPTCHA Challenge</option>
                <option value="throttle" <?= $editRule && $editRule['action'] === 'throttle' ? 'selected' : ''; ?>>Throttle</option>
              </select>
            </div>
            
            <div class="borna-form-group">
              <label class="borna-form-label">Status</label>
              <div class="toggle-switch-container">
                <label class="toggle-switch">
                  <input type="checkbox" name="enabled" value="1" <?= !$editRule || $editRule['enabled'] ? 'checked' : ''; ?>>
                  <span class="toggle-slider"></span>
                </label>
                <span class="toggle-label">Enabled</span>
              </div>
            </div>
          </div>
          
          <div class="borna-form-group">
            <label for="description" class="borna-form-label">Description</label>
            <textarea id="description" name="description" class="borna-form-control" rows="3"><?= $editRule ? htmlspecialchars($editRule['description']) : ''; ?></textarea>
          </div>
          
          <div class="form-actions">
            <a href="<?= route('borna/security/rules') ?>" class="borna-btn secondary">
              <i class="fas fa-times"></i> Cancel
            </a>
            <button type="submit" class="borna-btn primary">
              <i class="fas fa-save"></i> Save Rule
            </button>
          </div>
        </form>
      </div>
    </div>
    <?php else: ?>
    <!-- Rules List -->
    <div class="borna-card">
      <div class="borna-card-header">
        <div class="borna-card-title">
          <i class="fas fa-list-alt"></i> Firewall Rules
        </div>
        <div class="borna-card-tools">
          <div class="search-box">
            <input type="text" id="rulesSearch" placeholder="Search rules..." class="search-input">
            <i class="fas fa-search"></i>
          </div>
        </div>
      </div>
      <div class="borna-card-body">
        <?php if (empty($rules)): ?>
        <div class="empty-state">
          <i class="fas fa-shield-alt"></i>
          <p>No firewall rules have been added yet.</p>
          <a href="<?= route('borna/security/rules') ?>?action=add" class="borna-btn primary">
            <i class="fas fa-plus"></i> Add First Rule
          </a>
        </div>
        <?php else: ?>
        <div class="rules-table-container">
          <table class="borna-table rules-table">
            <thead>
              <tr>
                <th>Name</th>
                <th>Type</th>
                <th>Pattern</th>
                <th>Action</th>
                <th>Status</th>
                <th class="actions-col">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rules as $id => $rule): ?>
              <tr data-rule-id="<?= $id ?>" class="<?= $rule['enabled'] ? '' : 'disabled-rule'; ?>">
                <td>
                  <div class="rule-name"><?= htmlspecialchars($rule['name']); ?></div>
                  <?php if (!empty($rule['description'])): ?>
                  <div class="rule-description"><?= htmlspecialchars($rule['description']); ?></div>
                  <?php endif; ?>
                </td>
                <td><span class="rule-type"><?= htmlspecialchars(ucfirst($rule['type'])); ?></span></td>
                <td class="pattern-cell">
                  <div class="pattern-display"><?= htmlspecialchars($rule['pattern']); ?></div>
                </td>
                <td>
                  <span class="action-badge <?= $rule['action']; ?>">
                    <?= ucfirst($rule['action']); ?>
                  </span>
                </td>
                <td>
                  <form action="<?= route('borna/security/rules') ?>?action=toggle&id=<?= $id; ?>" 
                        method="post" class="toggle-form">
                    <div class="toggle-switch-container">
                      <label class="toggle-switch">
                        <input type="checkbox" name="enabled" value="1" <?= $rule['enabled'] ? 'checked' : ''; ?> onchange="this.form.submit()">
                        <span class="toggle-slider"></span>
                      </label>
                    </div>
                  </form>
                </td>
                <td class="actions-cell">
                  <div class="action-buttons">
                    <a href="<?= route('borna/security/rules') ?>?action=edit&id=<?= $id; ?>" 
                       class="action-btn edit" title="Edit Rule">
                      <i class="fas fa-edit"></i>
                    </a>
                    <form action="<?= route('borna/security/rules') ?>?action=delete&id=<?= $id; ?>" 
                          method="post" class="delete-form" 
                          onsubmit="return confirm('Are you sure you want to delete this rule?');">
                      <button type="submit" class="action-btn delete" title="Delete Rule">
                        <i class="fas fa-trash-alt"></i>
                      </button>
                    </form>
                  </div>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <?php endif; ?>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>