<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.settings'); ?>

<div class="borna-dashboard">
  <!-- Sidebar -->
  <div class="borna-sidebar">
    <div class="borna-sidebar-header">
      <h3>BORNA</h3>
      <p>Security Monitor</p>
    </div>
    
    <div class="borna-sidebar-content">
      <ul class="borna-nav">
        <li class="borna-nav-item <?= $active_page === 'test' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/test') ?>" class="borna-nav-link">
            <i class="fas fa-flask"></i> Test Suite
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('borna/security') ?>" class="borna-nav-link">
            <i class="fas fa-shield-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/overview') ?>" class="borna-nav-link">
            <i class="fas fa-tachometer-alt"></i> Overview
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'rules' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/rules') ?>" class="borna-nav-link">
            <i class="fas fa-list-alt"></i> Firewall Rules
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'ips' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/ips') ?>" class="borna-nav-link">
            <i class="fas fa-ban"></i> Blocked IPs
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'events' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/events') ?>" class="borna-nav-link">
            <i class="fas fa-history"></i> Security Events
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'settings' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/settings') ?>" class="borna-nav-link">
            <i class="fas fa-cog"></i> Settings
          </a>
        </li>
        
        <li class="borna-nav-item <?= $active_page === 'reports' ? 'active' : '' ?>">
          <a href="<?= route('borna/security/reports') ?>" class="borna-nav-link">
            <i class="fas fa-chart-bar"></i> Reports
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="borna-main">
    <div class="borna-header">
      <h2>Security Settings</h2>
    </div>

    <!-- Alert Messages -->
    <?php if ($updated): ?>
    <div class="borna-alert success">
      <i class="fas fa-check-circle"></i>
      <div>Security settings have been successfully updated.</div>
    </div>
    <?php endif; ?>

    <!-- Settings Form -->
    <form action="<?= route('borna/security/settings') ?>" method="post" class="settings-form">
      <!-- General Security Settings -->
      <div class="settings-section">
        <div class="settings-section-header">
          <h3>General Security Settings</h3>
          <p>Configure the overall security level and protection mechanisms.</p>
        </div>
        
        <div class="settings-card">
          <div class="settings-group">
            <label for="security_level" class="settings-label">Security Level</label>
            <div class="level-selector">
              <div class="level-option <?= $settings['security_level'] === 1 ? 'active' : ''; ?>" data-level="1">
                <input type="radio" id="level-1" name="security_level" value="1" <?= $settings['security_level'] === 1 ? 'checked' : ''; ?>>
                <div class="level-indicator low"></div>
                <div class="level-details">
                  <div class="level-name">Low</div>
                  <div class="level-desc">Basic protection with minimal performance impact</div>
                </div>
              </div>
              
              <div class="level-option <?= $settings['security_level'] === 2 ? 'active' : ''; ?>" data-level="2">
                <input type="radio" id="level-2" name="security_level" value="2" <?= $settings['security_level'] === 2 ? 'checked' : ''; ?>>
                <div class="level-indicator medium"></div>
                <div class="level-details">
                  <div class="level-name">Medium</div>
                  <div class="level-desc">Balanced protection with moderate performance impact</div>
                </div>
              </div>
              
              <div class="level-option <?= $settings['security_level'] === 3 ? 'active' : ''; ?>" data-level="3">
                <input type="radio" id="level-3" name="security_level" value="3" <?= $settings['security_level'] === 3 ? 'checked' : ''; ?>>
                <div class="level-indicator high"></div>
                <div class="level-details">
                  <div class="level-name">High</div>
                  <div class="level-desc">Maximum protection with potential performance impact</div>
                </div>
              </div>
            </div>
          </div>
          
          <div class="settings-group toggle-group">
            <label class="settings-label">Protection Features</label>
            
            <div class="toggle-option">
              <div class="toggle-switch-container">
                <label class="toggle-switch">
                  <input type="checkbox" name="xss_protection" value="1" <?= $settings['xss_protection'] ? 'checked' : ''; ?>>
                  <span class="toggle-slider"></span>
                </label>
              </div>
              <div class="toggle-details">
                <div class="toggle-name">XSS Protection</div>
                <div class="toggle-desc">Prevents cross-site scripting attacks</div>
              </div>
            </div>
            
            <div class="toggle-option">
              <div class="toggle-switch-container">
                <label class="toggle-switch">
                  <input type="checkbox" name="sqli_protection" value="1" <?= $settings['sqli_protection'] ? 'checked' : ''; ?>>
                  <span class="toggle-slider"></span>
                </label>
              </div>
              <div class="toggle-details">
                <div class="toggle-name">SQL Injection Protection</div>
                <div class="toggle-desc">Prevents SQL injection attacks</div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Geolocation Settings -->
      <div class="settings-section">
        <div class="settings-section-header">
          <h3>Geolocation Settings</h3>
          <p>Configure country-based access restrictions.</p>
        </div>
        
        <div class="settings-card">
          <div class="settings-group">
            <label for="allowed_countries" class="settings-label">Allowed Countries</label>
            <div class="settings-input-desc">Enter comma-separated country codes (e.g., US, GB, DE). Leave empty to allow all countries.</div>
            <input type="text" id="allowed_countries" name="allowed_countries" class="borna-form-control" 
                   placeholder="US, GB, DE" 
                   value="<?= htmlspecialchars(implode(', ', $settings['allowed_countries'])); ?>">
          </div>
          
          <div class="settings-group">
            <label for="blocked_countries" class="settings-label">Blocked Countries</label>
            <div class="settings-input-desc">Enter comma-separated country codes (e.g., RU, CN). Leave empty to block no countries.</div>
            <input type="text" id="blocked_countries" name="blocked_countries" class="borna-form-control" 
                   placeholder="RU, CN" 
                   value="<?= htmlspecialchars(implode(', ', $settings['blocked_countries'])); ?>">
            <div class="settings-input-note">Note: Blocked countries take precedence over allowed countries.</div>
          </div>
        </div>
      </div>
      
      <!-- Advanced Settings -->
      <div class="settings-section">
        <div class="settings-section-header">
          <h3>Advanced Settings</h3>
          <p>Configure specialized security features. These settings are for advanced users.</p>
        </div>
        
        <div class="settings-card">
          <div class="settings-group">
            <label class="settings-label">Content Security Policy</label>
            <div class="csp-options">
              <div class="csp-preset">
                <input type="radio" id="csp-none" name="csp_level" value="none" checked>
                <label for="csp-none">None</label>
              </div>
              <div class="csp-preset">
                <input type="radio" id="csp-basic" name="csp_level" value="basic">
                <label for="csp-basic">Basic</label>
              </div>
              <div class="csp-preset">
                <input type="radio" id="csp-strict" name="csp_level" value="strict">
                <label for="csp-strict">Strict</label>
              </div>
              <div class="csp-preset">
                <input type="radio" id="csp-custom" name="csp_level" value="custom">
                <label for="csp-custom">Custom</label>
              </div>
            </div>
            <textarea id="csp-custom-value" class="borna-form-control" rows="4" placeholder="Enter custom CSP directives..." disabled></textarea>
          </div>
          
          <div class="settings-group">
            <label class="settings-label">Rate Limiting</label>
            <div class="rate-limit-controls">
              <div class="rate-limit-input">
                <input type="number" name="rate_limit_requests" min="1" value="60" class="borna-form-control">
                <span>requests per</span>
              </div>
              <div class="rate-limit-input">
                <input type="number" name="rate_limit_period" min="1" value="1" class="borna-form-control">
                <select name="rate_limit_unit" class="borna-form-control">
                  <option value="minute">minute</option>
                  <option value="hour">hour</option>
                  <option value="day">day</option>
                </select>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Form Actions -->
      <div class="settings-form-actions">
        <button type="reset" class="borna-btn secondary">
          <i class="fas fa-undo"></i> Reset
        </button>
        <button type="submit" class="borna-btn primary">
          <i class="fas fa-save"></i> Save Settings
        </button>
      </div>
    </form>
  </div>
</div>