<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('bornatest.index'); ?>

<!-- BORNA Security Test Dashboard -->
<div class="borna-test-container">
    <div class="borna-test-header">
        <h1>BORNA Security Test Panel</h1>
        
        <div class="borna-test-actions">
            <a href="<?= route('borna/security/api/run-test') ?>?test=all" class="borna-test-button primary">
                <i class="fas fa-play-circle"></i> Run All Tests
            </a>
            <a href="<?= route('borna/security/api/performance') ?>" class="borna-test-button info">
                <i class="fas fa-tachometer-alt"></i> Performance Tests
            </a>
        </div>
        
        <div class="row">
            <!-- Security Tests -->
            <div class="col-lg-6">
                <div class="borna-test-card">
                    <div class="borna-test-card-header security">
                        <i class="fas fa-shield-alt"></i> Security Tests
                    </div>
                    <div class="borna-test-card-body">
                        <ul class="borna-test-list">
                            <?php foreach ($availableTests as $testId => $test): ?>
                                <?php if ($test['category'] === 'Security'): ?>
                                    <li class="borna-test-item">
                                        <a href="<?= route('borna/security/api/run-test') ?>?test=<?= $testId ?>" class="borna-test-link">
                                            <div class="borna-test-name"><?= $test['name'] ?></div>
                                            <p class="borna-test-description"><?= $test['description'] ?></p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Advanced Tests -->
            <div class="col-lg-6">
                <div class="borna-test-card">
                    <div class="borna-test-card-header advanced">
                        <i class="fas fa-microscope"></i> Advanced Tests
                    </div>
                    <div class="borna-test-card-body">
                        <ul class="borna-test-list">
                            <?php foreach ($availableTests as $testId => $test): ?>
                                <?php if ($test['category'] === 'Advanced' || $test['category'] === 'Performance' || $test['category'] === 'System'): ?>
                                    <li class="borna-test-item">
                                        <a href="<?= route('borna/security/api/run-test') ?>?test=<?= $testId ?>" class="borna-test-link">
                                            <div class="borna-test-name"><?= $test['name'] ?></div>
                                            <p class="borna-test-description"><?= $test['description'] ?></p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Complete Test Section -->
        <div class="borna-test-card">
            <div class="borna-test-card-header complete">
                <i class="fas fa-rocket"></i> Complete Test Suite
            </div>
            <div class="borna-test-card-body">
                <ul class="borna-test-list">
                    <?php foreach ($availableTests as $testId => $test): ?>
                        <?php if ($test['category'] === 'Complete'): ?>
                            <li class="borna-test-item">
                                <a href="<?= route('borna/security/api/run-test') ?>?test=<?= $testId ?>" class="borna-test-link">
                                    <div class="borna-test-name">
                                        <?= $test['name'] ?>
                                        <span class="badge bg-danger">Comprehensive</span>
                                    </div>
                                    <p class="borna-test-description"><?= $test['description'] ?></p>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        
        <div class="borna-test-card">
            <div class="borna-test-card-header info">
                <i class="fas fa-info-circle"></i> BORNA Security Information
            </div>
            <div class="borna-test-card-body p-4">
                <p>BORNA Security is an advanced security module developed for detection and prevention of various types of attacks on web applications.</p>
                <p>Features include:</p>
                <ul>
                    <li>Detection of XSS, SQL injection, and other attacks</li>
                    <li>Protection from path traversal and file inclusion attacks</li>
                    <li>Request rate limiting</li>
                    <li>Geolocation blocking</li>
                    <li>File integrity tracking</li>
                    <li>User behavior analysis</li>
                    <li>Anomaly detection</li>
                    <li>Client fingerprinting</li>
                </ul>
                <p>Testing the BORNA module through this control panel allows validation of its security functionalities and performance.</p>
            </div>
        </div>
    </div>
</div>