<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('bornatest.performance'); ?>

<!-- BORNA Security Performance Tests -->
<div class="borna-test-container">
    <div class="borna-test-result-header">
        <h1 class="borna-test-result-title">Performance Tests</h1>
        <div class="borna-test-result-actions">
            <a href="<?= route('borna/security/test') ?>" class="borna-test-button info">
                <i class="fas fa-arrow-left"></i> Back to panel
            </a>
            <a href="<?= route('borna/security/api/performance') ?>" class="borna-test-button primary">
                <i class="fas fa-redo-alt"></i> Repeat performance tests
            </a>
        </div>
    </div>
    
    <div class="row">
        <!-- Analysis Speed -->
        <div class="col-lg-6">
            <div class="borna-performance-container">
                <h3 class="borna-performance-title"><i class="fas fa-tachometer-alt"></i> Request Analysis Speed</h3>
                <?php if (isset($perfResults['analysis_speed']) && !empty($perfResults['analysis_speed']['requests'])): ?>
                    <!-- Data for chart -->
                    <div id="speedChartData" 
                        data-requests='<?= json_encode($perfResults['analysis_speed']['requests']) ?>'
                        data-times='<?= json_encode($perfResults['analysis_speed']['average_times']) ?>'
                        ></div>
                    
                    <div class="borna-chart-container">
                        <canvas id="speedChart"></canvas>
                    </div>
                    
                    <table class="borna-performance-table">
                        <thead>
                            <tr>
                                <th>Number of Requests</th>
                                <th>Average Time (ms)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($perfResults['analysis_speed']['requests'] as $index => $requestCount): ?>
                                <tr>
                                    <td><?= $requestCount ?> requests</td>
                                    <td><?= $perfResults['analysis_speed']['average_times'][$index] ?> ms</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="borna-alert info">
                        <i class="fas fa-info-circle"></i>
                        <div>No analysis speed data available.</div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Memory Usage -->
        <div class="col-lg-6">
            <div class="borna-performance-container">
                <h3 class="borna-performance-title"><i class="fas fa-memory"></i> Memory Usage</h3>
                <?php if (isset($perfResults['memory_usage']) && !empty($perfResults['memory_usage']['tests'])): ?>
                    <!-- Data for chart -->
                    <div id="memoryChartData" 
                        data-tests='<?= json_encode($perfResults['memory_usage']['tests']) ?>'
                        data-usage='<?= json_encode($perfResults['memory_usage']['peak_usage']) ?>'
                        ></div>
                    
                    <div class="borna-chart-container">
                        <canvas id="memoryChart"></canvas>
                    </div>
                    
                    <table class="borna-performance-table">
                        <thead>
                            <tr>
                                <th>Test Case</th>
                                <th>Peak Memory Usage (MB)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($perfResults['memory_usage']['tests'] as $index => $testName): ?>
                                <tr>
                                    <td><?= $testName ?></td>
                                    <td><?= $perfResults['memory_usage']['peak_usage'][$index] ?> MB</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="borna-alert info">
                        <i class="fas fa-info-circle"></i>
                        <div>No memory usage data available.</div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="borna-performance-container">
        <h3 class="borna-performance-title"><i class="fas fa-chart-line"></i> Production Performance Estimate</h3>
        <div class="row">
            <div class="col-md-8">
                <h5>Performance estimates under different loads</h5>
                <p>Based on test results, the BORNA Security module should have the following performance in a production environment:</p>
                
                <?php
                // Calculate estimated performance
                $avgTime = 0;
                $requestCount = 0;
                
                if (isset($perfResults['analysis_speed']) && !empty($perfResults['analysis_speed']['average_times'])) {
                    $avgTime = array_sum($perfResults['analysis_speed']['average_times']) / count($perfResults['analysis_speed']['average_times']);
                    $requestCount = end($perfResults['analysis_speed']['requests']);
                }
                
                $lowTraffic = 100; // 100 requests per minute
                $mediumTraffic = 1000; // 1000 requests per minute
                $highTraffic = 10000; // 10000 requests per minute
                
                // Postavi minimalno 5% za vidljivost
                $lowCPU = max(5, ($avgTime * $lowTraffic) / 60000 * 100);
                $mediumCPU = max(15, ($avgTime * $mediumTraffic) / 60000 * 100);
                $highCPU = max(30, ($avgTime * $highTraffic) / 60000 * 100);
                
                // Memory estimates
                $baseMemory = 0;
                if (isset($perfResults['memory_usage']) && !empty($perfResults['memory_usage']['peak_usage'])) {
                    $baseMemory = reset($perfResults['memory_usage']['peak_usage']);
                }
                
                $lowMemory = $baseMemory;
                $mediumMemory = $baseMemory * 1.5;
                $highMemory = $baseMemory * 2;
                ?>
                
                <table class="borna-performance-table">
                    <thead>
                        <tr>
                            <th>Load</th>
                            <th>Requests per minute</th>
                            <th>Estimated CPU Load</th>
                            <th>Estimated Memory Usage</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Low Traffic</td>
                            <td><?= $lowTraffic ?> req/min</td>
                            <td>
                                <div class="borna-test-progress">
                                    <div class="borna-test-progress-bar <?= $lowCPU > 70 ? 'danger' : ($lowCPU > 40 ? 'warning' : 'success') ?>" 
                                        data-progress="<?= min($lowCPU, 100) ?>">
                                    </div>
                                </div>
                                <div class="mt-1"><?= round($lowCPU) ?>%</div>
                            </td>
                            <td><?= round($lowMemory, 2) ?> MB</td>
                        </tr>
                        <tr>
                            <td>Medium Traffic</td>
                            <td><?= $mediumTraffic ?> req/min</td>
                            <td>
                                <div class="borna-test-progress">
                                    <div class="borna-test-progress-bar <?= $mediumCPU > 70 ? 'danger' : ($mediumCPU > 40 ? 'warning' : 'success') ?>" 
                                        data-progress="<?= min($mediumCPU, 100) ?>">
                                    </div>
                                </div>
                                <div class="mt-1"><?= round($mediumCPU) ?>%</div>
                            </td>
                            <td><?= round($mediumMemory, 2) ?> MB</td>
                        </tr>
                        <tr>
                            <td>High Traffic</td>
                            <td><?= $highTraffic ?> req/min</td>
                            <td>
                                <div class="borna-test-progress">
                                    <div class="borna-test-progress-bar <?= $highCPU > 70 ? 'danger' : ($highCPU > 40 ? 'warning' : 'success') ?>" 
                                        data-progress="<?= min($highCPU, 100) ?>">
                                    </div>
                                </div>
                                <div class="mt-1"><?= round($highCPU) ?>%</div>
                            </td>
                            <td><?= round($highMemory, 2) ?> MB</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-md-4">
                <div class="card bg-light">
                    <div class="card-body">
                        <h5 class="card-title">Production Recommendations</h5>
                        <ul class="list-group borna-recommendation-list">
                            <li class="list-group-item">
                                <i class="fas fa-server"></i> Minimum 
                                <?= $highCPU > 100 ? '4 CPU cores' : ($highCPU > 50 ? '2 CPU cores' : '1 CPU core') ?>
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-memory"></i> Minimum 
                                <?= $highMemory > 500 ? '2 GB RAM' : ($highMemory > 100 ? '1 GB RAM' : '512 MB RAM') ?>
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-database"></i> Recommended to use Redis storage
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-cogs"></i> Regular cleaning of old data
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>