<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('borna.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('bornatest.results'); ?>

<!-- BORNA Security Test Results -->
<div class="borna-test-container">
    <div class="borna-test-result-header">
        <h1 class="borna-test-result-title">Test Results: <?= htmlspecialchars($testCase) ?></h1>
        <div class="borna-test-result-actions">
            <a href="<?= route('borna/security/test') ?>" class="borna-test-button info">
                <i class="fas fa-arrow-left"></i> Back to panel
            </a>
            <a href="<?= route('borna/security/api/run-test') ?>?test=<?= $testCase ?>" class="borna-test-button primary">
                <i class="fas fa-redo-alt"></i> Repeat test
            </a>
        </div>
    </div>
    
    <!-- Test Summary Card -->
    <div class="borna-test-result-summary">
        <div class="row">
            <div class="col-md-8">
                <div class="borna-test-status <?= $results['passed'] ? 'success' : 'error' ?>">
                    <?php if ($results['passed']): ?>
                        <i class="fas fa-check-circle"></i>
                        <h4>Test passed successfully</h4>
                    <?php else: ?>
                        <i class="fas fa-times-circle"></i>
                        <h4>Test failed</h4>
                    <?php endif; ?>
                </div>
                <h4><?= $results['name'] ?? 'Test Results' ?></h4>
                <p><?= $results['description'] ?? '' ?></p>
                
                <?php if (isset($results['error'])): ?>
                    <div class="borna-alert danger">
                        <i class="fas fa-exclamation-triangle"></i>
                        <div><strong>Error:</strong> <?= $results['error'] ?></div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <div class="text-center">
                    <div class="mb-3">
                        <span class="display-4">
                            <?php
                            if (isset($results['tests'])) {
                                $passedCount = array_reduce($results['tests'], function($carry, $test) {
                                    return $carry + (isset($test['passed']) && $test['passed'] ? 1 : 0);
                                }, 0);
                                $totalCount = count($results['tests']);
                                echo "{$passedCount} / {$totalCount}";
                            } else {
                                echo "N/A";
                            }
                            ?>
                        </span>
                        <div>Tests passed</div>
                    </div>
                    
                    <?php if (isset($results['tests']) && $totalCount > 0): ?>
                        <div class="borna-test-progress">
                            <div class="borna-test-progress-bar <?= ($passedCount === $totalCount) ? 'success' : ($passedCount > 0 ? 'warning' : 'danger') ?>"
                                data-progress="<?= ($passedCount / $totalCount) * 100 ?>">
                            </div>
                        </div>
                        <div><?= round(($passedCount / $totalCount) * 100) ?>%</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Test Details -->
    <?php if (isset($results['tests']) && !empty($results['tests'])): ?>
        <?php foreach ($results['tests'] as $index => $test): ?>
            <div class="borna-test-detail <?= isset($test['passed']) && $test['passed'] ? 'passed' : 'failed' ?>">
                <div class="borna-test-detail-header <?= isset($test['passed']) && $test['passed'] ? 'success' : 'error' ?>">
                    <?php if (isset($test['passed']) && $test['passed']): ?>
                        <i class="fas fa-check-circle"></i>
                    <?php else: ?>
                        <i class="fas fa-times-circle"></i>
                    <?php endif; ?>
                    Test #<?= $index + 1 ?>: <?= $test['name'] ?? 'Unnamed Test' ?>
                </div>
                <div class="borna-test-detail-content">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Details</h6>
                            <table class="borna-test-detail-table">
                                <?php if (isset($test['payload'])): ?>
                                    <tr>
                                        <th>Payload</th>
                                        <td><code><?= htmlspecialchars($test['payload']) ?></code></td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['expected_score'])): ?>
                                    <tr>
                                        <th>Expected Score</th>
                                        <td><?= $test['expected_score'] ?></td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['detected_score'])): ?>
                                    <tr>
                                        <th>Detected Score</th>
                                        <td>
                                            <div class="borna-test-progress">
                                                <div class="borna-test-progress-bar <?= $test['detected_score'] >= 50 ? 'danger' : ($test['detected_score'] >= 25 ? 'warning' : 'success') ?>"
                                                    data-progress="<?= $test['detected_score'] ?>">
                                                </div>
                                            </div>
                                            <div class="mt-1"><?= $test['detected_score'] ?></div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['execution_time'])): ?>
                                    <tr>
                                        <th>Execution Time</th>
                                        <td><?= $test['execution_time'] ?> ms</td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['country'])): ?>
                                    <tr>
                                        <th>Country</th>
                                        <td><?= $test['country'] ?></td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['ip'])): ?>
                                    <tr>
                                        <th>IP</th>
                                        <td><?= $test['ip'] ?></td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['requests'])): ?>
                                    <tr>
                                        <th>Requests</th>
                                        <td><?= $test['requests'] ?></td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['fingerprint'])): ?>
                                    <tr>
                                        <th>Fingerprint</th>
                                        <td><code><?= $test['fingerprint'] ?></code></td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if (isset($test['result'])): ?>
                                    <tr>
                                        <th>Result</th>
                                        <td><?= $test['result'] ?></td>
                                    </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <?php if (isset($test['details']) && !empty($test['details'])): ?>
                                <h6>Threat Details</h6>
                                <?php if (is_array($test['details'])): ?>
                                    <?php if (isset($test['details']['type']) && $test['details']['type'] === 'none'): ?>
                                        <div class="borna-alert info">
                                            <i class="fas fa-info-circle"></i>
                                            <div><?= $test['details']['details'] ?></div>
                                        </div>
                                    <?php else: ?>
                                        <div class="accordion" id="threatDetails<?= $index ?>">
                                            <?php foreach ($test['details'] as $detailIndex => $detail): ?>
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="heading<?= $index ?>_<?= $detailIndex ?>">
                                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?= $index ?>_<?= $detailIndex ?>" aria-expanded="false" aria-controls="collapse<?= $index ?>_<?= $detailIndex ?>">
                                                            <?= $detail['type'] ?? 'Unknown Threat' ?>
                                                            <?php if (isset($detail['description'])): ?>
                                                                - <?= $detail['description'] ?>
                                                            <?php endif; ?>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse<?= $index ?>_<?= $detailIndex ?>" class="accordion-collapse collapse" aria-labelledby="heading<?= $index ?>_<?= $detailIndex ?>" data-bs-parent="#threatDetails<?= $index ?>">
                                                        <div class="accordion-body">
                                                            <?php if (isset($detail['details']) && !empty($detail['details'])): ?>
                                                                <pre class="code-block"><code><?= json_encode($detail['details'], JSON_PRETTY_PRINT) ?></code></pre>
                                                            <?php else: ?>
                                                                <div class="text-muted">No additional details available</div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <pre class="code-block"><code><?= is_string($test['details']) ? $test['details'] : json_encode($test['details'], JSON_PRETTY_PRINT) ?></code></pre>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="borna-alert info">
            <i class="fas fa-info-circle"></i>
            <div>No data available for display.</div>
        </div>
    <?php endif; ?>
</div>