<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>

<div class="admin-dashboard">
  <div class="sidebar">
    <div class="sidebar-header">
      <h3>Admin Panel</h3>
      <button id="mobile-toggle" class="mobile-toggle">
        <i class="fa fa-bars"></i>
      </button>
    </div>
    
    <div class="sidebar-content">
      <ul class="sidebar-menu">

        <li class="sidebar-item active">
          <a href="#" class="sidebar-link" data-target="adminSection1">
            <i class="fa fa-user-circle"></i>
            <span>Users</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('users/list') ?>">Users List</a></li>
          </ul>
        </li>

        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="adminSection2">
            <i class="fa fa-key"></i>
            <span>API Tokens</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('api/tokens') ?>">Manage Tokens</a></li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="adminSection3">
            <i class="fa fa-user-secret"></i>
            <span>Passwords</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('password/list') ?>">Password Reset List</a></li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="adminSection4">
            <i class="fa fa-database"></i>
            <span>Databases - Import & Export</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('databases/importexport') ?>">Databases - Import/Export</a></li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="adminSection5">
            <i class="fa fa-edit"></i>
            <span>Databases - List & Edit</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('database/listandedit') ?>">Databases - List & Edit</a></li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="adminSection6">
            <i class="fa fa-mobile"></i>
            <span>Database - Import & Export</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('database/importexportfull') ?>">Database - Import & Export</a></li>
          </ul>
        </li>

        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="adminSection7">
            <i class="fa fa-desktop"></i>
            <span>Application Monitoring</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('luka/digital-twin') ?>">LUKA Digital Twin</a></li>
          </ul>
        </li>

        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="adminSection8">
            <i class="fa fa-shield"></i>
            <span>Security Center</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('borna/security') ?>">BORNA Security</a></li>
          </ul>
        </li>
        
      </ul>
    </div>
  </div>

  <div class="main-content">
    <div class="content-header">
      <h2>Database Overview</h2>
      <p>View and manage your database tables</p>
    </div>

    <div class="content-body">
      <?php
      if (!empty($conn)) {
          // Dohvati sve tablice
          $sql = "SELECT table_name FROM information_schema.tables WHERE table_schema = DATABASE()";
          $stmt = $conn->prepare($sql);
          $stmt->execute();
          $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

          // Count total tables, rows and size
          $totalTables = count($tables);
          $totalRows = 0;
          $totalSize = 0;

          // Get info for each table
          $tableData = [];
          foreach ($tables as $table) {
              // Dohvati informacije o tablici
              $stmt = $conn->query("SELECT COUNT(*) AS column_count FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = '$table'");
              $table_info = $stmt->fetch(PDO::FETCH_ASSOC);
              $column_count = $table_info['column_count'];

              // Dohvati broj redaka
              $stmt = $conn->query("SELECT COUNT(*) AS row_count FROM $table");
              $table_info = $stmt->fetch(PDO::FETCH_ASSOC);
              $row_count = $table_info['row_count'];
              $totalRows += $row_count;

              // Dohvati veličinu tablice u bajtovima
              $stmt = $conn->query("SHOW TABLE STATUS LIKE '$table'");
              $table_info = $stmt->fetch(PDO::FETCH_ASSOC);
              $table_size = $table_info['Data_length'];
              $totalSize += $table_size;

              // Pretvori veličinu u megabajte
              $table_size_mb = round($table_size / (1024 * 1024), 2);

              // Datum kreiranja tablice
              $creation_date = date('d.m.Y H:i', strtotime($table_info['Create_time']));

              // Datum zadnjeg ažuriranja tablice
              $last_update_time = isset($table_info['Update_time']) && !empty($table_info['Update_time']) ? strtotime($table_info['Update_time']) : null;
              $last_update_date = ($last_update_time != 0) ? date('d.m.Y H:i', $last_update_time) : '';

              // Tip pohrane tablice
              $storage_engine = $table_info['Engine'];

              // Kolacija tablice
              $collation = $table_info['Collation'];

              $tableData[] = [
                  'name' => $table,
                  'columns' => $column_count,
                  'rows' => $row_count,
                  'size' => $table_size_mb,
                  'created' => $creation_date,
                  'updated' => $last_update_date,
                  'engine' => $storage_engine,
                  'collation' => $collation
              ];
          }

          // Display dashboard summary
          echo '<div class="dashboard-cards">';
          echo '<div class="dashboard-card"><div class="card-icon"><i class="fa fa-table"></i></div><div class="card-data"><span class="card-value">' . $totalTables . '</span><span class="card-label">Tables</span></div></div>';
          echo '<div class="dashboard-card"><div class="card-icon"><i class="fa fa-database"></i></div><div class="card-data"><span class="card-value">' . number_format($totalRows) . '</span><span class="card-label">Total Rows</span></div></div>';
          echo '<div class="dashboard-card"><div class="card-icon"><i class="fa fa-hdd-o"></i></div><div class="card-data"><span class="card-value">' . round($totalSize / (1024 * 1024), 2) . ' MB</span><span class="card-label">Database Size</span></div></div>';
          echo '</div>';

          // Table search and filter
          echo '<div class="table-controls">';
          echo '<div class="search-container"><input type="text" id="tableSearch" placeholder="Search tables..."><i class="fa fa-search"></i></div>';
          echo '</div>';

          // Prikaži informacije o svakoj tablici
          echo '<div class="table-responsive">';
          echo "<table id='dataTable' class='data-table'>";
          echo "<thead><tr>";
          echo "<th>Table Name</th>";
          echo "<th>Number of Columns</th>";
          echo "<th>Number of Rows</th>";
          echo "<th>Memory (MB)</th>";
          echo "<th>Creation Date</th>";
          echo "<th>Last Update Date</th>";
          echo "<th>Storage Type</th>";
          echo "<th>Collation</th>";
          echo "</tr></thead>";
          echo "<tbody>";
          foreach ($tableData as $table) {
              echo "<tr>";
              echo "<td>" . $table['name'] . "</td>";
              echo "<td>" . $table['columns'] . "</td>";
              echo "<td>" . $table['rows'] . "</td>";
              echo "<td>" . $table['size'] . "</td>";
              echo "<td>" . $table['created'] . "</td>";
              echo "<td>" . $table['updated'] . "</td>";
              echo "<td>" . $table['engine'] . "</td>";
              echo "<td>" . $table['collation'] . "</td>";
              echo "</tr>";
          }
          echo "</tbody>";
          echo "</table>";
          echo '</div>';
      } else {
          echo '<div class="error-message"><i class="fa fa-exclamation-triangle"></i> Database connection error</div>';
      }
      ?>
    </div>
  </div>
</div>