<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('dbmanagement'); ?>

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>Full Database Import/Export</h1>
            <p>Import or export the entire database structure and data</p>
        </div>
    </div>

    <?php if (!empty($conn)): ?>
        <div class="card">
            <div class="card-header">
                <h2 class="card-title"><i class="fas fa-database"></i> Import Full Database</h2>
            </div>
            <div class="card-body">
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div class="alert-content">
                        <h4>Warning</h4>
                        <p>Importing a full database will replace all existing data. Make sure to back up your current database before proceeding.</p>
                    </div>
                </div>
                
                <form method="post" action="<?= route('database/importexportfull') ?>" enctype="multipart/form-data" class="database-form">
                    
                    @csrf

                    <div class="form-group">
                        <label for="file">Select SQL file for full database import:</label>
                        <div class="file-input-wrapper">
                            <input type="file" name="file" id="file" class="form-control">
                            <div class="file-input-label">
                                <i class="fas fa-file-upload"></i>
                                <span>Select File</span>
                            </div>
                        </div>
                        <div class="selected-file" id="selected-file-name">No file selected</div>
                    </div>
                    <div class="form-actions">
                        <input type="submit" name="import" value="Import Full Database" class="form-button danger">
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h2 class="card-title"><i class="fas fa-download"></i> Export Full Database</h2>
            </div>
            <div class="card-body">
                <form method="post" action="<?= route('database/importexportfull') ?>" class="database-form">
                    
                    @csrf
                    
                    <div class="form-group">
                        <label>Export full database as SQL file:</label>
                        <p class="form-help">This will create a complete backup of your database structure and data.</p>
                    </div>
                    <div class="form-actions">
                        <input type="submit" name="exportsql" value="Export Full Database" class="form-button primary">
                    </div>
                </form>
            </div>
        </div>
    <?php else: ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-triangle"></i>
            <div class="alert-content">
                <h4>Connection Error</h4>
                <p>Database connection is not available. Please check your database settings.</p>
            </div>
        </div>
    <?php endif; ?>
</div>