<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('dbmanagement'); ?>

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>Database Tables Import/Export</h1>
            <p>Import SQL files or export tables in CSV or SQL format</p>
        </div>
    </div>

    <?php if (!empty($conn)): ?>
        <div class="card">
            <div class="card-header">
                <h2 class="card-title"><i class="fas fa-file-import"></i> Import SQL File</h2>
            </div>
            <div class="card-body">
                <form method="post" action="<?= route('databases/importexport') ?>" enctype="multipart/form-data" class="database-form">
                    
                    @csrf

                    <div class="form-group">
                        <label for="file">Choose SQL File:</label>
                        <div class="file-input-wrapper">
                            <input type="file" name="file" id="file" class="form-control">
                            <div class="file-input-label">
                                <i class="fas fa-file-upload"></i>
                                <span>Select File</span>
                            </div>
                        </div>
                        <div class="selected-file" id="selected-file-name">No file selected</div>
                    </div>
                    <div class="form-actions">
                        <input type="submit" name="import" value="Import SQL" class="form-button primary">
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h2 class="card-title"><i class="fas fa-file-export"></i> Export Table</h2>
            </div>
            <div class="card-body">
                <form method="post" action="<?= route('databases/importexport') ?>" class="database-form">
                    
                    @csrf
                    
                    <div class="form-group">
                        <label for="table">Select Table:</label>
                        <select name="table" id="table" class="form-control">
                            <?php 
                            $tables = $conn->query("SHOW TABLES");
                            while ($row = $tables->fetch(PDO::FETCH_NUM)): 
                            ?>
                                <option value="<?= htmlspecialchars($row[0]) ?>">
                                    <?= htmlspecialchars($row[0]) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="form-actions">
                        <input type="submit" name="export" value="Export CSV" class="form-button primary">
                        <input type="submit" name="exportsql" value="Export SQL" class="form-button secondary">
                    </div>
                </form>
            </div>
        </div>
    <?php else: ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-triangle"></i>
            <div class="alert-content">
                <h4>Connection Error</h4>
                <p>Database connection is not available. Please check your database settings.</p>
            </div>
        </div>
    <?php endif; ?>
</div>