<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('dbmanagement'); ?>

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>Database Table Management</h1>
            <p>Rename, modify, and manage database tables</p>
        </div>
    </div>

    <?php if (!empty($conn)): ?>
        <?php if (!isset($_POST['selected_table'])): ?>
            <!-- Table Selection Card -->
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title"><i class="fas fa-table"></i> Select Table to Manage</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?= route('database/listandedit') ?>" class="database-form">
                        
                        @csrf

                        <div class="form-group">
                            <label for="selected_table">Select Table:</label>
                            <select name="selected_table" id="selected_table" class="form-control">
                                <?php
                                $tables = $conn->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
                                foreach ($tables as $table):
                                ?>
                                    <option value="<?= htmlspecialchars($table) ?>">
                                        <?= htmlspecialchars($table) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="form-button primary">
                                <i class="fas fa-arrow-right"></i> Continue
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        <?php else: ?>
            <?php 
            $selectedTable = htmlspecialchars($_POST['selected_table']);
            $tableStatus = $conn->query("SHOW TABLE STATUS LIKE '$selectedTable'")->fetch(PDO::FETCH_ASSOC);
            $currentTableType = $tableStatus['Engine'];
            $currentTableCollation = $tableStatus['Collation'];
            
            // Get table info
            $tableRows = $conn->query("SELECT COUNT(*) FROM `$selectedTable`")->fetchColumn();
            $tableSize = round(($tableStatus['Data_length'] + $tableStatus['Index_length']) / 1024 / 1024, 2);
            $columnsCount = $conn->query("SELECT COUNT(*) FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = '$selectedTable'")->fetchColumn();
            ?>

            <div class="table-info-cards">
                <div class="info-card">
                    <div class="info-icon"><i class="fas fa-table"></i></div>
                    <div class="info-content">
                        <div class="info-title">Table Name</div>
                        <div class="info-value"><?= $selectedTable ?></div>
                    </div>
                </div>
                <div class="info-card">
                    <div class="info-icon"><i class="fas fa-database"></i></div>
                    <div class="info-content">
                        <div class="info-title">Rows</div>
                        <div class="info-value"><?= number_format($tableRows) ?></div>
                    </div>
                </div>
                <div class="info-card">
                    <div class="info-icon"><i class="fas fa-columns"></i></div>
                    <div class="info-content">
                        <div class="info-title">Columns</div>
                        <div class="info-value"><?= $columnsCount ?></div>
                    </div>
                </div>
                <div class="info-card">
                    <div class="info-icon"><i class="fas fa-hdd"></i></div>
                    <div class="info-content">
                        <div class="info-title">Size</div>
                        <div class="info-value"><?= $tableSize ?> MB</div>
                    </div>
                </div>
            </div>

            <!-- Rename Table Card -->
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title"><i class="fas fa-edit"></i> Rename Table</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?= route('database/listandedit') ?>" class="database-form">
                
                        @csrf

                        <input type="hidden" name="selected_table" value="<?= $selectedTable ?>">
                        <div class="form-group">
                            <label for="new_table_name">New Table Name:</label>
                            <input type="text" name="new_table_name" id="new_table_name" class="form-control" placeholder="Enter new table name">
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="form-button primary">
                                <i class="fas fa-save"></i> Rename Table
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Change Table Type Card -->
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title"><i class="fas fa-cogs"></i> Change Table Engine</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?= route('database/listandedit') ?>" class="database-form">
                        
                        @csrf

                        <input type="hidden" name="selected_table" value="<?= $selectedTable ?>">
                        <div class="form-group">
                            <label for="new_table_type">Table Engine:</label>
                            <select name="new_table_type" id="new_table_type" class="form-control">
                                <option value="<?= $currentTableType ?>"><?= $currentTableType ?> (Current)</option>
                                <?php if ($currentTableType !== 'MyISAM'): ?>
                                    <option value="MyISAM">MyISAM</option>
                                <?php endif; ?>
                                <?php if ($currentTableType !== 'InnoDB'): ?>
                                    <option value="InnoDB">InnoDB</option>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="form-button primary">
                                <i class="fas fa-save"></i> Change Engine
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Change Collation Card -->
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title"><i class="fas fa-font"></i> Change Table Collation</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?= route('database/listandedit') ?>" class="database-form">
                        
                        @csrf

                        <input type="hidden" name="selected_table" value="<?= $selectedTable ?>">
                        <div class="form-group">
                            <label for="new_table_collation">Table Collation:</label>
                            <select name="new_table_collation" id="new_table_collation" class="form-control">
                                <option value="<?= $currentTableCollation ?>"><?= $currentTableCollation ?> (Current)</option>
                                <?php if ($currentTableCollation !== 'utf8mb4_croatian_ci'): ?>
                                    <option value="utf8mb4_croatian_ci">utf8mb4_croatian_ci</option>
                                <?php endif; ?>
                                <?php if ($currentTableCollation !== 'utf8mb4_general_ci'): ?>
                                    <option value="utf8mb4_general_ci">utf8mb4_general_ci</option>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="form-button primary">
                                <i class="fas fa-save"></i> Change Collation
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Rename Column Card -->
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title"><i class="fas fa-columns"></i> Rename Column</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?= route('database/listandedit') ?>" class="database-form">
                        
                        @csrf

                        <input type="hidden" name="selected_table" value="<?= $selectedTable ?>">
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="column_name">Select Column:</label>
                                <select name="column_name" id="column_name" class="form-control">
                                    <?php
                                    $columns = $conn->query("SHOW COLUMNS FROM `$selectedTable`")->fetchAll(PDO::FETCH_COLUMN);
                                    foreach ($columns as $column):
                                    ?>
                                        <option value="<?= htmlspecialchars($column) ?>">
                                            <?= htmlspecialchars($column) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="new_column_name">New Column Name:</label>
                                <input type="text" name="new_column_name" id="new_column_name" class="form-control" placeholder="Enter new column name">
                            </div>
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="form-button primary">
                                <i class="fas fa-save"></i> Rename Column
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Delete Table Card -->
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title"><i class="fas fa-trash-alt"></i> Delete Table</h2>
                </div>
                <div class="card-body">
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle"></i>
                        <div class="alert-content">
                            <h4>Warning: Destructive Action</h4>
                            <p>Deleting a table will permanently remove all its data. This action cannot be undone.</p>
                        </div>
                    </div>
                    
                    <form method="POST" action="<?= route('database/listandedit') ?>" onsubmit="return confirm('Are you sure you want to delete the table \'<?= $selectedTable ?>\'? This action cannot be undone.')" class="database-form">
                        
                        @csrf

                        <input type="hidden" name="selected_table" value="<?= $selectedTable ?>">
                        <input type="hidden" name="delete_table" value="true">
                        <div class="form-actions">
                            <button type="submit" class="form-button danger">
                                <i class="fas fa-trash-alt"></i> Delete Table
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Back to Table Selection -->
            <div class="form-actions center-aligned">
                <form method="POST" action="<?= route('database/listandedit') ?>"
                    
                    @csrf
                    
                    <button type="submit" class="form-button secondary">
                        <i class="fas fa-arrow-left"></i> Back to Table Selection
                    </button>
                </form>
            </div>
        <?php endif; ?>
    <?php else: ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-triangle"></i>
            <div class="alert-content">
                <h4>Connection Error</h4>
                <p>Database connection is not available. Please check your database settings.</p>
            </div>
        </div>
    <?php endif; ?>
</div>