<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('errordev'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('goback'); ?>

<!-- Background Elements -->
<div class="background">
    <div class="circuit-grid"></div>
    <div class="glow"></div>
    <div class="particles" id="particles"></div>
</div>

<div class="container">

    <div class="header">
        <div class="error-icon"></div>
        <h1>System Error Detected</h1>
        <div class="error-type"><?php echo $error_type; ?></div>
    </div>
    
    <!-- Main Error Information -->
    <div class="panel">

        <div class="panel-header">
            <div class="panel-title">
                <span class="panel-icon">⚠️</span>
                <span>Error Details</span>
            </div>
            <div class="panel-actions">
                <div class="panel-action action-close"></div>
                <div class="panel-action action-minimize"></div>
                <div class="panel-action action-expand"></div>
            </div>
        </div>

        <div class="panel-body">
            <div class="tabs" id="errorTabs">
                <div class="tab active" data-tab="overview">Overview</div>
                <div class="tab" data-tab="details">Technical Details</div>
                <div class="tab" data-tab="trace">Stack Trace</div>
                <div class="tab" data-tab="context">Context</div>
            </div>
            
            <div class="tab-content active" id="overview">
                <div class="info-group">
                    <div class="info-label">Error Message</div>
                    <div class="info-value"><?php echo $error_message; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">Location</div>
                    <div class="info-value one-line"><?php echo $error_file; ?> (line <?php echo $error_line; ?>)</div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">Time of Occurrence</div>
                    <div class="info-value one-line"><?php echo date('Y-m-d H:i:s'); ?></div>
                </div>
            </div>
            
            <div class="tab-content" id="details">
                <div class="info-group">
                    <div class="info-label">Error Type</div>
                    <div class="info-value one-line"><?php echo $error_type; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">File</div>
                    <div class="info-value one-line"><?php echo $error_file; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">Line</div>
                    <div class="info-value one-line"><?php echo $error_line; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">PHP Version</div>
                    <div class="info-value one-line"><?php echo phpversion(); ?></div>
                </div>
            </div>
            
            <div class="tab-content" id="trace">
                <?php 
                $trace_arr = explode("\n", $error_trace);
                if (!empty($trace_arr)): 
                ?>
                <div class="stack-trace">
                    <?php foreach ($trace_arr as $index => $trace_line): 
                        if (empty(trim($trace_line))) continue;
                        
                        // Extract function and file information
                        preg_match('/#\d+\s+(.+)\((.+)\)/', $trace_line, $matches);
                        $function = isset($matches[1]) ? trim($matches[1]) : '';
                        $location = isset($matches[2]) ? trim($matches[2]) : '';
                    ?>
                    <div class="stack-item">
                        <div class="stack-function"><?php echo htmlspecialchars($function ?: $trace_line); ?></div>
                        <?php if ($location): ?>
                        <div class="stack-location">at <?php echo htmlspecialchars($location); ?></div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php else: ?>
                <div class="info-value">No stack trace available</div>
                <?php endif; ?>
            </div>
            
            <div class="tab-content" id="context">
                <div class="info-group">
                    <div class="info-label">Request URL</div>
                    <div class="info-value one-line"><?php echo $_SERVER['REQUEST_URI']; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">HTTP Method</div>
                    <div class="info-value one-line"><?php echo $_SERVER['REQUEST_METHOD']; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">User Agent</div>
                    <div class="info-value one-line"><?php echo $_SERVER['HTTP_USER_AGENT']; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">IP Address</div>
                    <div class="info-value one-line"><?php echo $_SERVER['REMOTE_ADDR']; ?></div>
                </div>
            </div>
        </div>

    </div>
    
    <!-- Code Context -->
    <div class="panel">

        <div class="panel-header">
            <div class="panel-title">
                <span class="panel-icon">📄</span>
                <span>Code Context</span>
            </div>
            <div class="panel-actions">
                <div class="panel-action action-close"></div>
                <div class="panel-action action-minimize"></div>
                <div class="panel-action action-expand"></div>
            </div>
        </div>

        <div class="panel-body">
            <div class="info-group">
                <div class="info-label">File: <?php echo basename($error_file); ?></div>
                <div class="code-block">
                    <?php
                    // Try to read the file and show context around the error line
                    if (file_exists($error_file) && is_readable($error_file)) {
                        $file_lines = file($error_file);
                        $start_line = max(0, $error_line - 5);
                        $end_line = min(count($file_lines), $error_line + 5);
                        
                        for ($i = $start_line; $i < $end_line; $i++) {
                            $line_number = $i + 1;
                            $line = htmlspecialchars($file_lines[$i]);
                            $class = ($line_number == $error_line) ? 'code-line highlight' : 'code-line';
                            echo "<div class=\"$class\" data-line=\"$line_number\">$line</div>";
                        }
                    } else {
                        echo "<div class=\"code-line\">File content could not be read.</div>";
                    }
                    ?>
                </div>
            </div>
        </div>

    </div>
    
    <!-- Server & Environment Data -->
    <div class="panel">

        <div class="panel-header">
            <div class="panel-title">
                <span class="panel-icon">🔧</span>
                <span>Server & Debug Data</span>
            </div>
            <div class="panel-actions">
                <div class="panel-action action-close"></div>
                <div class="panel-action action-minimize"></div>
                <div class="panel-action action-expand"></div>
            </div>
        </div>

        <div class="panel-body">
            <div class="tabs" id="serverTabs">
                <div class="tab active" data-tab="server-info">Server</div>
                <div class="tab" data-tab="request-info">Request</div>
                <div class="tab" data-tab="session-info">Session</div>
                <div class="tab" data-tab="env-info">Environment</div>
                <?php if (isset($error_logs)): ?>
                <div class="tab" data-tab="logs-info">Logs</div>
                <?php endif; ?>
            </div>
            
            <div class="tab-content active" id="server-info">
                <div class="info-group">
                    <div class="info-label">Server Software</div>
                    <div class="info-value one-line"><?php echo $_SERVER['SERVER_SOFTWARE']; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">Document Root</div>
                    <div class="info-value one-line"><?php echo $_SERVER['DOCUMENT_ROOT']; ?></div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">Protocol</div>
                    <div class="info-value one-line"><?php echo $_SERVER['SERVER_PROTOCOL']; ?></div>
                </div>
            </div>
            
            <div class="tab-content" id="request-info">
                <div class="info-group">
                    <div class="info-label">GET Parameters</div>
                    <div class="info-value">
                        <?php 
                        if (!empty($_GET)) {
                            echo "<pre>" . htmlspecialchars(print_r($_GET, true)) . "</pre>";
                        } else {
                            echo "No GET parameters";
                        }
                        ?>
                    </div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">POST Parameters</div>
                    <div class="info-value">
                        <?php 
                        if (!empty($_POST)) {
                            echo "<pre>" . htmlspecialchars(print_r($_POST, true)) . "</pre>";
                        } else {
                            echo "No POST parameters";
                        }
                        ?>
                    </div>
                </div>
                
                <div class="info-group">
                    <div class="info-label">Headers</div>
                    <div class="info-value">
                        <?php 
                        $headers = getallheaders();
                        echo "<pre>" . htmlspecialchars(print_r($headers, true)) . "</pre>";
                        ?>
                    </div>
                </div>
            </div>
            
            <div class="tab-content" id="session-info">
                <div class="info-group">
                    <div class="info-label">Session Data</div>
                    <div class="info-value">
                        <?php 
                        if (isset($_SESSION) && !empty($_SESSION)) {
                            echo "<pre>" . htmlspecialchars(print_r($_SESSION, true)) . "</pre>";
                        } else {
                            echo "No session data available";
                        }
                        ?>
                    </div>
                </div>
            </div>
            
            <div class="tab-content" id="env-info">
                <div class="info-group">
                    <div class="info-label">Environment Variables</div>
                    <div class="info-value">
                        <?php 
                        $env_vars = $_ENV;
                        // Filter out sensitive information
                        foreach ($env_vars as $key => $value) {
                            if (stripos($key, 'pass') !== false || stripos($key, 'secret') !== false || stripos($key, 'key') !== false) {
                                $env_vars[$key] = '***REDACTED***';
                            }
                        }
                        echo "<pre>" . htmlspecialchars(print_r($env_vars, true)) . "</pre>";
                        ?>
                    </div>
                </div>
            </div>
            
            <?php if (isset($error_logs)): ?>
            <div class="tab-content" id="logs-info">
                <div class="info-group">
                    <div class="info-label">Error Logs</div>
                    <div class="info-value">
                        <pre><?php echo htmlspecialchars($error_logs); ?></pre>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
    </div>
    
    <div class="footer">
        <a href="#" class="btn go-back-link">Go Back</a>
        <a href="<?php echo htmlspecialchars(route('/')); ?>" class="btn btn-outline">Go to Homepage</a>
        <p class="support-info">
            Support email:
            <a href="mailto:<?php echo htmlspecialchars(\baseKRIZAN\Config\Config::get('email.admin'), ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars(\baseKRIZAN\Config\Config::get('company'), ENT_QUOTES, 'UTF-8'); ?></a>
        </p>
    </div>
</div>