<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.database'); ?>

<div class="luka-dashboard">
  <!-- Sidebar -->
  <div class="luka-sidebar">
    <div class="luka-sidebar-header">
      <h3>LUKA</h3>
      <p>Digital Twin Monitor</p>
    </div>
    
    <div class="luka-sidebar-content">
      <ul class="luka-nav">
        <li class="luka-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin') ?>" class="luka-nav-link">
            <i class="fas fa-tachometer-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="luka-nav-link">
            <i class="fas fa-chart-pie"></i> Overview
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'performance' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/performance') ?>" class="luka-nav-link">
            <i class="fas fa-chart-line"></i> Performance
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'requests' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-nav-link">
            <i class="fas fa-exchange-alt"></i> Requests
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'database' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/database') ?>" class="luka-nav-link">
            <i class="fas fa-database"></i> Database
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'errors' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-nav-link">
            <i class="fas fa-exclamation-triangle"></i> Errors
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'system' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/system') ?>" class="luka-nav-link">
            <i class="fas fa-cogs"></i> System
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="luka-main">
    <div class="luka-header">
      <h2>Database Performance</h2>
      <div class="luka-header-status">
        <div class="time-range-selector">
          <select id="timeRangeSelect" class="time-range-select">
            <option value="1">Last Hour</option>
            <option value="24" selected>Last 24 Hours</option>
            <option value="168">Last 7 Days</option>
            <option value="720">Last 30 Days</option>
          </select>
        </div>
        <span class="status-badge <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($appState['status']); ?>
        </span>
      </div>
    </div>

    <div class="database-content">
      <!-- Database overview metrics -->
      <div class="metrics-row">
        <div class="metric-card">
          <div class="metric-label">Total Queries</div>
          <div class="metric-value text-primary" id="totalQueries">0</div>
          <div class="metric-small">Selected period</div>
        </div>
        
        <div class="metric-card">
          <div class="metric-label">Avg Query Time</div>
          <div class="metric-value text-info" id="avgQueryTime">0.00</div>
          <div class="metric-small">ms</div>
        </div>
        
        <div class="metric-card">
          <div class="metric-label">Slowest Query</div>
          <div class="metric-value text-warning" id="slowestQuery">0.00</div>
          <div class="metric-small">ms</div>
        </div>
        
        <div class="metric-card">
          <div class="metric-label">Query Percentage</div>
          <div class="metric-value text-success" id="queryPercentage">0.0%</div>
          <div class="metric-small">of request time</div>
        </div>
      </div>
      
      <!-- Database performance chart -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-chart-area"></i> Database Performance
          </div>
          <div class="luka-card-tools">
            <button class="luka-btn secondary" id="refreshDbChart">
              <i class="fas fa-sync-alt"></i> Refresh
            </button>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="chart-container">
            <canvas id="dbPerformanceChart"></canvas>
          </div>
        </div>
      </div>
      
      <!-- Slow queries table -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-clock"></i> Slowest Queries
          </div>
          <div class="luka-card-tools">
            <div class="search-container">
              <input type="text" id="querySearch" placeholder="Search queries...">
              <i class="fas fa-search"></i>
            </div>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="table-responsive">
            <table class="luka-table" id="queriesTable">
              <thead>
                <tr>
                  <th>Query</th>
                  <th>Avg Time</th>
                  <th>Count</th>
                  <th>Last Executed</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td colspan="5" class="loading-state">
                    <div class="loading-spinner"></div>
                    <p>Loading queries data...</p>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      
      <!-- Query details modal (initially hidden) -->
      <div class="luka-modal" id="queryDetailsModal">
        <div class="luka-modal-content">
          <div class="luka-modal-header">
            <h3>Query Details</h3>
            <button class="luka-modal-close" id="closeQueryDetails">&times;</button>
          </div>
          <div class="luka-modal-body">
            <div class="query-details">
              <h4>SQL Query</h4>
              <div class="query-code" id="detailQuerySQL"></div>
              
              <h4>Performance Metrics</h4>
              <div class="details-grid">
                <div class="detail-item">
                  <div class="detail-label">Average Time</div>
                  <div class="detail-value" id="detailAvgTime"></div>
                </div>
                <div class="detail-item">
                  <div class="detail-label">Maximum Time</div>
                  <div class="detail-value" id="detailMaxTime"></div>
                </div>
                <div class="detail-item">
                  <div class="detail-label">Execution Count</div>
                  <div class="detail-value" id="detailCount"></div>
                </div>
                <div class="detail-item">
                  <div class="detail-label">First Seen</div>
                  <div class="detail-value" id="detailFirstSeen"></div>
                </div>
                <div class="detail-item">
                  <div class="detail-label">Last Executed</div>
                  <div class="detail-value" id="detailLastSeen"></div>
                </div>
              </div>
              
              <h4>Sample Parameters</h4>
              <div class="query-params" id="detailParams">No parameters found</div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Query optimization suggestions -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-lightbulb"></i> Query Optimization Suggestions
          </div>
        </div>
        <div class="luka-card-body">
          <div class="suggestion-container" id="querySuggestions">
            <div class="suggestion">
              <div class="suggestion-icon">
                <i class="fas fa-info-circle"></i>
              </div>
              <div class="suggestion-content">
                <h4>Database Performance Analysis</h4>
                <p>The system analyzes database performance to provide optimization suggestions. Please wait while data is being processed...</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>