<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.errors'); ?>

<div class="luka-dashboard">
  <!-- Sidebar -->
  <div class="luka-sidebar">
    <div class="luka-sidebar-header">
      <h3>LUKA</h3>
      <p>Digital Twin Monitor</p>
    </div>
    
    <div class="luka-sidebar-content">
      <ul class="luka-nav">
        <li class="luka-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin') ?>" class="luka-nav-link">
            <i class="fas fa-tachometer-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="luka-nav-link">
            <i class="fas fa-chart-pie"></i> Overview
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'performance' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/performance') ?>" class="luka-nav-link">
            <i class="fas fa-chart-line"></i> Performance
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'requests' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-nav-link">
            <i class="fas fa-exchange-alt"></i> Requests
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'database' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/database') ?>" class="luka-nav-link">
            <i class="fas fa-database"></i> Database
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'errors' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-nav-link">
            <i class="fas fa-exclamation-triangle"></i> Errors
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'system' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/system') ?>" class="luka-nav-link">
            <i class="fas fa-cogs"></i> System
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="luka-main">
    <div class="luka-header">
      <h2>Error Analysis</h2>
      <div class="luka-header-status">
        <div class="filter-controls">
          <select id="timeRangeSelect" class="time-range-select">
            <option value="1">Last Hour</option>
            <option value="24" selected>Last 24 Hours</option>
            <option value="168">Last 7 Days</option>
            <option value="720">Last 30 Days</option>
          </select>
          
          <select id="errorTypeSelect" class="time-range-select">
            <option value="all">All Errors</option>
            <option value="400">400 (Bad Request)</option>
            <option value="401">401 (Unauthorized)</option>
            <option value="403">403 (Forbidden)</option>
            <option value="404">404 (Not Found)</option>
            <option value="500">500 (Server Error)</option>
          </select>
        </div>
        <span class="status-badge <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($appState['status']); ?>
        </span>
      </div>
    </div>

    <div class="errors-content">
      <!-- Error stats -->
      <div class="metrics-row">
        <div class="metric-card">
          <div class="metric-label">Total Errors</div>
          <div class="metric-value text-danger" id="totalErrors">0</div>
          <div class="metric-small">Selected period</div>
        </div>
        
        <div class="metric-card">
          <div class="metric-label">Error Rate</div>
          <div class="metric-value text-warning" id="errorRate">0.0%</div>
          <div class="metric-small">of all requests</div>
        </div>
        
        <div class="metric-card">
          <div class="metric-label">Most Common</div>
          <div class="metric-value text-info" id="mostCommonError">404</div>
          <div class="metric-small">error code</div>
        </div>
        
        <div class="metric-card">
          <div class="metric-label">Top Error Path</div>
          <div class="metric-value text-primary" id="topErrorPath">/unknown</div>
          <div class="metric-small">most errors</div>
        </div>
      </div>
      
      <!-- Error trends chart -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-chart-line"></i> Error Trends
          </div>
          <div class="luka-card-tools">
            <button class="luka-btn secondary" id="refreshErrorChart">
              <i class="fas fa-sync-alt"></i> Refresh
            </button>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="chart-container">
            <canvas id="errorTrendsChart"></canvas>
          </div>
        </div>
      </div>
      
      <!-- Error breakdown -->
      <div class="charts-row">
        <div class="luka-card">
          <div class="luka-card-header">
            <div class="luka-card-title">
              <i class="fas fa-chart-pie"></i> Error Types
            </div>
          </div>
          <div class="luka-card-body">
            <div class="chart-container">
              <canvas id="errorTypesChart"></canvas>
            </div>
          </div>
        </div>
        
        <div class="luka-card">
          <div class="luka-card-header">
            <div class="luka-card-title">
              <i class="fas fa-chart-bar"></i> Top Error Paths
            </div>
          </div>
          <div class="luka-card-body">
            <div class="chart-container">
              <canvas id="errorPathsChart"></canvas>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Error log table -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-list-alt"></i> Error Log
          </div>
          <div class="luka-card-tools">
            <div class="search-container">
              <input type="text" id="errorSearch" placeholder="Search errors...">
              <i class="fas fa-search"></i>
            </div>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="table-responsive">
            <table class="luka-table" id="errorTable">
              <thead>
                <tr>
                  <th>Time</th>
                  <th>Path</th>
                  <th>Status</th>
                  <th>Message</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td colspan="5" class="loading-state">
                    <div class="loading-spinner"></div>
                    <p>Loading error data...</p>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          
          <div class="pagination-controls">
            <button id="prevPage" class="luka-btn secondary" disabled>
              <i class="fas fa-chevron-left"></i> Previous
            </button>
            <span id="pageInfo">Page 1 of 1</span>
            <button id="nextPage" class="luka-btn secondary" disabled>
              Next <i class="fas fa-chevron-right"></i>
            </button>
          </div>
        </div>
      </div>
      
      <!-- Error details modal -->
      <div class="luka-modal" id="errorDetailsModal">
        <div class="luka-modal-content">
          <div class="luka-modal-header">
            <h3>Error Details</h3>
            <button class="luka-modal-close" id="closeErrorDetails">&times;</button>
          </div>
          <div class="luka-modal-body">
            <div class="error-details">
              <div class="error-header">
                <div class="error-status-badge">
                  <span id="detailErrorStatus">500</span>
                </div>
                <div class="error-info">
                  <h4 id="detailErrorTitle">Internal Server Error</h4>
                  <p id="detailErrorPath">/api/users</p>
                </div>
              </div>
              
              <div class="details-grid">
                <div class="detail-item">
                  <div class="detail-label">Method</div>
                  <div class="detail-value" id="detailMethod">GET</div>
                </div>
                <div class="detail-item">
                  <div class="detail-label">Time</div>
                  <div class="detail-value" id="detailTime">2023-05-01 12:34:56</div>
                </div>
                <div class="detail-item">
                  <div class="detail-label">User ID</div>
                  <div class="detail-value" id="detailUserId">Anonymous</div>
                </div>
                <div class="detail-item">
                  <div class="detail-label">IP Address</div>
                  <div class="detail-value" id="detailIp">127.0.0.1</div>
                </div>
              </div>
              
              <h4>Error Message</h4>
              <div class="error-message" id="detailMessage">Unknown error occurred</div>
              
              <h4>Stack Trace</h4>
              <div class="error-stack" id="detailStack">No stack trace available</div>
              
              <h4>Request Context</h4>
              <div class="error-context" id="detailContext">No context available</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>