<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.index'); ?>

<div class="luka-dashboard">
  <!-- Sidebar -->
  <div class="luka-sidebar">
    <div class="luka-sidebar-header">
      <h3>LUKA</h3>
      <p>Digital Twin Monitor</p>
    </div>
    
    <div class="luka-sidebar-content">
      <ul class="luka-nav">
        <li class="luka-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin') ?>" class="luka-nav-link">
            <i class="fas fa-tachometer-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="luka-nav-link">
            <i class="fas fa-chart-pie"></i> Overview
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'performance' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/performance') ?>" class="luka-nav-link">
            <i class="fas fa-chart-line"></i> Performance
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'requests' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-nav-link">
            <i class="fas fa-exchange-alt"></i> Requests
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'database' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/database') ?>" class="luka-nav-link">
            <i class="fas fa-database"></i> Database
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'errors' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-nav-link">
            <i class="fas fa-exclamation-triangle"></i> Errors
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'system' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/system') ?>" class="luka-nav-link">
            <i class="fas fa-cogs"></i> System
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="luka-main">
    <div class="luka-header">
      <h2>Digital Twin Dashboard</h2>
      <div class="luka-header-status">
        <span class="status-badge <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($appState['status']); ?>
        </span>
        <span class="time-display"><?= date('Y-m-d H:i:s'); ?></span>
      </div>
    </div>

    <div class="dashboard-content">
      <div class="quick-actions">
        <h3>Quick Navigation</h3>
        <div class="action-cards">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-chart-pie"></i>
            </div>
            <div class="action-info">
              <h4>Overview</h4>
              <p>Metrics summary and performance trends</p>
            </div>
          </a>
          
          <a href="<?= route('luka/digital-twin/performance') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-chart-line"></i>
            </div>
            <div class="action-info">
              <h4>Performance</h4>
              <p>Detailed performance monitoring</p>
            </div>
          </a>
          
          <a href="<?= route('luka/digital-twin/requests') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-exchange-alt"></i>
            </div>
            <div class="action-info">
              <h4>Requests</h4>
              <p>Analyze request patterns and routes</p>
            </div>
          </a>
          
          <a href="<?= route('luka/digital-twin/database') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-database"></i>
            </div>
            <div class="action-info">
              <h4>Database</h4>
              <p>Database performance and queries</p>
            </div>
          </a>
        </div>
        
        <div class="action-cards">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="action-info">
              <h4>Errors</h4>
              <p>Error analysis and logs</p>
            </div>
          </a>
          
          <a href="<?= route('luka/digital-twin/system') ?>" class="action-card">
            <div class="action-icon">
              <i class="fas fa-cogs"></i>
            </div>
            <div class="action-info">
              <h4>System</h4>
              <p>System information and maintenance</p>
            </div>
          </a>
        </div>
      </div>
      
      <div class="system-status">
        <h3>System Status</h3>
        <div class="status-cards">
          <div class="status-card">
            <div class="status-icon <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
              <i class="fas fa-power-off"></i>
            </div>
            <div class="status-info">
              <h4>Application Status</h4>
              <p><?= ucfirst($appState['status']); ?></p>
            </div>
          </div>
          
          <div class="status-card">
            <div class="status-icon <?= $appState['debug_mode'] ? 'warning' : 'success' ?>">
              <i class="fas fa-bug"></i>
            </div>
            <div class="status-info">
              <h4>Debug Mode</h4>
              <p><?= $appState['debug_mode'] ? 'Enabled' : 'Disabled'; ?></p>
            </div>
          </div>
          
          <div class="status-card">
            <div class="status-icon info">
              <i class="fas fa-memory"></i>
            </div>
            <div class="status-info">
              <h4>Memory Usage</h4>
              <p><?= $appState['memory_usage'] ?? '0 MB'; ?></p>
            </div>
          </div>
          
          <div class="status-card">
            <div class="status-icon info">
              <i class="fas fa-clock"></i>
            </div>
            <div class="status-info">
              <h4>Uptime</h4>
              <p><?= $appState['uptime'] ?? 'Unknown'; ?></p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>