<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.overview'); ?>

<div class="luka-dashboard">
  <!-- Sidebar -->
  <div class="luka-sidebar">
    <div class="luka-sidebar-header">
      <h3>LUKA</h3>
      <p>Digital Twin Monitor</p>
    </div>
    
    <div class="luka-sidebar-content">
      <ul class="luka-nav">
        <li class="luka-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin') ?>" class="luka-nav-link">
            <i class="fas fa-tachometer-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="luka-nav-link">
            <i class="fas fa-chart-pie"></i> Overview
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'performance' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/performance') ?>" class="luka-nav-link">
            <i class="fas fa-chart-line"></i> Performance
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'requests' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-nav-link">
            <i class="fas fa-exchange-alt"></i> Requests
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'database' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/database') ?>" class="luka-nav-link">
            <i class="fas fa-database"></i> Database
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'errors' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-nav-link">
            <i class="fas fa-exclamation-triangle"></i> Errors
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'system' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/system') ?>" class="luka-nav-link">
            <i class="fas fa-cogs"></i> System
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="luka-main">
    <div class="luka-header">
      <h2>System Overview</h2>
      <div class="luka-header-status">
        <span class="status-badge <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($appState['status']); ?>
        </span>
        <span class="time-display"><?= date('Y-m-d H:i:s'); ?></span>
      </div>
    </div>

    <div class="overview-content">
      <!-- Metric Summary Cards -->
      <div class="metrics-summary">
        <div class="metric-row">
          <div class="metric-card">
            <div class="metric-label">Total Requests</div>
            <div class="metric-value text-primary">
              <?= number_format($metricsSummary['total_requests'] ?? 0); ?>
            </div>
            <div class="metric-small">Today</div>
          </div>
          
          <div class="metric-card">
            <div class="metric-label">Avg Response Time</div>
            <div class="metric-value text-info">
              <?= number_format(($metricsSummary['average_response_time'] ?? 0) * 1000, 2); ?>
            </div>
            <div class="metric-small">ms</div>
          </div>
          
          <div class="metric-card">
            <div class="metric-label">Error Rate</div>
            <div class="metric-value <?= ($metricsSummary['error_rate'] ?? 0) > 5 ? 'text-danger' : 'text-success' ?>">
              <?= number_format($metricsSummary['error_rate'] ?? 0, 2); ?>%
            </div>
            <div class="metric-small">Last 24h</div>
          </div>
          
          <div class="metric-card">
            <div class="metric-label">Memory Usage</div>
            <div class="metric-value text-warning">
              <?= $appState['memory_usage'] ?? '0 MB'; ?>
            </div>
            <div class="metric-small">Current</div>
          </div>
        </div>
      </div>
      
      <!-- Performance Charts -->
      <div class="overview-charts">
        <div class="chart-row">
          <div class="luka-card">
            <div class="luka-card-header">
              <div class="luka-card-title">
                <i class="fas fa-tachometer-alt"></i> Performance Trend (24h)
              </div>
              <div class="luka-card-tools">
                <button class="luka-btn secondary" id="refreshPerformanceChart">
                  <i class="fas fa-sync-alt"></i> Refresh
                </button>
              </div>
            </div>
            <div class="luka-card-body">
              <div class="chart-container">
                <canvas id="performanceChart"></canvas>
              </div>
            </div>
          </div>
          
          <div class="luka-card">
            <div class="luka-card-header">
              <div class="luka-card-title">
                <i class="fas fa-memory"></i> Memory Usage Trend (24h)
              </div>
              <div class="luka-card-tools">
                <button class="luka-btn secondary" id="refreshMemoryChart">
                  <i class="fas fa-sync-alt"></i> Refresh
                </button>
              </div>
            </div>
            <div class="luka-card-body">
              <div class="chart-container">
                <canvas id="memoryChart"></canvas>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Recent Data Tables -->
      <div class="overview-tables">
        <div class="table-row">
          <div class="luka-card">
            <div class="luka-card-header">
              <div class="luka-card-title">
                <i class="fas fa-exclamation-circle"></i> Recent Errors
              </div>
              <div class="luka-card-tools">
                <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-btn secondary">
                  <i class="fas fa-eye"></i> View All
                </a>
              </div>
            </div>
            <div class="luka-card-body">
              <table class="luka-table" id="recentErrorsTable">
                <thead>
                  <tr>
                    <th>Path</th>
                    <th>Status</th>
                    <th>Time</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (isset($metricsSummary['recent_errors']) && is_array($metricsSummary['recent_errors'])): ?>
                    <?php foreach (array_slice($metricsSummary['recent_errors'], 0, 5) as $error): ?>
                      <tr>
                        <td><?= htmlspecialchars($error['path']); ?></td>
                        <td>
                          <span class="error-badge"><?= $error['status_code']; ?></span>
                        </td>
                        <td><?= date('H:i:s', strtotime($error['timestamp'])); ?></td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="3" class="empty-table">No recent errors</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
          
          <div class="luka-card">
            <div class="luka-card-header">
              <div class="luka-card-title">
                <i class="fas fa-exchange-alt"></i> Top Accessed Paths
              </div>
              <div class="luka-card-tools">
                <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-btn secondary">
                  <i class="fas fa-eye"></i> View All
                </a>
              </div>
            </div>
            <div class="luka-card-body">
              <table class="luka-table" id="topPathsTable">
                <thead>
                  <tr>
                    <th>Path</th>
                    <th>Count</th>
                    <th>Avg Time</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (isset($metricsSummary['top_paths']) && is_array($metricsSummary['top_paths'])): ?>
                    <?php foreach (array_slice($metricsSummary['top_paths'], 0, 5) as $path): ?>
                      <tr>
                        <td><?= htmlspecialchars($path['path']); ?></td>
                        <td><?= number_format($path['count']); ?></td>
                        <td><?= number_format($path['avg_time'] * 1000, 2); ?> ms</td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="3" class="empty-table">No data available</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Dodaj JSON podatke za inicijalno učitavanje, ako su dostupni -->
<?php if (isset($performanceData) && !empty($performanceData)): ?>
<script type="application/json" id="performance-data">
    <?php
    // Pripremi podatke za chart.js
    $chartData = [
        'labels' => [],
        'values' => []
    ];
    
    foreach ($performanceData as $item) {
        $date = new DateTime($item['hour'] ?? $item['timestamp'] ?? 'now');
        $chartData['labels'][] = $date->format('H:i');
        $chartData['values'][] = ($item['avg_response_time'] ?? 0) * 1000; // Pretvori u milisekunde
    }
    
    echo json_encode($chartData);
    ?>
</script>
<?php endif; ?>

<?php if (isset($memoryData) && !empty($memoryData)): ?>
<script type="application/json" id="memory-data">
    <?php
    // Pripremi podatke za chart.js
    $chartData = [
        'labels' => [],
        'values' => []
    ];
    
    foreach ($memoryData as $item) {
        $date = new DateTime($item['hour'] ?? $item['timestamp'] ?? 'now');
        $chartData['labels'][] = $date->format('H:i');
        $chartData['values'][] = ($item['avg_memory'] ?? 0) / (1024 * 1024); // Pretvori u MB
    }
    
    echo json_encode($chartData);
    ?>
</script>
<?php endif; ?>