<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.performance'); ?>

<div class="luka-dashboard">
  <!-- Sidebar -->
  <div class="luka-sidebar">
    <div class="luka-sidebar-header">
      <h3>LUKA</h3>
      <p>Digital Twin Monitor</p>
    </div>
    
    <div class="luka-sidebar-content">
      <ul class="luka-nav">
        <li class="luka-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin') ?>" class="luka-nav-link">
            <i class="fas fa-tachometer-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="luka-nav-link">
            <i class="fas fa-chart-pie"></i> Overview
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'performance' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/performance') ?>" class="luka-nav-link">
            <i class="fas fa-chart-line"></i> Performance
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'requests' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-nav-link">
            <i class="fas fa-exchange-alt"></i> Requests
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'database' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/database') ?>" class="luka-nav-link">
            <i class="fas fa-database"></i> Database
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'errors' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-nav-link">
            <i class="fas fa-exclamation-triangle"></i> Errors
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'system' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/system') ?>" class="luka-nav-link">
            <i class="fas fa-cogs"></i> System
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="luka-main">
    <div class="luka-header">
      <h2>Performance Analysis</h2>
      <div class="luka-header-status">
        <div class="time-range-selector">
          <select id="performanceTimeRange" class="time-range-select">
            <option value="24">Last 24 Hours</option>
            <option value="72">Last 3 Days</option>
            <option value="168" selected>Last 7 Days</option>
            <option value="720">Last 30 Days</option>
          </select>
        </div>
        <span class="status-badge <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($appState['status']); ?>
        </span>
      </div>
    </div>

    <div class="performance-content">
      <!-- Main performance chart -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-tachometer-alt"></i> Performance Metrics
          </div>
          <div class="luka-card-tools">
            <button class="luka-btn secondary" id="exportPerformanceData">
              <i class="fas fa-download"></i> Export
            </button>
            <button class="luka-btn secondary" id="refreshDetailedChart">
              <i class="fas fa-sync-alt"></i> Refresh
            </button>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="metric-filters">
            <div class="filter-group">
              <label>Metrics</label>
              <div class="checkbox-group">
                <label class="checkbox-label">
                  <input type="checkbox" name="metric" value="response_time" checked>
                  Response Time
                </label>
                <label class="checkbox-label">
                  <input type="checkbox" name="metric" value="request_count" checked>
                  Request Count
                </label>
                <label class="checkbox-label">
                  <input type="checkbox" name="metric" value="error_rate">
                  Error Rate
                </label>
              </div>
            </div>
            
            <div class="filter-group">
              <label>Granularity</label>
              <div class="radio-group">
                <label class="radio-label">
                  <input type="radio" name="granularity" value="hour" checked>
                  Hourly
                </label>
                <label class="radio-label">
                  <input type="radio" name="granularity" value="day">
                  Daily
                </label>
              </div>
            </div>
          </div>
          
          <div class="chart-container detailed-chart-container">
            <canvas id="detailedPerformanceChart"></canvas>
          </div>
        </div>
      </div>
      
      <!-- Component performance breakdown -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-puzzle-piece"></i> Performance Breakdown by Component
          </div>
          <div class="luka-card-tools">
            <button class="luka-btn secondary" id="refreshComponents">
              <i class="fas fa-sync-alt"></i> Refresh
            </button>
          </div>
        </div>
        <div class="luka-card-body">
          <table class="luka-table" id="componentsTable">
            <thead>
              <tr>
                <th>Component</th>
                <th>Avg Time (ms)</th>
                <th>Max Time (ms)</th>
                <th>Calls</th>
                <th>% of Request</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td colspan="5" class="loading-state">
                  <div class="loading-spinner"></div>
                  <p>Loading component data...</p>
                </td>
              </tr>
              <!-- Component data will be loaded here -->
            </tbody>
          </table>
        </div>
      </div>
      
      <!-- Performance insights card -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-lightbulb"></i> Performance Insights
          </div>
        </div>
        <div class="luka-card-body">
          <div class="insights-container" id="performanceInsights">
            <div class="insight">
              <div class="insight-icon">
                <i class="fas fa-info-circle"></i>
              </div>
              <div class="insight-content">
                <h4>Average Performance</h4>
                <p>The system analyzes performance metrics to provide insights. Please wait while data is being processed...</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>