<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.requests'); ?>

<div class="luka-dashboard">
  <!-- Sidebar -->
  <div class="luka-sidebar">
    <div class="luka-sidebar-header">
      <h3>LUKA</h3>
      <p>Digital Twin Monitor</p>
    </div>
    
    <div class="luka-sidebar-content">
      <ul class="luka-nav">
        <li class="luka-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin') ?>" class="luka-nav-link">
            <i class="fas fa-tachometer-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="luka-nav-link">
            <i class="fas fa-chart-pie"></i> Overview
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'performance' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/performance') ?>" class="luka-nav-link">
            <i class="fas fa-chart-line"></i> Performance
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'requests' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-nav-link">
            <i class="fas fa-exchange-alt"></i> Requests
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'database' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/database') ?>" class="luka-nav-link">
            <i class="fas fa-database"></i> Database
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'errors' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-nav-link">
            <i class="fas fa-exclamation-triangle"></i> Errors
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'system' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/system') ?>" class="luka-nav-link">
            <i class="fas fa-cogs"></i> System
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="luka-main">
    <div class="luka-header">
      <h2>Request Analysis</h2>
      <div class="luka-header-status">
        <div class="filter-controls">
          <select id="timeRangeSelect" class="time-range-select">
            <option value="1">Last Hour</option>
            <option value="24" selected>Last 24 Hours</option>
            <option value="168">Last 7 Days</option>
            <option value="720">Last 30 Days</option>
          </select>
          
          <div class="search-container">
            <input type="text" id="routeSearch" placeholder="Search routes...">
            <i class="fas fa-search"></i>
          </div>
        </div>
        <span class="status-badge <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($appState['status']); ?>
        </span>
      </div>
    </div>

    <div class="requests-content">
      <!-- Requests overview chart -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-exchange-alt"></i> Request Volume
          </div>
          <div class="luka-card-tools">
            <button class="luka-btn secondary" id="refreshRequestChart">
              <i class="fas fa-sync-alt"></i> Refresh
            </button>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="chart-container">
            <canvas id="requestsChart"></canvas>
          </div>
        </div>
      </div>
      
      <!-- Routes table -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-map-signs"></i> Top Requested Routes
          </div>
          <div class="luka-card-tools">
            <button class="luka-btn secondary" id="exportRoutesData">
              <i class="fas fa-download"></i> Export
            </button>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="table-responsive">
            <table class="luka-table" id="routesTable">
              <thead>
                <tr>
                  <th class="sortable" data-sort="path">Path</th>
                  <th class="sortable" data-sort="method">Method</th>
                  <th class="sortable" data-sort="count">Count</th>
                  <th class="sortable" data-sort="avg_time">Avg Time</th>
                  <th class="sortable" data-sort="max_time">Max Time</th>
                  <th>Success Rate</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td colspan="6" class="loading-state">
                    <div class="loading-spinner"></div>
                    <p>Loading routes data...</p>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          
          <div class="pagination-controls">
            <button id="prevPage" class="luka-btn secondary" disabled>
              <i class="fas fa-chevron-left"></i> Previous
            </button>
            <span id="pageInfo">Page 1 of 1</span>
            <button id="nextPage" class="luka-btn secondary" disabled>
              Next <i class="fas fa-chevron-right"></i>
            </button>
          </div>
        </div>
      </div>
      
      <!-- Route details panel (initially hidden) -->
      <div class="luka-card route-details" id="routeDetailsPanel">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-info-circle"></i> <span id="routeDetailsTitle">Route Details</span>
          </div>
          <div class="luka-card-tools">
            <button class="luka-btn secondary" id="closeRouteDetails">
              <i class="fas fa-times"></i> Close
            </button>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="details-grid">
            <div class="detail-item">
              <div class="detail-label">Path</div>
              <div class="detail-value" id="detailPath"></div>
            </div>
            <div class="detail-item">
              <div class="detail-label">Method</div>
              <div class="detail-value" id="detailMethod"></div>
            </div>
            <div class="detail-item">
              <div class="detail-label">Request Count</div>
              <div class="detail-value" id="detailCount"></div>
            </div>
            <div class="detail-item">
              <div class="detail-label">Average Time</div>
              <div class="detail-value" id="detailAvgTime"></div>
            </div>
            <div class="detail-item">
              <div class="detail-label">Max Time</div>
              <div class="detail-value" id="detailMaxTime"></div>
            </div>
            <div class="detail-item">
              <div class="detail-label">Min Time</div>
              <div class="detail-value" id="detailMinTime"></div>
            </div>
          </div>
          
          <div class="route-chart">
            <h4>Response Time Distribution</h4>
            <div class="chart-container">
              <canvas id="routeDetailChart"></canvas>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>