<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.base'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('luka.system'); ?>

<div class="luka-dashboard">
  <!-- Sidebar -->
  <div class="luka-sidebar">
    <div class="luka-sidebar-header">
      <h3>LUKA</h3>
      <p>Digital Twin Monitor</p>
    </div>
    
    <div class="luka-sidebar-content">
      <ul class="luka-nav">
        <li class="luka-nav-item <?= $active_page === 'dashboard' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin') ?>" class="luka-nav-link">
            <i class="fas fa-tachometer-alt"></i> Dashboard
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'overview' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/overview') ?>" class="luka-nav-link">
            <i class="fas fa-chart-pie"></i> Overview
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'performance' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/performance') ?>" class="luka-nav-link">
            <i class="fas fa-chart-line"></i> Performance
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'requests' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/requests') ?>" class="luka-nav-link">
            <i class="fas fa-exchange-alt"></i> Requests
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'database' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/database') ?>" class="luka-nav-link">
            <i class="fas fa-database"></i> Database
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'errors' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/errors') ?>" class="luka-nav-link">
            <i class="fas fa-exclamation-triangle"></i> Errors
          </a>
        </li>
        
        <li class="luka-nav-item <?= $active_page === 'system' ? 'active' : '' ?>">
          <a href="<?= route('luka/digital-twin/system') ?>" class="luka-nav-link">
            <i class="fas fa-cogs"></i> System
          </a>
        </li>
      </ul>
    </div>
  </div>

  <!-- Main Content -->
  <div class="luka-main">
    <div class="luka-header">
      <h2>System Information</h2>
      <div class="luka-header-status">
        <span class="status-badge <?= $appState['status'] === 'active' ? 'active' : 'inactive' ?>">
          <?= ucfirst($appState['status']); ?>
        </span>
      </div>
    </div>

    <div class="system-content">
      <!-- System information cards -->
      <div class="info-grid">
        <!-- Application Info -->
        <div class="luka-card info-card">
          <div class="luka-card-header">
            <div class="luka-card-title">
              <i class="fas fa-info-circle"></i> Application Information
            </div>
          </div>
          <div class="luka-card-body">
            <table class="info-table">
              <tr>
                <th>PHP Version</th>
                <td><?= $appState['php_version'] ?? 'Unknown'; ?></td>
              </tr>
              <tr>
                <th>Server Uptime</th>
                <td><?= $appState['uptime'] ?? 'Unknown'; ?></td>
              </tr>
              <tr>
                <th>Memory Usage</th>
                <td><?= $appState['memory_usage'] ?? 'Unknown'; ?></td>
              </tr>
              <tr>
                <th>Debug Mode</th>
                <td>
                  <span class="badge <?= $appState['debug_mode'] ? 'badge-warning' : 'badge-info'; ?>">
                    <?= $appState['debug_mode'] ? 'Enabled' : 'Disabled'; ?>
                  </span>
                </td>
              </tr>
            </table>
          </div>
        </div>
        
        <!-- Metrics Info -->
        <div class="luka-card info-card">
          <div class="luka-card-header">
            <div class="luka-card-title">
              <i class="fas fa-chart-bar"></i> Metrics Storage
            </div>
          </div>
          <div class="luka-card-body">
            <table class="info-table">
              <tr>
                <th>Total Metrics</th>
                <td><?= number_format($appState['metrics_count'] ?? 0); ?></td>
              </tr>
              <tr>
                <th>Storage Type</th>
                <td><?= $config['storage_type'] ?? 'sqlite'; ?></td>
              </tr>
              <tr>
                <th>Data Retention</th>
                <td><?= $config['metrics_retention_days'] ?? 7; ?> days</td>
              </tr>
              <tr>
                <th>Sampling Rate</th>
                <td><?= $config['sampling_rate'] ?? 100; ?>%</td>
              </tr>
            </table>
          </div>
        </div>
        
        <!-- WebSocket Info -->
        <div class="luka-card info-card">
          <div class="luka-card-header">
            <div class="luka-card-title">
              <i class="fas fa-exchange-alt"></i> WebSocket Server
            </div>
          </div>
          <div class="luka-card-body">
            <table class="info-table">
              <tr>
                <th>Status</th>
                <td>
                  <span class="badge <?= $appState['websocket_status'] === 'active' ? 'badge-success' : 'badge-secondary'; ?>">
                    <?= ucfirst($appState['websocket_status'] ?? 'disabled'); ?>
                  </span>
                </td>
              </tr>
              <tr>
                <th>Port</th>
                <td><?= $config['websocket_port'] ?? '8080'; ?></td>
              </tr>
              <tr>
                <th>Real-time Updates</th>
                <td>
                  <span class="badge <?= $config['websocket_enabled'] ? 'badge-success' : 'badge-secondary'; ?>">
                    <?= $config['websocket_enabled'] ? 'Enabled' : 'Disabled'; ?>
                  </span>
                </td>
              </tr>
              <tr>
                <th>Connection URL</th>
                <td><?= $websocketEnabled ? $websocketUrl : 'Not available'; ?></td>
              </tr>
            </table>
          </div>
        </div>
        
        <!-- Tracking Info -->
        <div class="luka-card info-card">
          <div class="luka-card-header">
            <div class="luka-card-title">
              <i class="fas fa-eye"></i> Tracking Configuration
            </div>
          </div>
          <div class="luka-card-body">
            <table class="info-table">
              <tr>
                <th>Database Tracking</th>
                <td>
                  <span class="badge <?= $config['track_database'] ? 'badge-success' : 'badge-secondary'; ?>">
                    <?= $config['track_database'] ? 'Enabled' : 'Disabled'; ?>
                  </span>
                </td>
              </tr>
              <tr>
                <th>Template Tracking</th>
                <td>
                  <span class="badge <?= $config['track_template'] ? 'badge-success' : 'badge-secondary'; ?>">
                    <?= $config['track_template'] ? 'Enabled' : 'Disabled'; ?>
                  </span>
                </td>
              </tr>
              <tr>
                <th>Session Tracking</th>
                <td>
                  <span class="badge <?= $config['track_session'] ? 'badge-success' : 'badge-secondary'; ?>">
                    <?= $config['track_session'] ? 'Enabled' : 'Disabled'; ?>
                  </span>
                </td>
              </tr>
              <tr>
                <th>Assets Tracking</th>
                <td>
                  <span class="badge <?= $config['track_assets'] ? 'badge-success' : 'badge-secondary'; ?>">
                    <?= $config['track_assets'] ? 'Enabled' : 'Disabled'; ?>
                  </span>
                </td>
              </tr>
            </table>
          </div>
        </div>
      </div>
      
      <!-- System logs and events -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-list-alt"></i> System Log
          </div>
          <div class="luka-card-tools">
            <div class="search-container">
              <input type="text" id="logSearch" placeholder="Search logs...">
              <i class="fas fa-search"></i>
            </div>
            <select id="logTypeSelect" class="log-type-select">
              <option value="all">All Logs</option>
              <option value="error">Errors</option>
              <option value="warning">Warnings</option>
              <option value="info">Info</option>
              <option value="debug">Debug</option>
            </select>
          </div>
        </div>
        <div class="luka-card-body">
          <div class="table-responsive">
            <table class="luka-table" id="systemLogTable">
              <thead>
                <tr>
                  <th>Time</th>
                  <th>Type</th>
                  <th>Component</th>
                  <th>Message</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td colspan="5" class="loading-state">
                    <div class="loading-spinner"></div>
                    <p>Loading system logs...</p>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          
          <div class="pagination-controls">
            <button id="prevPage" class="luka-btn secondary" disabled>
              <i class="fas fa-chevron-left"></i> Previous
            </button>
            <span id="pageInfo">Page 1 of 1</span>
            <button id="nextPage" class="luka-btn secondary" disabled>
              Next <i class="fas fa-chevron-right"></i>
            </button>
          </div>
        </div>
      </div>
      
      <!-- Maintenance Actions -->
      <div class="luka-card">
        <div class="luka-card-header">
          <div class="luka-card-title">
            <i class="fas fa-tools"></i> Maintenance Actions
          </div>
        </div>
        <div class="luka-card-body">
          <div class="maintenance-actions">
            <button id="clearMetricsBtn" class="maintenance-btn warning">
              <i class="fas fa-trash"></i>
              <span>Clear Metrics Data</span>
              <span class="btn-description">Remove all collected metrics data</span>
            </button>
            
            <button id="restartWebSocketBtn" class="maintenance-btn primary" <?= !$websocketEnabled ? 'disabled' : ''; ?>>
              <i class="fas fa-sync-alt"></i>
              <span>Restart WebSocket</span>
              <span class="btn-description">Restart the real-time updates server</span>
            </button>
            
            <button id="downloadReportBtn" class="maintenance-btn success">
              <i class="fas fa-download"></i>
              <span>Download Report</span>
              <span class="btn-description">Export performance data as JSON</span>
            </button>
            
            <button id="clearCacheBtn" class="maintenance-btn info">
              <i class="fas fa-broom"></i>
              <span>Clear Cache</span>
              <span class="btn-description">Clear system cache files</span>
            </button>
          </div>
        </div>
      </div>
      
      <!-- Log details modal -->
      <div class="luka-modal" id="logDetailsModal">
        <div class="luka-modal-content">
          <div class="luka-modal-header">
            <h3>Log Details</h3>
            <button class="luka-modal-close" id="closeLogDetails">&times;</button>
          </div>
          <div class="luka-modal-body">
            <div class="log-details">
              <div class="log-header">
                <div class="log-type-badge">
                  <i class="fas fa-info-circle" id="logTypeIcon"></i>
                </div>
                <div class="log-info">
                  <h4 id="logComponent">System Component</h4>
                  <p id="logTimestamp">2023-05-01 12:34:56</p>
                </div>
              </div>
              
              <h4>Message</h4>
              <div class="log-message" id="logDetailMessage">Log message content</div>
              
              <h4>Context Data</h4>
              <div class="log-context" id="logContext">No context data available</div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Action confirmation modal -->
      <div class="luka-modal" id="confirmActionModal">
        <div class="luka-modal-content">
          <div class="luka-modal-header">
            <h3 id="confirmTitle">Confirm Action</h3>
            <button class="luka-modal-close" id="closeConfirmModal">&times;</button>
          </div>
          <div class="luka-modal-body">
            <p id="confirmMessage">Are you sure you want to perform this action?</p>
            
            <div class="confirm-actions">
              <button class="luka-btn secondary" id="cancelActionBtn">Cancel</button>
              <button class="luka-btn danger" id="confirmActionBtn">Confirm</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>