<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('notification.home'); ?>

<div class="layout">
  <div class="layout__left-sidebar">
    <div class="sidebar-menu">
      <div id="unreadMenuItem" class="sidebar-menu__item sidebar-menu__item--active">
        <img src="<?= asset('notification/svg/unread.svg') ?>" class="sidebar-menu__item-icon" />
        <p>Unread</p>
      </div>
      
      <div id="stickyMenuItem" class="sidebar-menu__item">
        <img src="<?= asset('notification/svg/marked.svg') ?>" class="sidebar-menu__item-icon" />
        <p>Marked</p>
      </div>
      
      <div id="readMenuItem" class="sidebar-menu__item">
        <img src="<?= asset('notification/svg/read.svg') ?>" class="sidebar-menu__item-icon" />
        <p>Read</p>
      </div>

      <!-- Nova stavka za "Sve obavijesti" -->
      <div id="allMenuItem" class="sidebar-menu__item">
        <img src="<?= asset('notification/svg/twitter.svg') ?>" class="sidebar-menu__item-icon" />
        <p>All notifications</p>
      </div>
      
      <a href="<?= route('/') ?>">
        <div class="sidebar-menu__item">
          <img src="<?= asset('notification/images/logo.png') ?>" class="tweet__author-logo" />
          <div class="profile-info">
            <p class="profile-name"><?= substr($currentUser->user_email, 0, strpos($currentUser->user_email, '@')) ?></p>
            <p class="profile-username"><?= $currentUser->user_email ?></p>
          </div>
        </div>
      </a>
    </div>
  </div>

  <div class="layout__main">
    <div class="container">
      <!-- Mobile view icons -->
      <div id="tweet-icons">
        <a href="<?= route('/') ?>">
          <div class="sidebar-menu__item">
            <img src="<?= asset('notification/images/logo.png') ?>" class="tweet__author-logo" />
          </div>
        </a>
        <i class="fa-solid fa-magnifying-glass"></i>
        <i class="fa-regular fa-bell"></i>
        <i class="fa-regular fa-envelope"></i>
      </div>

      <!-- Button to mark all notifications as read -->
      <div class="mark-all-container text-right mb-3">
        <button id="mark-all-read" class="btn btn-primary btn-sm">Mark all as read</button>
      </div>

      <!-- Message status area -->
      <span id="message_status"></span>

      <!-- Notifications display area -->
      <div id="notifications-list"></div>

      <!-- Load more notifications -->
      <div id="load-more" class="load-more">Load more</div>
    </div>
  </div>

  <div class="layout__right-sidebar-container">
    <div class="layout__right-sidebar">

      <div class="trends-for-you">

        <div class="trends-for-you__block">
          <div class="trends-for-you__heading">
            Trends for you
          </div>
        </div>

        <div class="trends-for-you__block">
          <div class="trends-for-you__meta-information">
            Trending in <?= htmlspecialchars(\baseKRIZAN\Config\Config::get('company'), ENT_QUOTES, 'UTF-8'); ?>
          </div>
          <div class="trends-for-you__trend-name">
            <a href="<?= route('/') ?>"> #Home </a>
          </div>
          <div class="trends-for-you__meta-information">
            155k Clicks
          </div>
        </div>
        <div class="trends-for-you__block">
          <div class="trends-for-you__meta-information">
            Trending in Notifications
          </div>
          <div class="trends-for-you__trend-name">
            <a href="<?= route('notification/home') ?>"> #Notifications </a>
          </div>
        </div>
        <div class="trends-for-you__block">
          <div class="trends-for-you__meta-information">
            Trending
          </div>
          <div class="trends-for-you__trend-name">
            <a href="<?= route('pm/dashboard') ?>"> #PMdashboard </a>
          </div>
          <div class="trends-for-you__meta-information">
            2,800 Clicks
          </div>
        </div>

      </div>
      
      <div class="who-to-follow">

        <div class="who-to-follow__block">
          <div class="who-to-follow__heading">
            Where could you go
          </div>
        </div>

        <div class="who-to-follow__block">
          <img
            class="who-to-follow__author-logo"
            src="<?= asset('notification/images/logo.png') ?>"
          />
          <div class="who-to-follow__content">
            <div>
              <div class="who-to-follow__author-name">
                CMS
              </div>
              <div class="who-to-follow__author-slug">
                #cms
              </div>
            </div>
              <a href="<?= route('cms') ?>">
                <div class="who-to-follow__button">
                  Go
                </div>
              </a>
          </div>
        </div>
        <div class="who-to-follow__block">
          <img
            class="who-to-follow__author-logo"
            src="<?= asset('notification/images/logo.png') ?>"
          />
          <div class="who-to-follow__content">
            <div>
              <div class="who-to-follow__author-name">
                LukaDigitalTwin
              </div>
              <div class="who-to-follow__author-slug">
                #LukaDigitalTwin
              </div>
            </div>
              <a href="<?= route('luka/digital-twin') ?>">
                <div class="who-to-follow__button">
                  Go
                </div>
              </a>
          </div>
        </div>
        <div class="who-to-follow__block">
          <img
            class="who-to-follow__author-logo"
            src="<?= asset('notification/images/logo.png') ?>"
          />
          <div class="who-to-follow__content">
            <div>
              <div class="who-to-follow__author-name">
                BornaSecurity
              </div>
              <div class="who-to-follow__author-slug">
                #BornaSecurity
              </div>
            </div>
              <a href="<?= route('borna/security') ?>">
                <div class="who-to-follow__button">
                  Go
                </div>
              </a>
          </div>
        </div>

      </div>

    </div>
  </div>

</div>