<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('passwordreset.list'); ?>

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>Password Reset Requests</h1>
            <p>Manage user password reset requests</p>
        </div>
        <div class="header-actions">
            <button id="refreshButton" class="action-button secondary">
                <i class="fas fa-sync-alt"></i> Refresh
            </button>
        </div>
    </div>

    <div class="card reset-list-card">
        <div class="card-header">
            <div class="card-title">
                <i class="fas fa-key"></i> Reset Requests
            </div>
            <div class="card-tools">
                <div class="search-container">
                    <input type="text" id="requestSearch" placeholder="Search requests...">
                    <i class="fas fa-search"></i>
                </div>
                <div class="filter-dropdown">
                    <button class="filter-button">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                    <div class="filter-menu">
                        <div class="filter-group">
                            <label>By Status:</label>
                            <div class="filter-options">
                                <label class="filter-checkbox">
                                    <input type="checkbox" data-filter="status" data-value="active"> 
                                    Active
                                </label>
                                <label class="filter-checkbox">
                                    <input type="checkbox" data-filter="status" data-value="used"> 
                                    Used
                                </label>
                                <label class="filter-checkbox">
                                    <input type="checkbox" data-filter="status" data-value="expired"> 
                                    Expired
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="table-responsive">
            <table id="dataTable" class="data-table">
                <thead>
                    <tr>
                        <th>User ID</th>
                        <th>Email</th>
                        <th>Request Date</th>
                        <th>Actions</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($korisnici as $korisnik) : ?>
                    <tr>
                        <td>
                            <?= htmlspecialchars($korisnik->user_id ?? '', ENT_QUOTES, 'UTF-8') ?>
                        </td>       
                        <td>
                            <div class="user-email">
                                <i class="fas fa-envelope"></i>
                                <?= htmlspecialchars($korisnik->user_email ?? '', ENT_QUOTES, 'UTF-8') ?>
                            </div>
                        </td>   
                        <td>
                            <?php
                            $date = new \DateTime($korisnik->date_requested);
                            $rez = $date->format('d.m.Y H:i');
                            echo htmlspecialchars($rez ?? '', ENT_QUOTES, 'UTF-8');
                            
                            // Calculate time difference for visual indication
                            $now = new \DateTime();
                            $interval = $date->diff($now);
                            $hours = $interval->h + ($interval->days * 24);
                            
                            if ($hours < 24) {
                                echo '<span class="time-badge recent">Today</span>';
                            } elseif ($hours < 48) {
                                echo '<span class="time-badge">Yesterday</span>';
                            }
                            ?>
                        </td>
                        <td>
                            <?php
                                $fixed_subject = htmlspecialchars(\baseKRIZAN\Config\Config::get('appname'), ENT_QUOTES, 'UTF-8') . ' - link za resetiranje lozinke';
                                $mailto_link = "mailto:" . $korisnik->user_email . 
                                            "?subject=" . rawurlencode($fixed_subject) . 
                                            "&body=" . rawurlencode($korisnik->linkzaposlat);
                            ?>
                            <div class="table-actions">
                                <a href="<?=$mailto_link?>" class="action-btn send-email" title="Send Reset Email">
                                    <i class="fas fa-paper-plane"></i>
                                </a>
                                <button type="button" class="action-btn copy-link" data-reset-link="<?=$korisnik->linkzaposlat?>" title="Copy Reset Link">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </td>
                        <td>
                            <?php 
                            $status = strtolower($korisnik->token_status ?? '');
                            $statusClass = 'status-unknown';
                            
                            if ($status === 'active') {
                                $statusClass = 'status-active';
                            } elseif ($status === 'used') {
                                $statusClass = 'status-inactive';
                            } elseif ($status === 'expired') {
                                $statusClass = 'status-pending';
                            }
                            ?>
                            <span class="status-badge <?=$statusClass?>">
                                <?= htmlspecialchars($korisnik->token_status ?? '', ENT_QUOTES, 'UTF-8') ?>
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Copy Link Success Toast -->
<div id="copyToast" class="toast">
    <div class="toast-content">
        <i class="fas fa-check-circle toast-icon"></i>
        <div class="toast-message">Reset link copied to clipboard</div>
    </div>
    <div class="toast-progress"></div>
</div>