<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('login'); ?>

@errormodalreturn

<body class="my-login-page">
    <section class="h-100">
        <div class="container h-100">
            <div class="row justify-content-md-center align-items-center h-100">
                <div class="card-wrapper">
                    <div class="brand">
                        <!-- Logo će biti dodan kroz JavaScript ako nema slike -->
                    </div>
                    <div class="card fat">
                        <div class="card-body">
                            <h4 class="card-title">Reset Password</h4>
                            
                            <form method="POST" action="<?= route('password/update') ?>" class="my-login-validation" novalidate="">

                                @csrf

                                <div class="form-group">
                                    <label for="new-password">New Password</label>
                                    <input 
                                        id="new-password" 
                                        type="password" 
                                        class="form-control" 
                                        name="password" 
                                        required 
                                        autofocus 
                                        data-eye
                                    >
                                    <div class="invalid-feedback">
                                        Password is required
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="confirm-password">Confirm Password</label>
                                    <input 
                                        id="confirm-password" 
                                        type="password" 
                                        class="form-control" 
                                        name="password2" 
                                        required 
                                        data-eye
                                    >
                                    <div class="invalid-feedback">
                                        Please confirm your password
                                    </div>
                                </div>

                                <div class="form-text text-muted mb-3">
                                    Password must be between 8 and 16 characters, include both uppercase and lowercase letters, a number, and a special character.
                                </div>

                                <div class="form-group m-0">
                                    <button type="submit" class="btn btn-dark btn-block">
                                        Reset Password
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="footer copyright">
                        Copyright &copy; <?= date('Y') ?> &mdash; <?= htmlspecialchars(\baseKRIZAN\Config\Config::get('owner'), ENT_QUOTES, 'UTF-8') ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</body>