<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('select2.default');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('select2.userpermissionsfix');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('user.userpermissions');?>

@errormodalreturn

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>Add New User</h1>
            <p>Create a new system user with permissions</p>
        </div>
        <div class="header-actions">
            <a href="<?= route('users/list') ?>" class="action-button secondary">
                <i class="fas fa-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <i class="fas fa-user-plus"></i> User Details
            </div>
        </div>

        <div class="card-body">
            <form action="" method="post">

                @csrf
                
                <div class="form-grid">
                    <div class="user-details-section">
                        <h3 class="section-title">Basic Information</h3>
                        
                        <div class="form-group">
                            <label for="user_email">Email Address <span class="required">*</span></label>
                            <input type="email" id="user_email" class="form-control" name="user_email" 
                                   value="<?= htmlspecialchars($formData['user_email'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                        </div>

                        <div class="form-group">
                            <label for="user_firstandlastname">Full Name <span class="required">*</span></label>
                            <input type="text" id="user_firstandlastname" class="form-control" name="user_firstandlastname" 
                                   value="<?= htmlspecialchars($formData['user_firstandlastname'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                        </div>

                        <div class="form-group">
                            <label for="user_password">Password <span class="required">*</span></label>
                            <div class="password-input-container">
                                <input type="password" id="user_password" class="form-control" name="user_password" required>
                                <button type="button" class="password-toggle" data-target="user_password">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <small class="form-text">Minimum 8 characters, must contain letters and numbers</small>
                        </div>

                        <div class="form-group">
                            <label for="user_password_confirm">Confirm Password <span class="required">*</span></label>
                            <div class="password-input-container">
                                <input type="password" id="user_password_confirm" class="form-control" name="user_password_confirm" required>
                                <button type="button" class="password-toggle" data-target="user_password_confirm">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="user_address">Address</label>
                            <input type="text" class="form-control" id="user_address" name="user_address" 
                                   value="<?= htmlspecialchars($formData['user_address'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                        </div>

                        <div class="form-group">
                            <label for="user_company">Company</label>
                            <select class="form-control" id="user_company" name="user_company">
                                <option value="">Select Company</option>
                                <option value="Optilink" <?= ($formData['user_company'] ?? '') === 'Optilink' ? 'selected' : '' ?>>Optilink</option>
                                <option value="Redit solvex" <?= ($formData['user_company'] ?? '') === 'Redit solvex' ? 'selected' : '' ?>>Redit solvex</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="user_role">Position</label>
                            <select class="form-control" id="user_role" name="user_role">
                                <option value="">Select Position</option>
                                <?php 
                                $roles = ['Tehničar', 'Team leader', 'Voditelj', 'Agent', 'Kontrolor', 'Administrator', 'Supervisor'];
                                foreach ($roles as $role):
                                ?>
                                    <option value="<?= htmlspecialchars($role); ?>" 
                                        <?= ($formData['user_role'] ?? '') === $role ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($role); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="user_modules">Enabled Modules</label>
                            <select class="form-control" multiple id="user_modules" name="user_modules[]">
                                <?php 
                                $userModules = isset($formData['user_modules']) ? explode(', ', $formData['user_modules']) : [];
                                $availableModules = ['Tasks', 'PM', 'Sales'];
                                
                                foreach ($availableModules as $module):
                                ?>
                                    <option value="<?= htmlspecialchars($module, ENT_QUOTES, 'UTF-8'); ?>"
                                        <?= in_array($module, $userModules) ? 'selected' : ''; ?>>
                                        <?= htmlspecialchars($module, ENT_QUOTES, 'UTF-8'); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="checkbox-label">
                                <input type="checkbox" name="email_verified" value="1" 
                                    <?= ($formData['email_verified'] ?? 1) ? 'checked' : '' ?>>
                                Email automatically verified (user can login immediately)
                            </label>
                            <small class="form-text">If unchecked, user will need to verify email before login</small>
                        </div>
                    </div>

                    <div class="permissions-section">
                        <h3 class="section-title">Permission Levels</h3>
                        <div class="permissions-grid">
                            <?php foreach ($permissions as $name => $value) : ?>
                            <div class="permission-item">
                                <label class="permission-checkbox">
                                    <input name="permissions[]" type="checkbox" value="<?=$value?>" 
                                        <?= in_array($value, $formData['permissions'] ?? []) ? 'checked' : '' ?> />
                                    <span class="checkbox-label"><?=ucwords(strtolower(str_replace('_', ' ', $name)))?></span>
                                </label>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="form-button primary">
                        <i class="fas fa-user-plus"></i> Create User
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>