<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('select2.default');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('select2.userpermissionsfix');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('user.userpermissions');?>

@errormodalreturn

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>Edit User: <?=$title?></h1>
            <p>Manage user details and permissions</p>
        </div>
        <div class="header-actions">
            <a href="<?= route('users/list') ?>" class="action-button secondary">
                <i class="fas fa-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <i class="fas fa-user-shield"></i> User Permissions
            </div>
        </div>

        <div class="card-body">
            <form action="" method="post">

                @csrf
                
                <?php if (isset($edit_token)): ?>
                    <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
                <?php endif; ?>

                <div class="form-grid">
                    <div class="permissions-section">
                        <h3 class="section-title">Permission Levels</h3>
                        <div class="permissions-grid">
                            <?php foreach ($permissions as $name => $value) : ?>
                            <div class="permission-item">
                                <label class="permission-checkbox">
                                    <input name="permissions[]" type="checkbox" value="<?=$value?>" 
                                        <?= (($korisnik->user_permissions & $value) === $value) ? 'checked' : '' ?> />
                                    <span class="checkbox-label"><?=ucwords(strtolower(str_replace('_', ' ', $name)))?></span>
                                </label>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="user-details-section">
                        <h3 class="section-title">User Information</h3>
                        
                        <div class="form-group">
                            <label for="user_firstandlastname">Full Name</label>
                            <input type="text" id="user_firstandlastname" class="form-control" name="user_firstandlastname" value="<?= htmlspecialchars($korisnik->user_firstandlastname ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                        </div>

                        <div class="form-group">
                            <label for="user_address">Address</label>
                            <input type="text" class="form-control" id="user_address" name="user_address" value="<?= htmlspecialchars($korisnik->user_address ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                        </div>

                        <div class="form-group">
                            <label for="user_company">Company</label>
                            <select class="form-control" id="user_company" name="user_company">
                                <option value="<?= htmlspecialchars($korisnik->user_company ?? ''); ?>" selected>
                                    <?= htmlspecialchars($korisnik->user_company ?? 'Select Company'); ?>
                                </option>
                                <?php if ($korisnik->user_company !== 'Optilink'): ?>
                                    <option value="Optilink">Optilink</option>
                                <?php endif; ?>
                                <?php if ($korisnik->user_company !== 'Redit solvex'): ?>
                                    <option value="Redit solvex">Redit solvex</option>
                                <?php endif; ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="user_role">Position</label>
                            <select class="form-control" id="user_role" name="user_role">
                                <option value="<?= htmlspecialchars($korisnik->user_role ?? ''); ?>" selected>
                                    <?= htmlspecialchars($korisnik->user_role ?? 'Select Position'); ?>
                                </option>
                                <?php 
                                $roles = ['Tehničar', 'Team leader', 'Voditelj', 'Agent', 'Kontrolor', 'Administrator', 'Supervisor'];
                                foreach ($roles as $role):
                                    if ($korisnik->user_role !== $role):
                                ?>
                                    <option value="<?= htmlspecialchars($role); ?>"><?= htmlspecialchars($role); ?></option>
                                <?php 
                                    endif;
                                endforeach; 
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="user_modules">Enabled Modules</label>
                            <select class="form-control" multiple id="user_modules" name="user_modules[]">
                                <?php 
                                // Parse existing modules
                                $userModules = explode(', ', $korisnik->user_modules ?? '');
                                $availableModules = ['Tasks', 'PM', 'Sales'];
                                
                                // Add all modules as options
                                foreach ($availableModules as $module):
                                ?>
                                    <option value="<?= htmlspecialchars($module, ENT_QUOTES, 'UTF-8'); ?>"
                                        <?= in_array($module, $userModules) ? 'selected' : ''; ?>>
                                        <?= htmlspecialchars($module, ENT_QUOTES, 'UTF-8'); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <!-- Password Change Section -->
                        <div class="password-section">
                            <h4 class="subsection-title">
                                <i class="fas fa-key"></i> Change Password
                                <small>(Leave blank to keep current password)</small>
                            </h4>
                            
                            <div class="form-group">
                                <label for="new_password">New Password</label>
                                <div class="password-input-container">
                                    <input type="password" id="new_password" class="form-control" name="new_password">
                                    <button type="button" class="password-toggle" data-target="new_password">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                                <small class="form-text">Minimum 8 characters, must contain letters and numbers</small>
                            </div>

                            <div class="form-group">
                                <label for="confirm_password">Confirm New Password</label>
                                <div class="password-input-container">
                                    <input type="password" id="confirm_password" class="form-control" name="confirm_password">
                                    <button type="button" class="password-toggle" data-target="confirm_password">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="form-button primary">
                        <i class="fas fa-save"></i> Save Changes
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>