<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('user.userslist'); ?>

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>User Management</h1>
            <p>View, edit and manage system users</p>
        </div>
        <div class="header-actions">
            <a href="<?= route('user/add') ?>" class="action-button primary">
                <i class="fas fa-user-plus"></i> Add New User
            </a>
            <button type="button" id="exportToggle" class="action-button secondary">
                <i class="fas fa-download"></i> Export
            </button>
        </div>
    </div>

    <div class="card user-list-card">
        <div class="card-header">
            <div class="card-title">
                <i class="fas fa-users"></i> System Users
            </div>
            <div class="card-tools">
                <div class="search-container">
                    <input type="text" id="dataSearch" placeholder="Search users...">
                    <i class="fas fa-search"></i>
                </div>
                <div class="filter-dropdown">
                    <button class="filter-button">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                    <div class="filter-menu">
                        <div class="filter-group">
                            <label>By Permission:</label>
                            <div class="filter-options" id="permissionFilter">
                                <?php foreach ($permissions as $name => $value) : ?>
                                <label class="filter-checkbox">
                                    <input type="checkbox" data-filter="permission" data-value="<?= $name ?>"> 
                                    <?= $name ?>
                                </label>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="table-responsive">
            <table id="dataTable" class="data-table">
                <thead>
                    <tr>
                        <th width="80">Actions</th>
                        <th class="sortable">Created</th>
                        <th class="sortable">Email</th>
                        <th class="sortable">Name</th>
                        <th class="sortable">Address</th>
                        <th class="sortable">Company</th>
                        <th class="sortable">Role</th>
                        <th class="sortable">Permissions</th>
                        <th class="sortable">Modules</th>
                        <th class="sortable">Last Login</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($korisnici as $korisnik) : ?>
                    <tr>
                        <td>
                            <div class="table-actions">
                                <a href="<?= route('user/permissions') ?>/<?= $korisnik->id ?>" class="action-btn edit" title="Edit User">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="action-btn delete" data-id="<?=$korisnik->id?>" data-name="<?= htmlspecialchars($korisnik->user_email ?? '', ENT_QUOTES, 'UTF-8') ?>" title="Delete User">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </div>
                        </td>
                        <td>
                            <?php
                            $date = new \DateTime($korisnik->date_created);
                            $rez = $date->format('d.m.Y H:i');
                            echo htmlspecialchars($rez ?? '', ENT_QUOTES, 'UTF-8');
                            ?>
                        </td>
                        <td>
                            <?= htmlspecialchars($korisnik->user_email ?? '', ENT_QUOTES, 'UTF-8') ?>
                        </td>   
                        <td>
                            <?= htmlspecialchars($korisnik->user_firstandlastname ?? '', ENT_QUOTES, 'UTF-8') ?>
                        </td>  
                        <td>
                            <?= htmlspecialchars($korisnik->user_address ?? '', ENT_QUOTES, 'UTF-8') ?>
                        </td>
                        <td>
                            <?= htmlspecialchars($korisnik->user_company ?? '', ENT_QUOTES, 'UTF-8') ?>
                        </td>   
                        <td>
                            <?= htmlspecialchars($korisnik->user_role ?? '', ENT_QUOTES, 'UTF-8') ?>
                        </td>      
                        <td>
                            <div class="permission-badges">
                                <?php foreach ($permissions as $name => $value) : ?>
                                    <?php if ($korisnik->hasPermission($value)) : ?>
                                    <span class="badge" data-permission="<?= $name ?>"><?= htmlspecialchars($name ?? '', ENT_QUOTES, 'UTF-8') ?></span>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        </td>
                        <td>
                            <?= htmlspecialchars($korisnik->user_modules ?? '', ENT_QUOTES, 'UTF-8') ?>
                        </td>
                        <td>
                            <?php
                            if (empty($korisnik->user_lastlogin)) {
                                echo '<span class="status-badge status-inactive">Never logged in</span>';
                            } else {
                                $date = new \DateTime($korisnik->user_lastlogin);
                                $rez = $date->format('d.m.Y H:i');
                                echo htmlspecialchars($rez ?? '', ENT_QUOTES, 'UTF-8');
                            }
                            ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Export Form -->
    <div id="exportPanel" class="export-panel">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    <i class="fas fa-file-export"></i> Export Users
                </div>
                <button id="closeExport" class="close-btn">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="card-body">
                <form action="" method="post" id="exportForm">
                    
                    @csrf
                    
                    <div class="form-group">
                        <label for="file_type">Export Format</label>
                        <select name="file_type" id="file_type" class="form-control">
                            <option value="Xlsx">Excel (XLSX)</option>
                            <option value="Xls">Excel 97-2003 (XLS)</option>
                            <option value="Csv">CSV</option>
                        </select>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" name="export" value="Export" class="form-button primary">
                            <i class="fas fa-download"></i> Export Data
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Confirm Deletion</h3>
            <button class="modal-close">&times;</button>
        </div>
        <div class="modal-body">
            <p>Are you sure you want to delete the user <strong id="deleteName"></strong>?</p>
            <p class="text-danger">This action cannot be undone.</p>
        </div>
        <div class="modal-footer">
            <form action="<?= route('user/delete') ?>" method="post" id="deleteForm">
                
                @csrf
                
                <input type="hidden" name="id" id="deleteId" value="">
                <button type="button" class="form-button secondary modal-cancel">Cancel</button>
                <button type="submit" class="form-button danger">Delete User</button>
            </form>
        </div>
    </div>
</div>