<!DOCTYPE html>
<html lang="en" data-theme="dark">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="author" content="Tomislav Križan">
        <meta name="robots" content="noindex">
        <link rel="icon" href="<?= asset('default/ico/favicon.ico') ?>" type="image/x-icon">

        <title><?=$title ?? ''?></title>

        <!-- Global configuration for JavaScript -->
        <script type="application/json" id="app-config">
            <?= json_encode(\baseKRIZAN\Config\Config::getJavascriptConfig()) ?>
        </script>

        <!-- Store user data if logged in -->
        <?php if ($loggedIn) : ?>
            <script type="application/json" id="user-data">
            <?= json_encode([
                'id' => $user->id,
                'user_email' => $user->user_email,
                'user_permissions' => $user->user_permissions
            ]) ?>
            </script>
        <?php endif; ?>

        <!-- CSRF -->
        @csrf

        <?php
            // First, we need to get the list of enabled modules
            $enabledModules = explode(',', \baseKRIZAN\Config\Config::get('moduli'));
            // Convert to array for easier checking
            $enabledModulesArray = array_map('trim', $enabledModules);
            // Helper function to check if a module is enabled
            function isModuleEnabled($moduleName, $enabledModulesArray) {
                return in_array($moduleName, $enabledModulesArray);
            }
        ?>

        <?php
            \baseKRIZAN\Assets\ResourceLoader::loadResource('default', 10);
            \baseKRIZAN\Assets\ResourceLoader::loadResource('notification.global', 20);
            \baseKRIZAN\Assets\ResourceLoader::generateHeadResources();
        ?>
        
    </head>

    <body>

        <div class="theme-toggle">
            <button id="theme-switch" aria-label="Toggle theme">
                <i class="fas fa-sun light-icon"></i>
                <i class="fas fa-moon dark-icon"></i>
            </button>
        </div>

        <header>
            <nav class="modern-nav">
                <div class="wrapper">
                    <div class="logo">
                        <a href="<?= route('/') ?>">
                            <?= htmlspecialchars(\baseKRIZAN\Config\Config::get('company'), ENT_QUOTES, 'UTF-8') ?>
                        </a>
                    </div>
                    
                    <input type="checkbox" id="menu-toggle" class="menu-toggle">
                    <label for="menu-toggle" class="menu-icon">
                        <span class="hamburger"></span>
                    </label>
                    
                    <div class="nav-container">
                        <ul class="nav-links">
                            <?php if ($loggedIn) : ?>
                                <?php if (isModuleEnabled('tasks', $enabledModulesArray)) : ?>
                                <li class="dropdown">
                                    <a href="#" class="dropdown-trigger"><i class="fas fa-tasks"></i> Tasks <i class="fas fa-chevron-down"></i></a>
                                    <ul class="dropdown-menu">
                                        <li><a href="<?= route('task/edit') ?>"><i class="fas fa-plus"></i> Add task</a></li>
                                        <li class="divider"></li>
                                        <li><a href="<?= route('mytasks/my-tasks') ?>"><i class="fas fa-clipboard-list"></i> My tasks</a></li>
                                        <li class="divider"></li>
                                        <li><a href="<?= route('tasks/list') ?>"><i class="fas fa-list"></i> All tasks</a></li>
                                        <li><a href="<?= route('tasks/admin') ?>"><i class="fas fa-cog"></i> Admin</a></li>
                                    </ul>
                                </li>
                                <?php endif; ?>
    
                                <?php if (isModuleEnabled('travelorders', $enabledModulesArray)) : ?>
                                <li class="dropdown">
                                    <a href="#" class="dropdown-trigger"><i class="fas fa-car"></i> Travel orders <i class="fas fa-chevron-down"></i></a>
                                    <ul class="dropdown-menu">
                                        <li><a href="<?= route('travelorders/edit') ?>"><i class="fas fa-plus"></i> Add travel order</a></li>
                                        <li class="divider"></li>
                                        <li><a href="<?= route('travelorders/list') ?>"><i class="fas fa-list"></i> All travel orders</a></li>
                                    </ul>
                                </li>
                                <?php endif; ?>

                                <?php if (isModuleEnabled('financije', $enabledModulesArray)) : ?>
                                <li class="dropdown">
                                    <a href="#" class="dropdown-trigger"><i class="fas fa-euro-sign"></i> Naplata & Rashodi <i class="fas fa-chevron-down"></i></a>
                                    <ul class="dropdown-menu">
                                        <li><a href="<?= route('naplata/edit') ?>"><i class="fas fa-plus"></i> Dodaj naplatu</a></li>
                                        <li><a href="<?= route('rashodi/edit') ?>"><i class="fas fa-plus"></i> Dodaj rashod</a></li>
                                        <li class="divider"></li>
                                        <li><a href="<?= route('naplata/list') ?>"><i class="fas fa-list"></i> Sve naplate</a></li>
                                        <li><a href="<?= route('rashodi/list') ?>"><i class="fas fa-list"></i> Svi rashodi</a></li>
                                        <li class="divider"></li>
                                        <li><a href="<?= route('financije/admin') ?>"><i class="fas fa-cog"></i> Admin</a></li>
                                    </ul>
                                </li>
                                <?php endif; ?>
                                
                                <?php if (isModuleEnabled('sales', $enabledModulesArray)) : ?>
                                <li class="dropdown">
                                    <a href="#" class="dropdown-trigger"><i class="fas fa-chart-line"></i> Prodaje <i class="fas fa-chevron-down"></i></a>
                                    <ul class="dropdown-menu">
                                        <li><a href="<?= route('sale/edit') ?>"><i class="fas fa-plus"></i> Dodaj prodaju</a></li>
                                        <li class="divider"></li>
                                        <li><a href="<?= route('agentbonusbodovanje/my-bonus') ?>"><i class="fas fa-clipboard-list"></i> Moj bonus</a></li>
                                        <li class="divider"></li>
                                        <li><a href="<?= route('sales/list') ?>"><i class="fas fa-list"></i> Sve prodaje</a></li>
                                        <li><a href="<?= route('sales/admin') ?>"><i class="fas fa-cog"></i> Admin</a></li>
                                    </ul>
                                </li>
                                <?php endif; ?>
                                
                                <?php if (isModuleEnabled('pm', $enabledModulesArray)) : ?>
                                <li class="dropdown">
                                    <a href="#" class="dropdown-trigger"><i class="fas fa-project-diagram"></i> PM <i class="fas fa-chevron-down"></i></a>
                                    <ul class="dropdown-menu">
                                        <li><a href="<?= route('pm/dashboard') ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
                                    </ul>
                                </li>
                                <?php endif; ?>
                            <?php endif ?>

                            <?php if ($loggedIn) : ?>
                            <li><a href='<?= route('logout') ?>'><i class="fas fa-sign-out-alt"></i> Log off</a></li>
                            <?php else : ?>
                            <li><a href='<?= route('login') ?>'><i class="fas fa-sign-in-alt"></i> Log in</a></li>
                            <?php endif; ?>
                            <?php if ($loggedIn && $user->hasMinimumPermission(Models\Entity\Korisnik::KORISNIK_ADMIN)) :?>
                            <li><a href='<?= route('cms') ?>'><i class="fas fa-wrench"></i> CMS</a></li>
                            <?php endif; ?>
                        </ul>

                        <?php if ($loggedIn) : ?>
                            <a href="<?= route('notification/home') ?>" id="notification-icon" class="notification-icon">
                                <i class="fas fa-bell"></i>
                                <span id="notification-count" class="notification-count">0</span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </nav>
        </header>

        <main>
            <div class="content-wrapper">
                <?=$output?>
            </div>
        </main>

        <footer>
            <div class="footer-content">
                <div class="copyright">
                    &copy; <?= date('Y') ?> <?= htmlspecialchars(\baseKRIZAN\Config\Config::get('owner'), ENT_QUOTES, 'UTF-8') ?>
                </div>
                <div class="footer-links">
                    <a href="#" class="footer-link">Terms</a>
                    <a href="#" class="footer-link">Privacy</a>
                    <a href="#" class="footer-link">Support</a>
                </div>
            </div>
        </footer>

        <?php
            \baseKRIZAN\Assets\ResourceLoader::generateBodyResources();
        ?>
        
    </body>

</html>