# Contributing to baseKRIZAN

Thank you for considering contributing to baseKRIZAN! This is a personal learning project, but I welcome feedback, suggestions, and contributions from the community.

## How Can I Contribute?

### Reporting Bugs

If you find a bug in the framework, please create an issue on GitHub with the following information:

- A clear, descriptive title
- Steps to reproduce the issue
- Expected behavior
- Actual behavior
- Any relevant error messages or screenshots
- Your environment (PHP version, web server, etc.)

### Suggesting Enhancements

If you have ideas for improvements or new features, feel free to create an issue with:

- A clear, descriptive title
- A detailed description of the enhancement
- Any relevant examples or mockups
- An explanation of why this enhancement would be useful

### Pull Requests

If you'd like to contribute code:

1. Fork the repository
2. Create a new branch for your feature or bugfix
3. Write your code, adhering to the existing coding style
4. Add appropriate tests if applicable
5. Submit a pull request with a clear description of the changes

## Code Guidelines

- Follow PSR-12 coding standards where possible
- Keep methods small and focused on a single responsibility
- Document your code with PHPDoc comments
- Write meaningful variable and function names
- Use type hints where appropriate

## Questions?

If you have any questions about the framework or how to contribute, feel free to open an issue for discussion.

Again, thank you for your interest in helping improve baseKRIZAN!
