<?php
// ===============================================
// financije_dependencies.php (UPDATED)
// ===============================================

use baseKRIZAN\Services\Container;
use financije\Controllers\Naplata;
use financije\Controllers\Rashodi;
use financije\Controllers\Financije;  // NOVI CONTROLLER
use financije\Models\DatabaseTableNaplata;
use financije\Models\DatabaseTableRashodi;
use baseKRIZAN\Database\DatabaseConnection;

return function(Container $container) {
    $logger = $container->get('logger');
    
    // Dohvatimo DatabaseConnection
    $dbConnection = DatabaseConnection::getInstance();
    
    if ($container->has('eventDispatcher')) {
        $dbConnection->setServices(
            $container->get('eventDispatcher'),
            $logger
        );
    }
    
    // Initialize tables using DatabaseConnection
    $naplataTable = new DatabaseTableNaplata($dbConnection, 'financije_naplata', 'ID', 'stdClass', [], $logger);
    $rashodiTable = new DatabaseTableRashodi($dbConnection, 'financije_rashodi', 'ID', 'stdClass', [], $logger);
    
    // Register tables in container
    $container->addServices([
        'naplataTable' => $naplataTable,
        'rashodiTable' => $rashodiTable,
        'naplataDatabaseConnection' => $dbConnection
    ]);

    // Register controllers in container
    $container->addServices([
        // AŽURIRANI Naplata controller (bez admin metoda)
        'naplataController' => function($container) {
            return new Naplata(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('naplataTable'),
                $container->get('validator'),
                $container->get('naplataDatabaseConnection'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        },
        
        // Rashodi controller ostaje isti
        'rashodiController' => function($container) {
            return new Rashodi(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('rashodiTable'),
                $container->get('validator'),
                $container->get('naplataDatabaseConnection'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        },
        
        // NOVI Financije controller za admin panel
        'financijeController' => function($container) {
            return new Financije(
                $container->get('authentication'),
                $container->get('naplataTable'),
                $container->get('naplataDatabaseConnection'),
                $container->get('logger'),
                $container->get('sessionManager'),
                $container->get('rashodiTable')
            );
        }
    ]);

    return [];
};