<?php
// app/config/financije_routes.php

/**
 * Naplata & Rashodi application routes configuration
 * 
 * @var \baseKRIZAN\Routing\RouteBuilder $builder
 * @var \baseKRIZAN\Services\Container $container
 */

// =============================================
// WEB RUTE - vraćaju HTML stranice
// =============================================

// Osnovne rute za naplatu (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_sales_kontrolor
], function($builder) {
    // Naplata Edit rute
    $builder->get('naplata/edit', ['naplataController', 'edit']);
    $builder->get('naplata/edit/{id:number}', ['naplataController', 'edit']);
    $builder->post('naplata/edit', ['naplataController', 'saveEdit']);
    $builder->post('naplata/edit/{id:number}', ['naplataController', 'saveEdit']);
    
    // Naplata List rute
    $builder->get('naplata/list', ['naplataController', 'list']);
    
    // Rashodi Edit rute
    $builder->get('rashodi/edit', ['rashodiController', 'edit']);
    $builder->get('rashodi/edit/{id:number}', ['rashodiController', 'edit']);
    $builder->post('rashodi/edit', ['rashodiController', 'saveEdit']);
    $builder->post('rashodi/edit/{id:number}', ['rashodiController', 'saveEdit']);
    
    // Rashodi List rute
    $builder->get('rashodi/list', ['rashodiController', 'list']);
});

// Admin rute (web UI) - PREBAČENO NA FINANCIJE CONTROLLER
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_sales_administrator
], function($builder) {
    // Export rute (ostaju na individualnim controllerima)
    $builder->get('naplata/export', ['naplataController', 'export']);
    $builder->get('rashodi/export', ['rashodiController', 'export']);
    
    // NOVI - Kombiniran admin panel (Financije controller)
    $builder->get('financije/admin', ['financijeController', 'admin']);
});

// =============================================
// API RUTE - vraćaju JSON podatke
// =============================================

// API rute za pristup podacima
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_sales_supervisor
], function($builder) {
    // Naplata data fetch
    $builder->post('naplata/api/fetch-naplata', ['naplataController', 'fetchnaplata']);
    
    // Rashodi data fetch
    $builder->post('rashodi/api/fetch-rashodi', ['rashodiController', 'fetchRashodi']);
    
    // NOVI - Financije admin stats API
    $builder->get('financije/api/admin-stats', ['financijeController', 'getAdminStats']);
});

// Master API rute - najviša razina ovlasti
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // Delete API endpoints
    $builder->post('naplata/api/delete', ['naplataController', 'delete']);
    $builder->post('rashodi/api/delete', ['rashodiController', 'delete']);
});