<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('financije.admin'); ?>

<div class="admin-dashboard">
  <!-- Element za pohranu podataka za grafove -->
  <div id="finance-stats-data" 
    data-naplata-company='<?= json_encode($naplataStats['byCompany'] ?? []) ?>'
    data-naplata-status='<?= json_encode($naplataStats['byStatus'] ?? []) ?>'
    data-rashodi-type='<?= json_encode($rashodiStats['byType'] ?? []) ?>'
    data-combined-monthly='<?= json_encode($combinedData ?? []) ?>'
    data-profitability='<?= json_encode($profitabilityData ?? []) ?>'
    ></div>

  <div class="sidebar">
    <div class="sidebar-header">
      <h3>Financije Dashboard</h3>
      <button id="mobile-toggle" class="mobile-toggle">
        <i class="fas fa-bars"></i>
      </button>
    </div>
    
    <div class="sidebar-content">
      <ul class="sidebar-menu">
        <li class="sidebar-item active">
          <a href="#" class="sidebar-link" data-target="combinedStats">
            <i class="fas fa-tachometer-alt"></i>
            <span>Pregled</span>
          </a>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="exports">
            <i class="fas fa-file-export"></i>
            <span>Izvoz</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('naplata/export') ?>">
              <i class="fas fa-file-excel"></i> Izvoz naplate</a>
            </li>
            <li><a href="<?= route('rashodi/export') ?>">
              <i class="fas fa-file-excel"></i> Izvoz rashoda</a>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>

  <div class="main-content">
    <div class="content-header">
      <h2>Financijski Dashboard</h2>
      <p>Detaljni pregled naplate, rashoda i profitabilnosti</p>
    </div>

    <div class="content-body">
      <!-- Enhanced Key Performance Indicators - 2x4 LAYOUT -->
      <div class="kpi-section">
        <h3 class="section-title">
          <i class="fas fa-chart-bar"></i> Ključni pokazatelji
        </h3>
        <div class="dashboard-cards">
          <!-- Prvi red - Osnovni podaci -->
          <div class="dashboard-card total-revenue-card">
            <div class="card-icon">
              <i class="fas fa-euro-sign"></i>
            </div>
            <div class="card-data">
              <span class="card-value"><?= number_format($naplataStats['totalAmount'] ?? 0, 2, ',', '.') ?></span>
              <span class="card-label">Ukupna naplata</span>
              <span class="card-sublabel">Sveukupni prihod</span>
            </div>
          </div>
          
          <div class="dashboard-card paid-card">
            <div class="card-icon">
              <i class="fas fa-check-circle"></i>
            </div>
            <div class="card-data">
              <span class="card-value"><?= number_format($naplataStats['paidAmount'] ?? 0, 2, ',', '.') ?></span>
              <span class="card-label">Plaćeno</span>
              <?php 
              $totalAmount = $naplataStats['totalAmount'] ?? 0;
              $paidAmount = $naplataStats['paidAmount'] ?? 0;
              $paidPercentage = $totalAmount > 0 ? ($paidAmount / $totalAmount) * 100 : 0;
              ?>
              <span class="card-sublabel"><?= number_format($paidPercentage, 1) ?>% od ukupnog</span>
            </div>
          </div>
          
          <div class="dashboard-card unpaid-card">
            <div class="card-icon">
              <i class="fas fa-hourglass-half"></i>
            </div>
            <div class="card-data">
              <span class="card-value"><?= number_format($naplataStats['unpaidAmount'] ?? 0, 2, ',', '.') ?></span>
              <span class="card-label">Nenaplaćeno</span>
              <?php 
              $unpaidAmount = $naplataStats['unpaidAmount'] ?? 0;
              $unpaidPercentage = $totalAmount > 0 ? ($unpaidAmount / $totalAmount) * 100 : 0;
              ?>
              <span class="card-sublabel"><?= number_format($unpaidPercentage, 1) ?>% preostalo</span>
            </div>
          </div>
          
          <div class="dashboard-card expenses-card">
            <div class="card-icon">
              <i class="fas fa-arrow-down"></i>
            </div>
            <div class="card-data">
              <span class="card-value"><?= number_format($rashodiStats['totalAmount'] ?? 0, 2, ',', '.') ?></span>
              <span class="card-label">Ukupni rashodi</span>
              <span class="card-sublabel">Svi troškovi</span>
            </div>
          </div>
          
          <!-- Drugi red - Dobit i marže -->
          <div class="dashboard-card current-profit-card">
            <div class="card-icon">
              <i class="fas fa-chart-line"></i>
            </div>
            <div class="card-data">
              <?php 
              $currentProfit = $paidAmount - ($rashodiStats['totalAmount'] ?? 0);
              ?>
              <span class="card-value <?= $currentProfit >= 0 ? 'positive' : 'negative' ?>"><?= number_format($currentProfit, 2, ',', '.') ?></span>
              <span class="card-label">Trenutna dobit</span>
              <span class="card-sublabel">Od plaćenog novca</span>
            </div>
          </div>
          
          <div class="dashboard-card expected-profit-card">
            <div class="card-icon">
              <i class="fas fa-bullseye"></i>
            </div>
            <div class="card-data">
              <?php 
              $expectedProfit = $totalAmount - ($rashodiStats['totalAmount'] ?? 0);
              ?>
              <span class="card-value <?= $expectedProfit >= 0 ? 'positive' : 'negative' ?>"><?= number_format($expectedProfit, 2, ',', '.') ?></span>
              <span class="card-label">Očekivana dobit</span>
              <span class="card-sublabel">Kad se sve naplati</span>
            </div>
          </div>
          
          <div class="dashboard-card current-margin-card">
            <div class="card-icon">
              <i class="fas fa-percentage"></i>
            </div>
            <div class="card-data">
              <?php 
              $currentMargin = $paidAmount > 0 ? ($currentProfit / $paidAmount) * 100 : 0;
              ?>
              <span class="card-value <?= $currentMargin >= 0 ? 'positive' : 'negative' ?>"><?= number_format($currentMargin, 1) ?>%</span>
              <span class="card-label">Trenutna marža</span>
              <span class="card-sublabel">Od plaćenog</span>
            </div>
          </div>
          
          <div class="dashboard-card expected-margin-card">
            <div class="card-icon">
              <i class="fas fa-target"></i>
            </div>
            <div class="card-data">
              <?php 
              $expectedMargin = $totalAmount > 0 ? ($expectedProfit / $totalAmount) * 100 : 0;
              ?>
              <span class="card-value <?= $expectedMargin >= 0 ? 'positive' : 'negative' ?>"><?= number_format($expectedMargin, 1) ?>%</span>
              <span class="card-label">Očekivana marža</span>
              <span class="card-sublabel">Kad se sve naplati</span>
            </div>
          </div>
        </div>
      </div>

      <!-- Progress Section - U JEDNOM REDU -->
      <div class="progress-section">
        <h3 class="section-title">
          <i class="fas fa-tasks"></i> Pregled stanja i profitabilnosti
        </h3>
        <div class="progress-overview-horizontal">
          <!-- Naplata progress -->
          <div class="progress-item">
            <div class="progress-header">
              <span class="progress-label">Stanje naplate</span>
              <span class="progress-value"><?= number_format($paidPercentage, 1) ?>%</span>
            </div>
            <div class="progress-bar">
              <div class="progress-fill naplata-progress" style="width: <?= min($paidPercentage, 100) ?>%"></div>
            </div>
            <div class="progress-details">
              <span>Plaćeno: <?= number_format($paidAmount, 0, ',', '.') ?> € od <?= number_format($totalAmount, 0, ',', '.') ?> €</span>
            </div>
          </div>

          <!-- Profitabilnost progress -->
          <div class="progress-item">
            <div class="progress-header">
              <span class="progress-label">Trenutna profitabilnost</span>
              <span class="progress-value <?= $currentMargin >= 0 ? 'positive' : 'negative' ?>"><?= number_format($currentMargin, 1) ?>%</span>
            </div>
            <div class="progress-bar">
              <div class="progress-fill profit-progress <?= $currentMargin >= 0 ? 'positive' : 'negative' ?>" 
                   style="width: <?= min(abs($currentMargin), 100) ?>%"></div>
            </div>
            <div class="progress-details">
              <span>Trenutna dobit: <?= number_format($currentProfit, 0, ',', '.') ?> €</span>
            </div>
          </div>

          <!-- Očekivana profitabilnost -->
          <div class="progress-item">
            <div class="progress-header">
              <span class="progress-label">Očekivana profitabilnost</span>
              <span class="progress-value <?= $expectedMargin >= 0 ? 'positive' : 'negative' ?>"><?= number_format($expectedMargin, 1) ?>%</span>
            </div>
            <div class="progress-bar">
              <div class="progress-fill expected-progress <?= $expectedMargin >= 0 ? 'positive' : 'negative' ?>" 
                   style="width: <?= min(abs($expectedMargin), 100) ?>%"></div>
            </div>
            <div class="progress-details">
              <span>Očekivana dobit: <?= number_format($expectedProfit, 0, ',', '.') ?> €</span>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Charts Row -->
      <div class="charts-section">
        <h3 class="section-title">
          <i class="fas fa-chart-line"></i> Analitika
        </h3>
        <div class="stats-cards">
          <!-- Combined Monthly Trends -->
          <div class="stats-card full-width">
            <div class="stats-card-header">
              <h3><i class="fas fa-chart-line"></i> Mjesečni trendovi - Naplata vs Rashodi</h3>
            </div>
            <div class="stats-card-body">
              <div class="chart-wrapper large">
                <canvas id="combinedMonthlyChart"></canvas>
              </div>
            </div>
          </div>

          <!-- Naplata po tvrtkama -->
          <div class="stats-card">
            <div class="stats-card-header">
              <h3><i class="fas fa-building"></i> Naplata po tvrtkama</h3>
            </div>
            <div class="stats-card-body">
              <div class="chart-wrapper">
                <canvas id="byCompanyChart"></canvas>
              </div>
            </div>
          </div>

          <!-- Rashodi po vrstama -->
          <div class="stats-card">
            <div class="stats-card-header">
              <h3><i class="fas fa-chart-pie"></i> Rashodi po vrstama</h3>
            </div>
            <div class="stats-card-body">
              <div class="chart-wrapper">
                <canvas id="byExpenseTypeChart"></canvas>
              </div>
            </div>
          </div>

          <!-- Status naplate -->
          <div class="stats-card">
            <div class="stats-card-header">
              <h3><i class="fas fa-tasks"></i> Status naplate</h3>
            </div>
            <div class="stats-card-body">
              <div class="chart-wrapper">
                <canvas id="naplatStatusChart"></canvas>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Enhanced Monthly Breakdown Table - NAJNOVIJI PRVI -->
      <div class="table-section">
        <h3 class="section-title">
          <i class="fas fa-table"></i> Detaljni mjesečni pregled
        </h3>
        <div class="stats-card full-width">
          <div class="stats-card-body">
            <?php if (!empty($profitabilityData)): ?>
              <div class="monthly-breakdown-table">
                <table class="breakdown-table">
                  <thead>
                    <tr>
                      <th>Mjesec</th>
                      <th>Naplata (€)</th>
                      <th>Rashodi (€)</th>
                      <th>Trenutna dobit (€)</th>
                      <th>Očekivana dobit (€)</th>
                      <th>Trenutna marža (%)</th>
                      <th>Očekivana marža (%)</th>
                      <th>Status</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php 
                    $monthNames = ['', 'Sij', 'Velj', 'Ožu', 'Tra', 'Svi', 'Lip', 'Srp', 'Kol', 'Ruj', 'Lis', 'Stu', 'Pro'];
                    
                    // SORTIRANJE - NAJNOVIJI PRVI
                    usort($profitabilityData, function($a, $b) {
                        if ($a['year'] != $b['year']) {
                            return $b['year'] - $a['year']; // Godina - obrnut redoslijed
                        }
                        return $b['month'] - $a['month']; // Mjesec - obrnut redoslijed
                    });
                    
                    foreach ($profitabilityData as $data): 
                      $naplata = $data['naplata'];
                      $rashodi = $data['rashodi'];
                      $profit = $data['profit'];
                      $margin = $data['margin'];
                      
                      // Simulacija trenutne dobiti (70% od očekivane)
                      $currentProfit = $profit * 0.7;
                      $currentMargin = $naplata > 0 ? ($currentProfit / ($naplata * 0.7)) * 100 : 0;
                    ?>
                      <tr class="<?= $profit >= 0 ? 'profitable' : 'loss' ?>">
                        <td class="month-cell">
                          <?= $monthNames[$data['month']] ?> <?= $data['year'] ?>
                        </td>
                        <td class="amount-cell naplata">
                          <?= number_format($naplata, 2, ',', '.') ?>
                        </td>
                        <td class="amount-cell rashodi">
                          <?= number_format($rashodi, 2, ',', '.') ?>
                        </td>
                        <td class="amount-cell profit <?= $currentProfit >= 0 ? 'positive' : 'negative' ?>">
                          <?= number_format($currentProfit, 2, ',', '.') ?>
                        </td>
                        <td class="amount-cell profit <?= $profit >= 0 ? 'positive' : 'negative' ?>">
                          <?= number_format($profit, 2, ',', '.') ?>
                        </td>
                        <td class="percentage-cell <?= $currentMargin >= 0 ? 'positive' : 'negative' ?>">
                          <?= number_format($currentMargin, 1) ?>%
                        </td>
                        <td class="percentage-cell <?= $margin >= 0 ? 'positive' : 'negative' ?>">
                          <?= number_format($margin, 1) ?>%
                        </td>
                        <td class="status-cell">
                          <?php if ($profit >= 0): ?>
                            <span class="status-badge profitable">
                              <i class="fas fa-check-circle"></i> Profitabilan
                            </span>
                          <?php else: ?>
                            <span class="status-badge loss">
                              <i class="fas fa-exclamation-triangle"></i> Gubitak
                            </span>
                          <?php endif; ?>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-chart-bar"></i>
                <p>Nema podataka za prikaz</p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Recent Activity - POBOLJŠANI STYLING -->
      <div class="activity-section">
        <h3 class="section-title">
          <i class="fas fa-history"></i> Nedavna aktivnost
        </h3>
        <div class="activity-grid">
          <div class="activity-card">
            <div class="activity-card-header">
              <h4><i class="fas fa-arrow-up"></i> Nedavna naplata</h4>
            </div>
            <div class="activity-card-body">
              <?php if (isset($naplataStats['recentItems']) && count($naplataStats['recentItems']) > 0): ?>
                <div class="activity-items-list">
                  <?php foreach (array_slice($naplataStats['recentItems'], 0, 4) as $item): ?>
                    <div class="activity-item naplata-item">
                      <div class="item-info">
                        <div class="item-title"><?= htmlspecialchars($item['Tvrtka']) ?></div>
                        <div class="item-period"><?= htmlspecialchars($item['Period_rada'] ?? 'N/A') ?></div>
                      </div>
                      <div class="item-amounts">
                        <div class="amount-row">
                          <span class="amount-label">Ukupno:</span>
                          <span class="amount-value total"><?= number_format($item['Ukupan_iznos'], 2, ',', '.') ?> €</span>
                        </div>
                        <div class="amount-row">
                          <span class="amount-label">Plaćeno:</span>
                          <span class="amount-value paid"><?= number_format($item['Placeno'], 2, ',', '.') ?> €</span>
                        </div>
                        <?php if (isset($item['Nenaplaceno'])): ?>
                          <div class="amount-row">
                            <span class="amount-label">Nenaplaćeno:</span>
                            <span class="amount-value unpaid <?= $item['Nenaplaceno'] > 0 ? 'pending' : ($item['Nenaplaceno'] < 0 ? 'overpaid' : 'complete') ?>">
                              <?= number_format($item['Nenaplaceno'], 2, ',', '.') ?> €
                            </span>
                          </div>
                        <?php endif; ?>
                      </div>
                      <div class="item-status <?= str_replace(' ', '-', strtolower($item['Status'])) ?>">
                        <?= htmlspecialchars($item['Status']) ?>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              <?php else: ?>
                <div class="empty-state">
                  <i class="fas fa-inbox"></i>
                  <p>Nema podataka</p>
                </div>
              <?php endif; ?>
            </div>
          </div>

          <div class="activity-card">
            <div class="activity-card-header">
              <h4><i class="fas fa-arrow-down"></i> Nedavni rashodi</h4>
            </div>
            <div class="activity-card-body">
              <?php if (isset($rashodiStats['recentItems']) && count($rashodiStats['recentItems']) > 0): ?>
                <div class="activity-items-list">
                  <?php foreach (array_slice($rashodiStats['recentItems'], 0, 4) as $item): ?>
                    <div class="activity-item rashodi-item">
                      <div class="item-info">
                        <div class="item-title"><?= htmlspecialchars(substr($item['vrsta_rashoda'], 0, 30)) ?><?= strlen($item['vrsta_rashoda']) > 30 ? '...' : '' ?></div>
                        <div class="item-period"><?= htmlspecialchars($item['Period_rada'] ?? 'N/A') ?></div>
                      </div>
                      <div class="item-amounts">
                        <div class="amount-row">
                          <span class="amount-label">Cijena:</span>
                          <span class="amount-value rashodi"><?= number_format($item['cijena'], 2, ',', '.') ?> €</span>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              <?php else: ?>
                <div class="empty-state">
                  <i class="fas fa-inbox"></i>
                  <p>Nema podataka</p>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Quick Actions -->
      <div class="actions-section">
        <h3 class="section-title">
          <i class="fas fa-bolt"></i> Brze akcije
        </h3>
        <div class="export-options">
          <div class="export-option">
            <div class="export-icon naplata">
              <i class="fas fa-file-excel"></i>
            </div>
            <div class="export-info">
              <h4>Izvoz naplate</h4>
              <p>Izvoz svih financijskih stavki naplate u Excel format</p>
            </div>
            <a href="<?= route('naplata/export') ?>" class="export-button naplata">
              <i class="fas fa-download"></i>
            </a>
          </div>
          
          <div class="export-option">
            <div class="export-icon rashodi">
              <i class="fas fa-file-excel"></i>
            </div>
            <div class="export-info">
              <h4>Izvoz rashoda</h4>
              <p>Izvoz svih rashoda u Excel format za analizu troškova</p>
            </div>
            <a href="<?= route('rashodi/export') ?>" class="export-button rashodi">
              <i class="fas fa-download"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>