<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('flatpickr');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('financije.editnaplata');?>

@errormodalreturn

<div class="naplata-container">
    <form method="post" class="naplata-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
            <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <div class="naplata-header">
            <h2>
                <?php if (!empty($financija->ID)): ?>
                    Uredi financijsku stavku #<?= htmlspecialchars($financija->ID) ?>
                <?php else: ?>
                    Nova financijska stavka
                <?php endif; ?>
            </h2>
        </div>

        <div class="naplata-content">
            <!-- Osnovni podaci -->
            <div class="naplata-card">
                <div class="naplata-card-header">
                    <h3><i class="fas fa-info-circle"></i> Osnovni podaci</h3>
                    <span class="step-indicator">1/2</span>
                </div>
                <div class="naplata-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="tvrtka">Tvrtka*</label>
                            <select class="form-control" id="tvrtka" name="financija[Tvrtka]" required>
                                <option value="<?= htmlspecialchars($financija->Tvrtka ?? ''); ?>"><?= htmlspecialchars($financija->Tvrtka ?? ''); ?></option>
                                <option>Hrvatski telekom d.d.</option>
                                <option>A1 Hrvatska d.o.o.</option>
                                <option>Telemach Hrvatska d.o.o.</option>
                                <option>United fiber d.o.o.</option>
                            </select>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label for="period_input">Period rada*</label> 
                            <input type="text" 
                                   class="form-control" 
                                   id="period_input" 
                                   name="financija[period_input]" 
                                   required 
                                   value="<?= htmlspecialchars($financija->formatted_period ?? ''); ?>" 
                                   placeholder="MM-YYYY (npr. 03-2025)"
                                   pattern="^\d{1,2}-\d{4}$"
                                   title="Unesite period u formatu MM-YYYY (npr. 03-2025)">
                            <small class="form-text text-muted">Format: MM-YYYY (npr. 03-2025 za ožujak 2025)</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="cijena_bez_pdv">Cijena bez PDV (€)*</label> 
                            <input type="text" class="form-control" id="cijena_bez_pdv" name="financija[Cijena_bez_pdv]" required value="<?= htmlspecialchars($financija->Cijena_bez_pdv ?? ''); ?>" inputmode="numeric" pattern="[0-9,.]+">
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="pdv">PDV (€)</label> 
                            <input type="text" class="form-control" id="pdv" name="financija[PDV]" value="<?= htmlspecialchars($financija->PDV ?? ''); ?>" inputmode="numeric" pattern="[0-9,.]+">
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="ukupan_iznos">Ukupan iznos (€)*</label> 
                            <input type="text" class="form-control" id="ukupan_iznos" name="financija[Ukupan_iznos]" required value="<?= htmlspecialchars($financija->Ukupan_iznos ?? ''); ?>" inputmode="numeric" pattern="[0-9,.]+">
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Status i plaćanje -->
            <div class="naplata-card">
                <div class="naplata-card-header">
                    <h3><i class="fas fa-money-check-alt"></i> Status i plaćanje</h3>
                    <span class="step-indicator">2/2</span>
                </div>
                <div class="naplata-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="valuta_placanja_input">Valuta plaćanja*</label>
                            <div class="input-group">
                                <input type="text" id="valuta_placanja_input" class="form-control" data-input name="financija[Valuta_placanja]" required
                                    value="<?=isset($financija->Valuta_placanja) && $financija->Valuta_placanja ? date('d-m-Y',strtotime($financija->Valuta_placanja)) : ''?>" />
                                <div class="input-group-append" data-toggle>
                                    <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="placeno">Plaćeno (€)*</label> 
                            <input type="text" class="form-control" id="placeno" name="financija[Placeno]" required value="<?= htmlspecialchars($financija->Placeno ?? ''); ?>" inputmode="numeric" pattern="[0-9,.]+">
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="nenaplaceno">Nenaplaćeno (€)</label> 
                            <input type="text" class="form-control" id="nenaplaceno" name="financija[Nenaplaceno]" value="<?= htmlspecialchars($financija->Nenaplaceno ?? ''); ?>" inputmode="numeric" pattern="[0-9,.]+" readonly>
                            <small class="form-text text-muted">Računa se automatski</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-12">
                            <label for="status">Status*</label>
                            <select class="form-control" id="status" name="financija[Status]" required>
                                <option value="<?= htmlspecialchars($financija->Status ?? ''); ?>"><?= htmlspecialchars($financija->Status ?? ''); ?></option>
                                <option>čeka plaćanje</option>
                                <option>plaćeno djelomično</option>
                                <option>naplaćeno u cijelosti</option>
                                <option>kasni s plaćanjem</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="naplata-footer">
            <button type="submit" class="btn btn-primary btn-lg" name="btnSubmit">
                <i class="fas fa-save"></i> Spremi
            </button>
            <a href="<?= route('naplata/list') ?>" class="btn btn-outline-secondary btn-lg">
                <i class="fas fa-times"></i> Odustani
            </a>
        </div>
    </form>
</div>