<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('financije.editrashodi');?>

@errormodalreturn

<div class="naplata-container">
    <form method="post" class="naplata-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
            <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <div class="naplata-header">
            <h2>
                <?php if (!empty($rashod->ID)): ?>
                    Uredi rashod #<?= htmlspecialchars($rashod->ID) ?>
                <?php else: ?>
                    Novi rashod
                <?php endif; ?>
            </h2>
        </div>

        <div class="naplata-content">
            <!-- Osnovni podaci -->
            <div class="naplata-card">
                <div class="naplata-card-header">
                    <h3><i class="fas fa-receipt"></i> Podaci o rashodu</h3>
                    <span class="step-indicator">1/1</span>
                </div>
                <div class="naplata-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="period_input">Period*</label> 
                            <input type="text" 
                                   class="form-control" 
                                   id="period_input" 
                                   name="rashod[period_input]" 
                                   required 
                                   value="<?= htmlspecialchars($rashod->formatted_period ?? ''); ?>" 
                                   placeholder="MM-YYYY (npr. 05-2025)"
                                   pattern="^\d{1,2}-\d{4}$"
                                   title="Unesite period u formatu MM-YYYY (npr. 05-2025)">
                            <small class="form-text text-muted">Format: MM-YYYY (npr. 05-2025 za svibanj 2025)</small>
                        </div>
                        
                        <div class="form-group col-md-5">
                            <label for="vrsta_rashoda">Vrsta rashoda*</label>
                            <select class="form-control" id="vrsta_rashoda" name="rashod[vrsta_rashoda]" required>
                                <option value="">-- Odaberite vrstu rashoda --</option>
                                <?php foreach ($expense_types as $type): ?>
                                    <option value="<?= htmlspecialchars($type) ?>" 
                                            <?= (isset($rashod->vrsta_rashoda) && $rashod->vrsta_rashoda === $type) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($type) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label for="cijena">Cijena (€)*</label> 
                            <input type="text" 
                                   class="form-control" 
                                   id="cijena" 
                                   name="rashod[cijena]" 
                                   required 
                                   value="<?= htmlspecialchars($rashod->cijena ?? ''); ?>" 
                                   inputmode="numeric" 
                                   pattern="[0-9,.]+"
                                   placeholder="0.00">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="naplata-footer">
            <button type="submit" class="btn btn-primary btn-lg" name="btnSubmit">
                <i class="fas fa-save"></i> Spremi
            </button>
            <a href="<?= route('rashodi/list') ?>" class="btn btn-outline-secondary btn-lg">
                <i class="fas fa-times"></i> Odustani
            </a>
        </div>
    </form>
</div>