<?php
// moduli/pm/Module.php

namespace pm;

use baseKRIZAN\Modules\AbstractModule;
use baseKRIZAN\Services\Container;
use baseKRIZAN\Events\EventDispatcher;

/**
 * Implementacija modula Project Management
 * 
 * @package pm
 */
class Module extends AbstractModule
{
    /**
     * @inheritDoc
     */
    protected function registerEventListeners(EventDispatcher $eventDispatcher): void
    {
        $moduleId = $this->getId();
        
        // Registriraj slušatelje za bazne događaje
        $eventDispatcher->addListener('module.activated', function($event) use ($moduleId) {
            $activatedModuleId = $event->get('id');
            if ($activatedModuleId === $moduleId) {
                $this->logger->modules('PM module activated', [
                    'id' => $moduleId,
                    'version' => $this->getVersion()
                ]);
            }
        });
        
        // Registriraj slušatelje za vlastite događaje
        $eventDispatcher->addListener('pm.project_updated', function($event) {
            $projectId = $event->get('project_id');
            $userId = $event->get('user_id');
            
            $this->logger->modules('Project updated event received in module', [
                'project_id' => $projectId,
                'user_id' => $userId
            ]);
            
            // Implementiraj dodatnu logiku...
        });

        // Registriraj slušatelje za vlastite događaje
        $eventDispatcher->addListener('pm.task_created', function($event) {
            $taskId = $event->get('task_id');
            $userId = $event->get('user_id');
            
            $this->logger->modules('Task created event received in module', [
                'task_id' => $taskId,
                'user_id' => $userId
            ]);
            
            // Implementiraj dodatnu logiku...
        });
        
        // Učitaj slušatelje iz posebne datoteke ako postoji
        $eventsFile = $this->path . '/' . $this->getId() . '_events.php';
        if (file_exists($eventsFile)) {
            try {
                $events = include $eventsFile;
                
                if (is_array($events)) {
                    foreach ($events as $eventName => $listeners) {
                        if (is_array($listeners)) {
                            foreach ($listeners as $listener) {
                                if (is_callable($listener)) {
                                    $eventDispatcher->addListener($eventName, $listener);
                                }
                            }
                        }
                    }
                }
            } catch (\Throwable $e) {
                $this->logger->error('Failed to load module event listeners', [
                    'id' => $this->getId(),
                    'error' => $e->getMessage()
                ]);
            }
        }
    }
    
    /**
     * @inheritDoc
     */
    public function bootstrap(Container $container): bool
    {
        if (!parent::bootstrap($container)) {
            return false;
        }
        
        // Dodatna inicijalizacija specifična za PM modul
        // ...
        
        return true;
    }
    
    /**
     * @inheritDoc
     */
    public function activate(Container $container): bool
    {
        if (!parent::activate($container)) {
            return false;
        }
        
        // Dodatna aktivacija specifična za PM modul
        // ...
        
        return true;
    }
    
    /**
     * @inheritDoc
     */
    public function deactivate(Container $container): bool
    {
        if (!parent::deactivate($container)) {
            return false;
        }
        
        // Dodatna deaktivacija specifična za PM modul
        // ...
        
        return true;
    }
}