<?php

use baseKRIZAN\Services\Container;
use pm\Controllers\PM;
use pm\Models\DatabaseTablePM;
use baseKRIZAN\Database\DatabaseConnection;

return function(Container $container) {
   $logger = $container->get('logger');
   
   // Dohvatimo DatabaseConnection umjesto PDO-a
   $dbConnection = DatabaseConnection::getInstance();
   
   // Ako imamo eventDispatcher, postavimo ga na DatabaseConnection
   if ($container->has('eventDispatcher')) {
       $dbConnection->setServices(
           $container->get('eventDispatcher'),
           $logger
       );
   }
   
   // Initialize tables using DatabaseConnection
   $pmTable = new DatabaseTablePM($dbConnection, 'project_management', 'id');

   // Register tables in container
   $container->addServices([
       'pmTable' => $pmTable
   ]);

   // Register controllers
   $container->addServices([
       'pmController' => function($container) {
           return new PM(
            $container->get('korisniciTable'),
            $container->get('authentication'),
            $container->get('pmTable'),
            $container->get('validator'),
            $container->get('logger'),
            $container->get('notificationEnhancerService'),
            $container->get('notificationService'),
            $container->get('sessionManager')
           );
       },
   ]);
   
   return [];
};