<?php
// app/config/pm_routes.php

/**
 * Project Management application routes configuration
 * 
 * @var \baseKRIZAN\Routing\RouteBuilder $builder
 * @var \baseKRIZAN\Services\Container $container
 */

// =============================================
// WEB RUTE - vraćaju HTML stranice
// =============================================

// Project Management rute - za admine i mastere (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_ADMIN, \Models\Entity\Korisnik::KORISNIK_MASTER]
], function($builder) {
    // PM Dashboard
    $builder->get('pm/dashboard', ['pmController', 'dashboard']);
    
    // PM Task management UI
    $builder->get('pm/addtask', ['pmController', 'addtask']);
    $builder->post('pm/addtask', ['pmController', 'addtask']);
    $builder->get('pm/updatetask', ['pmController', 'updatetask']);
    $builder->post('pm/updatetask', ['pmController', 'updatetask']);
});

// =============================================
// API RUTE - vraćaju JSON podatke
// =============================================

// Project Management API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_ADMIN, \Models\Entity\Korisnik::KORISNIK_MASTER]
], function($builder) {
    // PM Tasks data
    $builder->get('pm/api/get-tasks', ['pmController', 'gettasks']);
    $builder->post('pm/api/get-tasks', ['pmController', 'gettasks']);
    
    // Task CRUD operations
    $builder->post('pm/api/edit-task', ['pmController', 'edittask']);
    $builder->post('pm/api/delete-task', ['pmController', 'deletetask']);
});