<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('pm.dashboard'); ?>

<div class="content-container">
    <div class="page-header">
        <div class="header-content">
            <h1>Project Management</h1>
            <p>Drag and drop tasks between columns to update their status</p>
        </div>
    </div>

    <div class="kanban-board">
        <div id="todo" class="kanban-column">
            <h3>To Do</h3>
            <div class="task-list" id="todo-list"></div>
        </div>

        <div id="in_progress" class="kanban-column">
            <h3>In Progress</h3>
            <div class="task-list" id="in_progress-list"></div>
        </div>

        <div id="done" class="kanban-column">
            <h3>Done</h3>
            <div class="task-list" id="done-list"></div>
        </div>
    </div>
</div>

<!-- Add Task i Recycle Floating Buttons -->
<button class="recycle-btn" id="recycleButton" title="Drag tasks here to delete">
    <i class="fas fa-trash-alt"></i>
</button>
<button class="add-task-btn" id="addTaskButton" title="Add new task">
    <i class="fas fa-plus"></i> Add New Task
</button>

<!-- Add/Edit Task Modal -->
<div id="taskModal" class="modal">
    <div class="modal-content">
        <button class="close-btn" id="closeModalButton">×</button>
        <h2 id="modalTitle">Edit Task</h2>
        <form id="taskForm">
            <input type="hidden" id="taskId" value="" />
            <div class="form-group">
                <label for="taskTitle">Title</label>
                <input type="text" id="taskTitle" placeholder="Enter task title" required />
            </div>
            <div class="form-group">
                <label for="taskDescription">Description</label>
                <textarea id="taskDescription" placeholder="Enter task description" required></textarea>
            </div>
            <button type="submit" id="submitButton">Update Task</button>
        </form>
    </div>
</div>

<!-- Confirmation Modal -->
<div id="confirmModal" class="modal">
    <div class="modal-content">
        <h2>Confirm Deletion</h2>
        <p>Are you sure you want to delete this task? This action cannot be undone.</p>
        <div class="modal-buttons">
            <button id="deleteConfirmButton" class="delete-btn">Delete</button>
            <button id="cancelDeleteButton" class="cancel-btn">Cancel</button>
        </div>
    </div>
</div>