/**
 * Sales Form Permission Handler
 * 
 * Enables form fields based on user's sales roles
 * - KORISNIK_sales_agent (32)
 * - KORISNIK_sales_kontrolor (64)
 * - KORISNIK_sales_administrator (128)
 * - KORISNIK_sales_supervisor (256)
 */
document.addEventListener('DOMContentLoaded', function() {
    // Define constants for permissions (matching PHP constants)
    const PERMISSIONS = {
        SALES_AGENT: 32,
        SALES_KONTROLOR: 64,
        SALES_ADMINISTRATOR: 128,
        SALES_SUPERVISOR: 256
    };
    
    // Fields to be enabled based on permissions
    const FIELDS = {
        sale_brojnarudzbe: document.getElementById('sale_brojnarudzbe'),
        sale_djelatnik: document.getElementById('sale_djelatnik'),
        sale_kontrolor: document.getElementById('sale_kontrolor'),
        sale_status: document.getElementById('sale_status'),
        sale_kontrolnipoziv: document.getElementById('sale_kontrolnipoziv'),
        sale_statusdate: document.getElementById('sale_statusdate_input')
    };
        
    // Function to check if user has any of the required permissions
    function hasSalesPermission(permissions) {
        return !!(
            (permissions & PERMISSIONS.SALES_AGENT) || 
            (permissions & PERMISSIONS.SALES_KONTROLOR) || 
            (permissions & PERMISSIONS.SALES_ADMINISTRATOR) || 
            (permissions & PERMISSIONS.SALES_SUPERVISOR)
        );
    }
    
    // Function to enable form fields based on specific permissions
    function enableFormFields(permissions) {
        const fieldsToEnable = [];
        
        if (permissions & PERMISSIONS.SALES_KONTROLOR) {
            fieldsToEnable.push('sale_brojnarudzbe', 'sale_status', 'sale_kontrolnipoziv');
        }
        
        if (permissions & PERMISSIONS.SALES_ADMINISTRATOR) {
            fieldsToEnable.push('sale_brojnarudzbe', 'sale_djelatnik', 'sale_kontrolor', 'sale_status', 'sale_kontrolnipoziv', 'sale_statusdate');
        }
        
        if (permissions & PERMISSIONS.SALES_SUPERVISOR) {
            fieldsToEnable.push('sale_brojnarudzbe', 'sale_djelatnik', 'sale_kontrolor', 'sale_status', 'sale_kontrolnipoziv', 'sale_statusdate');
        }
        
        // Omogućite navedena polja
        fieldsToEnable.forEach(fieldId => {
            if (FIELDS[fieldId]) {
                // Ukloni sales-locked klasu za sva polja
                FIELDS[fieldId].classList.remove('sales-locked');
                
                // Ako je datum polje, omogući i ikonu kalendara
                if (fieldId === 'sale_statusdate') {
                    const calendarIcon = FIELDS[fieldId].closest('.input-group').querySelector('.input-group-text');
                    if (calendarIcon) {
                        calendarIcon.classList.remove('sales-locked');
                    }
                }
            }
        });
        
        return fieldsToEnable.length > 0;
    }
    
    // Get user data from JSON script tag
    const userDataElement = document.getElementById('user-data');
    const userData = userDataElement ? JSON.parse(userDataElement.textContent) : null;
    // Get user permissions
    const userPermissions = userData?.user_permissions;
    
    // If we found permissions, check and enable fields
    if (userPermissions !== undefined) {
        if (hasSalesPermission(userPermissions)) {
            const enabled = enableFormFields(userPermissions);
        } else {
            console.log('User does not have any sales permissions');
        }
    } else {
        console.warn('Could not find user permissions data');
    }
});