/**
 * JavaScript funkcionalnosti za obrazac za uređivanje prodaje
 */
$(function () {
    // Dohvati ID prodaje iz data atributa
    const saleId = $('.form-header').data('sale-id');
    
    // Inicijalizacija datepickera za datum rođenja
    const birthDatePicker = flatpickr("#sale_datumrodj_input", {
        dateFormat: "d.m.Y",
        locale: "hr",
        allowInput: true,
        disableMobile: true,
        appendTo: document.body,
        position: "auto"
    });
    
    // Učini ikonu kalendara klikabilnom za datum rođenja
    $("#sale_datumrodj_input").closest(".input-group").find(".input-group-text").on("click", function() {
        birthDatePicker.open();
    });
    
    // Inicijalizacija datepickera za datum promjene statusa
    const statusDatePicker = flatpickr("#sale_statusdate_input", {
        dateFormat: "d-m-Y",
        enableTime: true,
        time_24hr: true,
        locale: "hr",
        allowInput: true,
        disableMobile: true,
        appendTo: document.body,
        position: "auto",
        onOpen: function(selectedDates, dateStr, instance) {
            // Provjera je li polje zaključano
            if (instance.input.classList.contains('sales-locked')) {
                instance.close(); // Odmah zatvori picker ako je polje zaključano
                return;
            }
            // Spremi originalni datum i vrijeme
            const originalDate = instance.selectedDates[0] ? new Date(instance.selectedDates[0]) : null;
            const now = new Date();
            instance.hourElement.value = now.getHours();
            instance.minuteElement.value = now.getMinutes();
            if (originalDate) {
                instance.setDate(originalDate, false);
            }
        }
    });
    
    // Učini ikonu kalendara klikabilnom za datum promjene statusa
    $("#sale_statusdate_input").closest(".input-group").find(".input-group-text").on("click", function() {
        // Provjera je li polje zaključano
        if (!$("#sale_statusdate_input").hasClass('sales-locked')) {
            statusDatePicker.open();
        }
    });
    
    // Napomena: OIB provjera se obavlja u zasebnom check_oib.js fileu
    // Upravljanje dozvolama korisnika se obavlja u zasebnom sales_permissions.js fileu
});