<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.agentbonusbodovanje'); ?>

<div class="admin-dashboard">
  <!-- Data container for charts -->
  <div id="agentbonusbodovanje-charts-data" 
    data-monthly-trend='<?= json_encode($statistics['monthlyTrend'] ?? []) ?>'
    data-group-distribution='<?= json_encode($statistics['groupDistribution'] ?? []) ?>'
    data-top-performers='<?= json_encode($statistics['topPerformers'] ?? []) ?>'
    ></div>

  <div class="sidebar">
    <div class="sidebar-header">
      <h3>Agent Bonus Bodovanje</h3>
      <button id="mobile-toggle" class="mobile-toggle">
        <i class="fas fa-bars"></i>
      </button>
    </div>
    
    <div class="sidebar-content">
      <ul class="sidebar-menu">
        <li class="sidebar-item active">
          <a href="#" class="sidebar-link" data-target="dashboard">
            <i class="fas fa-trophy"></i>
            <span>Dashboard</span>
          </a>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="reports">
            <i class="fas fa-chart-line"></i>
            <span>Izvještaji</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('agentbonusbodovanje/detail') ?>">
              <i class="fas fa-search"></i> Detaljni izvještaj</a>
            </li>
            <li><a href="<?= route('agentbonusbodovanje/print') ?>">
              <i class="fas fa-print"></i> Ispis</a>
            </li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="exports">
            <i class="fas fa-file-export"></i>
            <span>Izvoz</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('agentbonusbodovanje/export') ?>">
              <i class="fas fa-file-excel"></i> Excel izvoz</a>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>

  <div class="main-content">
    <div class="content-header">
      <h2>Agent Bonus Bodovanje Dashboard</h2>
      <p>Pregled bodova i otključanih razreda za <?= date('F Y', mktime(0, 0, 0, $statistics['currentMonth'], 1, $statistics['currentYear'])) ?></p>
      
      <!-- Period Filter -->
      <div class="period-filter">
        <form method="GET" class="filter-form">
          <div class="filter-group">
            <label for="month">Mjesec:</label>
            <select name="month" id="month">
              <?php for ($m = 1; $m <= 12; $m++): ?>
                <option value="<?= str_pad($m, 2, '0', STR_PAD_LEFT) ?>" 
                  <?= $statistics['currentMonth'] == str_pad($m, 2, '0', STR_PAD_LEFT) ? 'selected' : '' ?>>
                  <?= date('F', mktime(0, 0, 0, $m, 1)) ?>
                </option>
              <?php endfor; ?>
            </select>
          </div>
          <div class="filter-group">
            <label for="year">Godina:</label>
            <select name="year" id="year">
              <?php for ($y = date('Y') - 2; $y <= date('Y') + 1; $y++): ?>
                <option value="<?= $y ?>" <?= $statistics['currentYear'] == $y ? 'selected' : '' ?>>
                  <?= $y ?>
                </option>
              <?php endfor; ?>
            </select>
          </div>
          <button type="submit" class="filter-button">
            <i class="fas fa-filter"></i> Filtriraj
          </button>
        </form>
      </div>
    </div>

    <div class="content-body">
      <!-- Main Summary Cards -->
      <div class="dashboard-cards">
        <div class="dashboard-card points-card">
          <div class="card-icon">
            <i class="fas fa-star"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= number_format($statistics['totalPoints'] ?? 0) ?></span>
            <span class="card-label">UKUPNI BODOVI</span>
            <span class="card-period">
              <?= date('F Y', mktime(0, 0, 0, $statistics['currentMonth'], 1, $statistics['currentYear'])) ?>
            </span>
          </div>
        </div>
        
        <div class="dashboard-card bonus-card">
          <div class="card-icon">
            <i class="fas fa-euro-sign"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= number_format($statistics['totalBonus'] ?? 0) ?> €</span>
            <span class="card-label">UKUPNI BONUS</span>
            <span class="card-period">
              Otključani razredi
            </span>
          </div>
        </div>
        
        <div class="dashboard-card agents-card">
          <div class="card-icon">
            <i class="fas fa-users"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['activeAgents'] ?? 0 ?></span>
            <span class="card-label">AKTIVNI DJELATNICI</span>
            <span class="card-period">
              S bodovima > 0
            </span>
          </div>
        </div>
      </div>
      
      <!-- Charts Row -->
      <div class="stats-cards">
        <!-- Monthly Points Trend -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-line"></i> Mjesečni trend bodova</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="monthlyPointsChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Group Distribution Chart -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-pie"></i> Distribucija bodova po grupama</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="groupDistributionChart"></canvas>
            </div>
          </div>
        </div>
      </div>

      <!-- Agent Groups Breakdown - 3 CARDS GRID -->
      <div class="agent-groups-grid">
        <!-- MNP Agents -->
        <div class="group-card mnp-card">
          <div class="group-card-header">
            <h3><i class="fas fa-exchange-alt"></i> MNP Djelatnici</h3>
            <small>MNP + Parica + Optika + Tomato</small>
          </div>
          <div class="group-card-body">
            <?php if (!empty($statistics['mnpAgents'])): ?>
              <div class="group-summary">
                <div class="summary-stats">
                  <div class="stat-item">
                    <span class="stat-value"><?= count($statistics['mnpAgents']) ?></span>
                    <span class="stat-label">djelatnika</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-value"><?= number_format(array_sum(array_column($statistics['mnpAgents'], 'total_points'))) ?></span>
                    <span class="stat-label">bodova</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-value"><?= number_format(array_sum(array_column($statistics['mnpAgents'], 'bonus_amount'))) ?> €</span>
                    <span class="stat-label">bonus</span>
                  </div>
                </div>
              </div>
              
              <div class="agents-list">
                <?php foreach ($statistics['mnpAgents'] as $agent): ?>
                  <div class="agent-item">
                    <div class="agent-info">
                      <span class="agent-name"><?= htmlspecialchars($agent['agent_name']) ?></span>
                      <span class="agent-rank rank-<?= strtolower($agent['current_rank']) ?>"><?= $agent['current_rank'] ?></span>
                    </div>
                    <div class="agent-stats">
                      <span class="agent-points"><?= number_format($agent['total_points']) ?> bodova</span>
                      <span class="agent-bonus"><?= number_format($agent['bonus_amount']) ?> €</span>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-info-circle"></i>
                <p>Nema MNP djelatnika s bodovima ovaj mjesec</p>
              </div>
            <?php endif; ?>
          </div>
        </div>

        <!-- Optika Agents -->
        <div class="group-card optika-card">
          <div class="group-card-header">
            <h3><i class="fas fa-wifi"></i> Optika Djelatnici</h3>
            <small>Optika + MNP + Parica + Tomato</small>
          </div>
          <div class="group-card-body">
            <?php if (!empty($statistics['optikaAgents'])): ?>
              <div class="group-summary">
                <div class="summary-stats">
                  <div class="stat-item">
                    <span class="stat-value"><?= count($statistics['optikaAgents']) ?></span>
                    <span class="stat-label">djelatnika</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-value"><?= number_format(array_sum(array_column($statistics['optikaAgents'], 'total_points'))) ?></span>
                    <span class="stat-label">bodova</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-value"><?= number_format(array_sum(array_column($statistics['optikaAgents'], 'bonus_amount'))) ?> €</span>
                    <span class="stat-label">bonus</span>
                  </div>
                </div>
              </div>
              
              <div class="agents-list">
                <?php foreach ($statistics['optikaAgents'] as $agent): ?>
                  <div class="agent-item">
                    <div class="agent-info">
                      <span class="agent-name"><?= htmlspecialchars($agent['agent_name']) ?></span>
                      <span class="agent-rank rank-<?= strtolower($agent['current_rank']) ?>"><?= $agent['current_rank'] ?></span>
                    </div>
                    <div class="agent-stats">
                      <span class="agent-points"><?= number_format($agent['total_points']) ?> bodova</span>
                      <span class="agent-bonus"><?= number_format($agent['bonus_amount']) ?> €</span>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-info-circle"></i>
                <p>Nema Optika djelatnika s bodovima ovaj mjesec</p>
              </div>
            <?php endif; ?>
          </div>
        </div>

        <!-- P2P Agents -->
        <div class="group-card p2p-card">
          <div class="group-card-header">
            <h3><i class="fas fa-network-wired"></i> P2P Djelatnici</h3>
            <small>Uvjet: min 280 P2P usluga</small>
          </div>
          <div class="group-card-body">
            <?php if (!empty($statistics['p2pAgents'])): ?>
              <div class="group-summary">
                <div class="summary-stats">
                  <div class="stat-item">
                    <span class="stat-value"><?= count($statistics['p2pAgents']) ?></span>
                    <span class="stat-label">djelatnika</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-value"><?= number_format(array_sum(array_column($statistics['p2pAgents'], 'total_points'))) ?></span>
                    <span class="stat-label">bodova</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-value"><?= number_format(array_sum(array_column($statistics['p2pAgents'], 'bonus_amount'))) ?> €</span>
                    <span class="stat-label">bonus</span>
                  </div>
                </div>
              </div>
              
              <div class="agents-list">
                <?php foreach ($statistics['p2pAgents'] as $agent): ?>
                  <div class="agent-item">
                    <div class="agent-info">
                      <span class="agent-name"><?= htmlspecialchars($agent['agent_name']) ?></span>
                      <span class="agent-rank rank-<?= strtolower($agent['current_rank']) ?>"><?= $agent['current_rank'] ?></span>
                    </div>
                    <div class="agent-stats">
                      <span class="agent-points"><?= number_format($agent['total_points']) ?> bodova</span>
                      <span class="agent-bonus"><?= number_format($agent['bonus_amount']) ?> €</span>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-info-circle"></i>
                <p>Nema P2P djelatnika s bodovima ovaj mjesec</p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Top Performers -->
      <div class="management-cards">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-trophy"></i> Najbolji djelatnici po bodovima
            </h3>
          </div>
          <div class="card-body">
            <?php if (!empty($statistics['topPerformers'])): ?>
              <div class="top-performers-table">
                <div class="table-header">
                  <div class="header-col">Pozicija</div>
                  <div class="header-col">Djelatnik</div>
                  <div class="header-col">Grupa</div>
                  <div class="header-col">Bodovi</div>
                  <div class="header-col">Razred</div>
                  <div class="header-col">Bonus</div>
                </div>
                <?php foreach ($statistics['topPerformers'] as $index => $performer): ?>
                  <div class="table-row">
                    <div class="table-col position">
                      <span class="position-badge position-<?= $index + 1 ?>"><?= $index + 1 ?></span>
                    </div>
                    <div class="table-col agent-name"><?= htmlspecialchars($performer['agent_name']) ?></div>
                    <div class="table-col agent-group">
                      <span class="group-badge group-<?= $performer['agent_group'] ?>"><?= strtoupper($performer['agent_group']) ?></span>
                    </div>
                    <div class="table-col points"><?= number_format($performer['total_points']) ?></div>
                    <div class="table-col rank">
                      <span class="rank-badge rank-<?= strtolower($performer['current_rank']) ?>"><?= $performer['current_rank'] ?></span>
                    </div>
                    <div class="table-col bonus"><?= number_format($performer['bonus_amount']) ?> €</div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-trophy"></i>
                <p>Nema djelatnika s bodovima ovaj mjesec</p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Quick Actions -->
      <div class="management-cards">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-bolt"></i> Brze akcije
            </h3>
          </div>
          <div class="card-body">
            <div class="quick-actions">
              <a href="<?= route('agentbonusbodovanje/detail') ?>?month=<?= $statistics['currentMonth'] ?>&year=<?= $statistics['currentYear'] ?>" class="action-button primary">
                <i class="fas fa-search"></i> Detaljni izvještaj
              </a>
              <a href="<?= route('agentbonusbodovanje/export') ?>?month=<?= $statistics['currentMonth'] ?>&year=<?= $statistics['currentYear'] ?>" class="action-button secondary">
                <i class="fas fa-file-export"></i> Izvoz podataka
              </a>
              <a href="<?= route('agentbonusbodovanje/print') ?>?month=<?= $statistics['currentMonth'] ?>&year=<?= $statistics['currentYear'] ?>" class="action-button tertiary">
                <i class="fas fa-print"></i> Ispis
              </a>
              <a href="<?= route('agentbonus') ?>" class="action-button tertiary">
                <i class="fas fa-chart-bar"></i> Agent Bonus (klasični)
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>