<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.agentbonusbodovanjemybonus'); ?>

<div class="my-bonus-dashboard">
  <!-- Data container for charts -->
  <div id="my-bonus-charts-data" 
    data-historical-performance='<?= json_encode($statistics['historicalPerformance'] ?? []) ?>'
    data-service-breakdown='<?= json_encode($statistics['agentStats']['service_breakdown'] ?? []) ?>'
    data-ranking-system='<?= json_encode($statistics['rankingSystem'] ?? []) ?>'
    ></div>

  <div class="dashboard-header">
    <div class="agent-welcome">
      <h1><i class="fas fa-user-circle"></i> Moj Bonus Dashboard</h1>
      <p class="agent-info">
        Dobrodošli, <strong><?= htmlspecialchars($statistics['agentName']) ?></strong> 
        <span class="agent-group group-<?= $statistics['agentGroup'] ?>"><?= strtoupper($statistics['agentGroup']) ?></span>
      </p>
      <p class="period-info">Pregled za <?= date('F Y', mktime(0, 0, 0, $statistics['currentMonth'], 1, $statistics['currentYear'])) ?></p>
    </div>
    
    <!-- Period Filter -->
    <div class="period-filter">
      <form method="GET" class="filter-form">
        <div class="filter-group">
          <label for="month">Mjesec:</label>
          <select name="month" id="month">
            <?php for ($m = 1; $m <= 12; $m++): ?>
              <option value="<?= str_pad($m, 2, '0', STR_PAD_LEFT) ?>" 
                <?= $statistics['currentMonth'] == str_pad($m, 2, '0', STR_PAD_LEFT) ? 'selected' : '' ?>>
                <?= date('F', mktime(0, 0, 0, $m, 1)) ?>
              </option>
            <?php endfor; ?>
          </select>
        </div>
        <div class="filter-group">
          <label for="year">Godina:</label>
          <select name="year" id="year">
            <?php for ($y = date('Y') - 2; $y <= date('Y') + 1; $y++): ?>
              <option value="<?= $y ?>" <?= $statistics['currentYear'] == $y ? 'selected' : '' ?>>
                <?= $y ?>
              </option>
            <?php endfor; ?>
          </select>
        </div>
        <button type="submit" class="filter-button">
          <i class="fas fa-filter"></i> Filtriraj
        </button>
      </form>
    </div>
  </div>

  <!-- Main Stats Cards -->
  <div class="stats-overview">
    <div class="stat-card points-card">
      <div class="stat-icon">
        <i class="fas fa-star"></i>
      </div>
      <div class="stat-content">
        <div class="stat-value"><?= number_format($statistics['agentStats']['total_points'] ?? 0) ?></div>
        <div class="stat-label">Ukupni bodovi</div>
        <?php if (isset($statistics['agentStats']['points_difference'])): ?>
          <div class="stat-change <?= $statistics['agentStats']['points_difference'] >= 0 ? 'positive' : 'negative' ?>">
            <i class="fas fa-<?= $statistics['agentStats']['points_difference'] >= 0 ? 'arrow-up' : 'arrow-down' ?>"></i>
            <?= abs($statistics['agentStats']['points_difference']) ?> od prošlog mjeseca
          </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="stat-card rank-card">
      <div class="stat-icon">
        <i class="fas fa-medal"></i>
      </div>
      <div class="stat-content">
        <div class="stat-value rank-<?= strtolower($statistics['agentStats']['current_rank'] ?? 'nema') ?>">
          <?= $statistics['agentStats']['current_rank'] ?? 'Nema' ?>
        </div>
        <div class="stat-label">Trenutni razred</div>
        <?php if (isset($statistics['agentStats']['previous_month_rank'])): ?>
          <div class="stat-change">
            Prošli mjesec: <?= $statistics['agentStats']['previous_month_rank'] ?>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="stat-card bonus-card">
      <div class="stat-icon">
        <i class="fas fa-euro-sign"></i>
      </div>
      <div class="stat-content">
        <div class="stat-value"><?= number_format($statistics['agentStats']['bonus_amount'] ?? 0) ?> €</div>
        <div class="stat-label">Bonus iznos</div>
        <div class="stat-change">
          Otključani razred
        </div>
      </div>
    </div>

    <div class="stat-card position-card">
      <div class="stat-icon">
        <i class="fas fa-trophy"></i>
      </div>
      <div class="stat-content">
        <div class="stat-value"><?= $statistics['groupRanking']['position'] ?? 'N/A' ?></div>
        <div class="stat-label">Pozicija u grupi</div>
        <div class="stat-change">
          od <?= $statistics['groupRanking']['total_agents'] ?? 0 ?> agenata
        </div>
      </div>
    </div>
  </div>

  <!-- Progress to Next Rank -->
  <?php if (!empty($statistics['nextRankRequirements']['next_rank'])): ?>
  <div class="next-rank-section">
    <div class="next-rank-card">
      <div class="rank-header">
        <h3><i class="fas fa-target"></i> Napredak do sljedećeg razreda</h3>
      </div>
      <div class="rank-content">
        <div class="rank-info">
          <div class="current-next">
            <span class="current-rank rank-<?= strtolower($statistics['agentStats']['current_rank'] ?? 'nema') ?>">
              <?= $statistics['agentStats']['current_rank'] ?? 'Nema' ?>
            </span>
            <i class="fas fa-arrow-right"></i>
            <span class="next-rank rank-<?= strtolower($statistics['nextRankRequirements']['next_rank']['name']) ?>">
              <?= $statistics['nextRankRequirements']['next_rank']['name'] ?>
            </span>
          </div>
          <div class="points-needed">
            <strong><?= $statistics['nextRankRequirements']['points_needed'] ?></strong> bodova potrebno
          </div>
          <div class="bonus-reward">
            Nagrada: <strong><?= number_format($statistics['nextRankRequirements']['next_rank']['bonus']) ?> €</strong>
          </div>
        </div>
        <div class="progress-bar">
          <div class="progress-fill" data-progress="<?= $statistics['nextRankRequirements']['progress_percentage'] ?>"></div>
          <span class="progress-text"><?= number_format($statistics['nextRankRequirements']['progress_percentage'], 1) ?>%</span>
        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>

  <!-- Feedback Section - NEW ADDITION -->
  <div class="feedback-section">
    <div class="feedback-section-card">
      <div class="card-header">
        <h3><i class="fas fa-comments"></i> Feedback od Team Leadera</h3>
      </div>
      <div class="card-body">
        
        <!-- Feedback Stats -->
        <?php if (!empty($statistics['feedbackStats']) && $statistics['feedbackStats']['total_feedbacks'] > 0): ?>
          <div class="feedback-overview">
            <div class="feedback-stats-grid">
              <div class="feedback-stat-item">
                <div class="stat-number"><?= $statistics['feedbackStats']['total_feedbacks'] ?></div>
                <div class="stat-label">Ukupno feedbackova</div>
              </div>
              <?php if ($statistics['feedbackStats']['avg_ocjena']): ?>
                <div class="feedback-stat-item">
                  <div class="stat-number rating-<?= $statistics['feedbackStats']['avg_ocjena'] >= 4 ? 'excellent' : ($statistics['feedbackStats']['avg_ocjena'] >= 3 ? 'good' : 'poor') ?>">
                    <?= number_format($statistics['feedbackStats']['avg_ocjena'], 2) ?>
                  </div>
                  <div class="stat-label">Prosječna ocjena</div>
                </div>
              <?php endif; ?>
              <div class="feedback-stat-item">
                <div class="stat-number">
                  <?= $statistics['feedbackStats']['latest_feedback_date'] ? date('d.m.Y', strtotime($statistics['feedbackStats']['latest_feedback_date'])) : 'N/A' ?>
                </div>
                <div class="stat-label">Zadnji feedback</div>
              </div>
            </div>
          </div>
        <?php endif; ?>

        <!-- Latest Feedback -->
        <?php if ($statistics['latestFeedback']): ?>
          <div class="latest-feedback-display">
            <h4 class="feedback-title">
              <i class="fas fa-comment-dots"></i> Najnoviji feedback
              <span class="feedback-date">
                <?= date('d.m.Y H:i', strtotime($statistics['latestFeedback']->datum)) ?>
              </span>
            </h4>
            
            <?php if ($statistics['latestFeedback']->feedback): ?>
              <div class="feedback-content">
                <div class="feedback-text">
                  <?= nl2br(htmlspecialchars($statistics['latestFeedback']->feedback)) ?>
                </div>
              </div>
            <?php endif; ?>
            
            <?php if ($statistics['latestFeedback']->ocjena): ?>
              <div class="feedback-rating-display">
                <span class="rating-label">Ocjena:</span>
                <span class="rating-value rating-<?= $statistics['latestFeedback']->ocjena >= 4 ? 'excellent' : ($statistics['latestFeedback']->ocjena >= 3 ? 'good' : 'poor') ?>">
                  <?= number_format($statistics['latestFeedback']->ocjena, 2) ?>/5.00
                </span>
                <div class="star-rating-display">
                  <?php 
                  $rating = $statistics['latestFeedback']->ocjena;
                  for ($i = 1; $i <= 5; $i++): 
                  ?>
                    <i class="fas fa-star <?= $i <= $rating ? 'star-filled' : 'star-empty' ?>"></i>
                  <?php endfor; ?>
                </div>
              </div>
            <?php endif; ?>
            
            <div class="feedback-author">
              <small>
                <i class="fas fa-user"></i> 
                <?= htmlspecialchars($statistics['latestFeedback']->created_by) ?>
              </small>
            </div>
          </div>
        <?php else: ?>
          <div class="no-feedback-display">
            <div class="empty-state-feedback">
              <i class="fas fa-comment-slash"></i>
              <h4>Nema feedbacka</h4>
              <p>Vaš team leader još nije ostavio feedback o vašem radu.</p>
            </div>
          </div>
        <?php endif; ?>

        <!-- View All Feedbacks Button -->
        <?php if (!empty($statistics['feedbackStats']) && $statistics['feedbackStats']['total_feedbacks'] > 1): ?>
          <div class="feedback-actions">
            <button type="button" class="feedback-view-all-btn" id="viewAllFeedbacksBtn">
              <i class="fas fa-history"></i> 
              Prikaži sve feedbackove (<?= $statistics['feedbackStats']['total_feedbacks'] ?>)
            </button>
          </div>
        <?php endif; ?>

      </div>
    </div>
  </div>

  <!-- Charts Section -->
  <div class="charts-section">
    <div class="chart-card">
      <div class="chart-header">
        <h3><i class="fas fa-chart-line"></i> Moja statistika kroz vrijeme</h3>
      </div>
      <div class="chart-body">
        <canvas id="historicalPerformanceChart"></canvas>
      </div>
    </div>

    <div class="chart-card">
      <div class="chart-header">
        <h3><i class="fas fa-chart-pie"></i> Struktura bodova po uslugama</h3>
      </div>
      <div class="chart-body">
        <canvas id="serviceBreakdownChart"></canvas>
      </div>
    </div>
  </div>

  <!-- Service Details -->
  <div class="service-details-section">
    <div class="service-details-card">
      <div class="card-header">
        <h3><i class="fas fa-list-alt"></i> Detaljni pregled usluga</h3>
      </div>
      <div class="card-body">
        <?php if (!empty($statistics['agentStats']['service_breakdown'])): ?>
          <div class="services-table">
            <div class="table-header">
              <div class="header-col">Usluga</div>
              <div class="header-col">Grupa</div>
              <div class="header-col">Količina</div>
              <div class="header-col">Bodovi po jedinici</div>
              <div class="header-col">Ukupni bodovi</div>
            </div>
            <?php foreach ($statistics['agentStats']['service_breakdown'] as $service): ?>
              <div class="table-row">
                <div class="table-col service-name"><?= htmlspecialchars($service['tarifa']) ?></div>
                <div class="table-col service-group">
                  <span class="group-badge"><?= htmlspecialchars($service['grupa'] ?? 'N/A') ?></span>
                </div>
                <div class="table-col service-count"><?= $service['count'] ?></div>
                <div class="table-col service-points"><?= $service['bodovi'] ?? $service['points_per_item'] ?? 0 ?></div>
                <div class="table-col service-total"><?= number_format($service['total_points']) ?></div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php else: ?>
          <div class="empty-state">
            <i class="fas fa-info-circle"></i>
            <p>Nema prodanih usluga za ovaj mjesec</p>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Group Ranking -->
  <div class="group-ranking-section">
    <div class="group-ranking-card">
      <div class="card-header">
        <h3><i class="fas fa-users"></i> Rangiranje u grupi <?= strtoupper($statistics['agentGroup']) ?></h3>
      </div>
      <div class="card-body">
        <?php if (!empty($statistics['groupRanking']['top_3'])): ?>
          <div class="top-agents">
            <h4>Top 3 agenta:</h4>
            <?php foreach ($statistics['groupRanking']['top_3'] as $index => $agent): ?>
              <div class="top-agent <?= $agent['agent_name'] === $statistics['agentName'] ? 'current-agent' : '' ?>">
                <div class="agent-position">
                  <span class="position-badge position-<?= $index + 1 ?>"><?= $index + 1 ?></span>
                </div>
                <div class="agent-details">
                  <div class="agent-name">
                    <?= htmlspecialchars($agent['agent_name']) ?>
                    <?php if ($agent['agent_name'] === $statistics['agentName']): ?>
                      <span class="you-badge">Vi</span>
                    <?php endif; ?>
                  </div>
                  <div class="agent-stats-mini">
                    <?= number_format($agent['total_points']) ?> bodova | 
                    <span class="rank-<?= strtolower($agent['current_rank']) ?>"><?= $agent['current_rank'] ?></span> | 
                    <?= number_format($agent['bonus_amount']) ?> €
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Ranking System Info -->
  <div class="ranking-system-section">
    <div class="ranking-system-card">
      <div class="card-header">
        <h3><i class="fas fa-info-circle"></i> Sistem razreda za <?= strtoupper($statistics['agentGroup']) ?></h3>
      </div>
      <div class="card-body">
        <div class="ranks-grid">
          <?php foreach ($statistics['rankingSystem'] as $rank): ?>
            <div class="rank-item <?= ($statistics['agentStats']['total_points'] ?? 0) >= $rank['points'] ? 'achieved' : '' ?>">
              <div class="rank-badge rank-<?= strtolower($rank['name']) ?>"><?= $rank['name'] ?></div>
              <div class="rank-requirements">
                <div class="points-req"><?= $rank['points'] ?> bodova</div>
                <div class="bonus-amount"><?= number_format($rank['bonus']) ?> € bonus</div>
              </div>
              <?php if (($statistics['agentStats']['total_points'] ?? 0) >= $rank['points']): ?>
                <div class="achieved-badge">
                  <i class="fas fa-check-circle"></i>
                </div>
              <?php endif; ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- All Feedbacks Modal -->
<div id="allFeedbacksModal" class="modal">
  <div class="modal-content modal-xl">
    <div class="modal-header">
      <h3><i class="fas fa-history"></i> Svi moji feedbackovi</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <div id="feedbacksTimelineContainer">
        <!-- Will be populated by JavaScript -->
      </div>
    </div>
    <div class="modal-footer">
      <button type="button" class="form-button secondary" id="closeAllFeedbacksBtn">Zatvori</button>
    </div>
  </div>
</div>