@errormodalreturn

<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.editbonus'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1><?= isset($bonus->id) ? 'Uredi bonus' : 'Dodaj novi bonus' ?> - <?= htmlspecialchars($type_title, ENT_QUOTES, 'UTF-8') ?></h1>
      <p>Unesite podatke za bonus shemu</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('salebonus/list') ?>?type=<?= htmlspecialchars($type, ENT_QUOTES, 'UTF-8') ?>" class="action-button secondary">
        <i class="fas fa-arrow-left"></i> Natrag na popis
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <h3 class="card-title">
        <i class="fas fa-edit"></i> Podaci o bonus shemi - <?= htmlspecialchars($type_title, ENT_QUOTES, 'UTF-8') ?>
      </h3>
    </div>
    <div class="card-body">
      <form action="<?= route('salebonus/saveEdit') ?>" method="post" class="modern-form">
        
        @csrf
        
        <input type="hidden" name="type" value="<?= htmlspecialchars($type, ENT_QUOTES, 'UTF-8') ?>">
        
        <?php if (isset($edit_token)): ?>
          <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <!-- Basic Information -->
        <div class="form-section">
          <h4 class="section-title">
            <i class="fas fa-info-circle"></i> Osnovni podaci
          </h4>
          
          <div class="form-grid basic-grid">
            <div class="form-group">
              <label for="vrsta_tarifa">Vrsta/Tarifa</label>
              <input type="text" 
                     class="form-control" 
                     id="vrsta_tarifa" 
                     name="bonus[vrsta_tarifa]" 
                     required 
                     value="<?= htmlspecialchars($bonus->vrsta_tarifa ?? ''); ?>"
                     placeholder="Unesite naziv tarife">
              <small class="form-text">Naziv tarife za koju se računa bonus</small>
            </div>

            <div class="form-group">
              <label for="grupa">Grupa</label>
              <select class="form-control" id="grupa" name="bonus[grupa]" required>
                <option value="">Odaberite grupu</option>
                <option value="MNP HT" <?= ($bonus->grupa ?? '') === 'MNP HT' ? 'selected' : '' ?>>MNP HT</option>
                <option value="MNP Telemach" <?= ($bonus->grupa ?? '') === 'MNP Telemach' ? 'selected' : '' ?>>MNP Telemach</option>
                <option value="P2P" <?= ($bonus->grupa ?? '') === 'P2P' ? 'selected' : '' ?>>P2P</option>
                <option value="Tomato" <?= ($bonus->grupa ?? '') === 'Tomato' ? 'selected' : '' ?>>Tomato</option>
                <option value="Tomato P2P" <?= ($bonus->grupa ?? '') === 'Tomato P2P' ? 'selected' : '' ?>>Tomato P2P</option>
                <option value="Parica" <?= ($bonus->grupa ?? '') === 'Parica' ? 'selected' : '' ?>>Parica</option>
                <option value="Homebox" <?= ($bonus->grupa ?? '') === 'Homebox' ? 'selected' : '' ?>>Homebox</option>
                <option value="Sat" <?= ($bonus->grupa ?? '') === 'Sat' ? 'selected' : '' ?>>Sat</option>
                <option value="Optika" <?= ($bonus->grupa ?? '') === 'Optika' ? 'selected' : '' ?>>Optika</option>
              </select>
              <small class="form-text">Grupa kojoj tarifa pripada</small>
            </div>
            
            <div class="form-group">
              <label for="osnovna_naknada">Osnovna naknada</label>
              <input type="number" 
                     class="form-control" 
                     id="osnovna_naknada" 
                     name="bonus[osnovna_naknada]" 
                     required 
                     step="0.01"
                     value="<?= htmlspecialchars($bonus->osnovna_naknada ?? ''); ?>"
                     placeholder="0.00">
              <small class="form-text">Osnovna naknada za bonus</small>
            </div>
          </div>
        </div>

        <!-- Volume-based bonuses - AŽURIRANO bez fokus kolona -->
        <div class="form-section">
          <h4 class="section-title">
            <i class="fas fa-chart-bar"></i> 
            <?php if ($type === 'p2p'): ?>
              Bonusi po broju P2P tarifa
            <?php else: ?>
              Bonusi po broju tarifa
            <?php endif; ?>
          </h4>
          <div class="form-grid volume-grid">
            <?php if ($type === 'p2p'): ?>
              <div class="form-group">
                <label for="rang_150">< 150 (P2P)</label>
                <input type="number" 
                       class="form-control" 
                       id="rang_150" 
                       name="bonus[rang_150]" 
                       required 
                       step="0.01"
                       value="<?= htmlspecialchars($bonus->rang_150 ?? ''); ?>"
                       placeholder="0.00">
              </div>
              <div class="form-group">
                <label for="rang_150_400">150-400 (P2P)</label>
                <input type="number" 
                       class="form-control" 
                       id="rang_150_400" 
                       name="bonus[rang_150_400]" 
                       required 
                       step="0.01"
                       value="<?= htmlspecialchars($bonus->rang_150_400 ?? ''); ?>"
                       placeholder="0.00">
              </div>
              <div class="form-group">
                <label for="rang_400_650">400-650 (P2P)</label>
                <input type="number" 
                       class="form-control" 
                       id="rang_400_650" 
                       name="bonus[rang_400_650]" 
                       required 
                       step="0.01"
                       value="<?= htmlspecialchars($bonus->rang_400_650 ?? ''); ?>"
                       placeholder="0.00">
              </div>
              <div class="form-group">
                <label for="rang_650_plus">> 650 (P2P)</label>
                <input type="number" 
                       class="form-control" 
                       id="rang_650_plus" 
                       name="bonus[rang_650_plus]" 
                       required 
                       step="0.01"
                       value="<?= htmlspecialchars($bonus->rang_650_plus ?? ''); ?>"
                       placeholder="0.00">
              </div>
            <?php else: ?>
              <div class="form-group">
                <label for="rang_249">≤ 249</label>
                <input type="number" class="form-control" id="rang_249" name="bonus[rang_249]" 
                      <?= $type === 'tomato' ? '' : 'required' ?> step="0.01"
                      value="<?= htmlspecialchars($bonus->rang_249 ?? ''); ?>" placeholder="0.00">
                <?php if ($type === 'tomato'): ?>
                  <small class="form-text">Ostavite prazno za P2P tarife</small>
                <?php endif; ?>
              </div>
              
              <div class="form-group">
                <label for="rang_250_449">250-449</label>
                <input type="number" class="form-control" id="rang_250_449" name="bonus[rang_250_449]" 
                      <?= $type === 'tomato' ? '' : 'required' ?> step="0.01"
                      value="<?= htmlspecialchars($bonus->rang_250_449 ?? ''); ?>" placeholder="0.00">
                <?php if ($type === 'tomato'): ?>
                  <small class="form-text">Ostavite prazno za P2P tarife</small>
                <?php endif; ?>
              </div>
              
              <div class="form-group">
                <label for="rang_450_749">450-749</label>
                <input type="number" class="form-control" id="rang_450_749" name="bonus[rang_450_749]" 
                      <?= $type === 'tomato' ? '' : 'required' ?> step="0.01"
                      value="<?= htmlspecialchars($bonus->rang_450_749 ?? ''); ?>" placeholder="0.00">
                <?php if ($type === 'tomato'): ?>
                  <small class="form-text">Ostavite prazno za P2P tarife</small>
                <?php endif; ?>
              </div>
              
              <div class="form-group">
                <label for="rang_750_1049">750-1049</label>
                <input type="number" class="form-control" id="rang_750_1049" name="bonus[rang_750_1049]" 
                      <?= $type === 'tomato' ? '' : 'required' ?> step="0.01"
                      value="<?= htmlspecialchars($bonus->rang_750_1049 ?? ''); ?>" placeholder="0.00">
                <?php if ($type === 'tomato'): ?>
                  <small class="form-text">Ostavite prazno za P2P tarife</small>
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>
        </div>

        <!-- Percentage-based bonuses -->
        <div class="form-section">
          <h4 class="section-title">
            <i class="fas fa-percentage"></i> Bonusi po postotku targeta
          </h4>
          <div class="form-grid percentage-grid">
            <div class="form-group">
              <label for="rang_70_80">70%-80%</label>
              <input type="number" 
                     class="form-control" 
                     id="rang_70_80" 
                     name="bonus[rang_70_80]" 
                     required 
                     step="0.01"
                     value="<?= htmlspecialchars($bonus->rang_70_80 ?? ''); ?>"
                     placeholder="0.00">
            </div>
            <div class="form-group">
              <label for="rang_80_90">80%-90%</label>
              <input type="number" 
                     class="form-control" 
                     id="rang_80_90" 
                     name="bonus[rang_80_90]" 
                     required 
                     step="0.01"
                     value="<?= htmlspecialchars($bonus->rang_80_90 ?? ''); ?>"
                     placeholder="0.00">
            </div>
            <div class="form-group">
              <label for="rang_90_120">90%-120%</label>
              <input type="number" 
                     class="form-control" 
                     id="rang_90_120" 
                     name="bonus[rang_90_120]" 
                     required 
                     step="0.01"
                     value="<?= htmlspecialchars($bonus->rang_90_120 ?? ''); ?>"
                     placeholder="0.00">
            </div>
          </div>
        </div>

        <div class="form-actions">
          <button type="button" class="form-button secondary" id="cancelButton">
            <i class="fas fa-times"></i> Odustani
          </button>
          <button type="submit" class="form-button primary" value="submit">
            <i class="fas fa-save"></i> Spremi
          </button>
        </div>
      </form>
    </div>
  </div>
</div>