<?php
// Helper functions for view - dodano na početak
if (!function_exists('getBonusIcon')) {
    function getBonusIcon($type) {
        $icons = [
            'prijenos' => 'arrow-right',
            'p2p' => 'exchange-alt',
            'tomato' => 'seedling'
        ];
        return $icons[$type] ?? 'cog';
    }
}

if (!function_exists('getGroupBadgeClass')) {
    function getGroupBadgeClass($group) {
        $classes = [
            'MNP HT' => 'primary',
            'MNP Telemach' => 'info',
            'P2P' => 'warning', 
            'Tomato' => 'danger',
            'Tomato P2P' => 'danger',
            'Parica' => 'secondary',
            'Homebox' => 'dark',
            'Sat' => 'light',
            'Optika' => 'success'
        ];
        return $classes[$group] ?? 'secondary';
    }
}
?>

<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.listbonus'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1>Bonus sheme - <?= htmlspecialchars($type_title, ENT_QUOTES, 'UTF-8') ?></h1>
      <p>Pregled i upravljanje bonus shemama za <?= htmlspecialchars($type_title, ENT_QUOTES, 'UTF-8') ?></p>
    </div>
    <div class="header-actions">
      <a href="<?= route('salebonus/edit') ?>?type=<?= htmlspecialchars($current_type, ENT_QUOTES, 'UTF-8') ?>" class="action-button primary">
        <i class="fas fa-plus"></i> Dodaj novi bonus
      </a>
      <button type="button" id="exportToggle" class="action-button secondary">
        <i class="fas fa-download"></i> Izvoz
      </button>
    </div>
  </div>

  <!-- Type Navigation - AŽURIRANO -->
  <div class="bonus-type-nav">
    <div class="nav-tabs">
      <?php foreach($types as $typeKey => $typeTitle): ?>
        <a href="<?= route('salebonus/list') ?>?type=<?= htmlspecialchars($typeKey, ENT_QUOTES, 'UTF-8') ?>" 
           class="nav-tab <?= $current_type === $typeKey ? 'active' : '' ?>">
          <i class="fas fa-<?= getBonusIcon($typeKey) ?>"></i>
          <?= htmlspecialchars($typeTitle, ENT_QUOTES, 'UTF-8') ?>
        </a>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-list-ul"></i> Popis bonus shema
      </div>
      <div class="card-tools">
        <div class="search-container">
          <input type="text" id="dataSearch" placeholder="Pretraži bonuse...">
          <i class="fas fa-search"></i>
        </div>
        <div class="filter-dropdown">
          <button class="filter-button">
            <i class="fas fa-filter"></i> Filter
          </button>
          <div class="filter-menu">
            <div class="filter-group">
              <label>Po grupi:</label>
              <div class="filter-options" id="grupaFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="table-responsive">
      <table id="dataTable" class="data-table">
        <thead>
          <tr>
            <th width="80">Akcije</th>
            <th class="sortable">Vrsta/Tarifa</th>
            <th class="sortable">Grupa</th>
            <th class="sortable">Osnovna<br>naknada</th>
            
            <?php if ($current_type === 'prijenos'): ?>
              <th class="sortable">≤249</th>
              <th class="sortable">250-449</th>
              <th class="sortable">450-749</th>
              <th class="sortable">750-1049</th>
            <?php elseif ($current_type === 'p2p'): ?>
              <th class="sortable">150</th>
              <th class="sortable">150-400</th>
              <th class="sortable">400-650</th>
              <th class="sortable">>650</th>
            <?php elseif ($current_type === 'tomato'): ?>
              <th class="sortable">≤299</th>
              <th class="sortable">300-549</th>
              <th class="sortable">550-779</th>
              <th class="sortable">≥800</th>
            <?php endif; ?>
            
            <th class="sortable">70-80%</th>
            <th class="sortable">80-90%</th>
            <th class="sortable">90-120%</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($bonuses as $bonus): ?>
          <tr>
            <td>
              <div class="table-actions">
                <a href="<?= route('salebonus/edit') ?>?type=<?= htmlspecialchars($current_type, ENT_QUOTES, 'UTF-8') ?>&id=<?=$bonus->id?>" 
                   class="action-btn edit" title="Uredi bonus">
                  <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="action-btn delete" 
                        data-id="<?=$bonus->id?>" 
                        data-type="<?= htmlspecialchars($current_type, ENT_QUOTES, 'UTF-8') ?>"
                        data-name="<?= htmlspecialchars($bonus->vrsta_tarifa ?? '', ENT_QUOTES, 'UTF-8') ?>"
                        title="Obriši bonus">
                  <i class="fas fa-trash-alt"></i>
                </button>
              </div>
            </td>
            <td><?= htmlspecialchars($bonus->vrsta_tarifa ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <td><span class="badge badge-<?= getGroupBadgeClass($bonus->grupa ?? '') ?>"><?= htmlspecialchars($bonus->grupa ?? '', ENT_QUOTES, 'UTF-8') ?></span></td>
            <td><?= htmlspecialchars($bonus->osnovna_naknada ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            
            <?php if ($current_type === 'prijenos'): ?>
              <td><?= htmlspecialchars($bonus->rang_249 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
              <td><?= htmlspecialchars($bonus->rang_250_449 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
              <td><?= htmlspecialchars($bonus->rang_450_749 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
              <td><?= htmlspecialchars($bonus->rang_750_1049 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <?php elseif ($current_type === 'p2p'): ?>
              <td><?= htmlspecialchars($bonus->rang_150 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
              <td><?= htmlspecialchars($bonus->rang_150_400 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
              <td><?= htmlspecialchars($bonus->rang_400_650 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
              <td><?= htmlspecialchars($bonus->rang_650_plus ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <?php elseif ($current_type === 'tomato'): ?>
              <td><?= $bonus->rang_299 !== null ? htmlspecialchars($bonus->rang_299, ENT_QUOTES, 'UTF-8') : '<span class="text-muted">-</span>' ?></td>
              <td><?= $bonus->rang_300_549 !== null ? htmlspecialchars($bonus->rang_300_549, ENT_QUOTES, 'UTF-8') : '<span class="text-muted">-</span>' ?></td>
              <td><?= $bonus->rang_550_779 !== null ? htmlspecialchars($bonus->rang_550_779, ENT_QUOTES, 'UTF-8') : '<span class="text-muted">-</span>' ?></td>
              <td><?= $bonus->rang_800_1099 !== null ? htmlspecialchars($bonus->rang_800_1099, ENT_QUOTES, 'UTF-8') : '<span class="text-muted">-</span>' ?></td>
            <?php endif; ?>
            
            <td class="percentage-column"><?= htmlspecialchars($bonus->rang_70_80 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <td class="percentage-column"><?= htmlspecialchars($bonus->rang_80_90 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <td class="percentage-column"><?= htmlspecialchars($bonus->rang_90_120 ?? '', ENT_QUOTES, 'UTF-8') ?></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Export Panel -->
  <div id="exportPanel" class="export-panel">
    <div class="card">
      <div class="card-header">
        <div class="card-title">
          <i class="fas fa-file-export"></i> Izvoz podataka
        </div>
        <button id="closeExport" class="close-btn">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="card-body">
        <form action="" method="post" id="exportForm">
          @csrf
          <input type="hidden" name="type" value="<?= htmlspecialchars($current_type, ENT_QUOTES, 'UTF-8') ?>">
          
          <div class="form-group">
            <label for="file_type">Format izvoza</label>
            <select name="file_type" id="file_type" class="form-control">
              <option value="Xlsx">Excel (XLSX)</option>
              <option value="Csv">CSV</option>
            </select>
          </div>
          
          <div class="form-actions">
            <button type="submit" name="export" value="Export" class="form-button primary">
              <i class="fas fa-download"></i> Izvoz podataka
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Delete Confirmation Modal -->
  <div id="deleteModal" class="modal">
    <div class="modal-content">
      <div class="modal-header">
        <h3>Potvrda brisanja</h3>
        <button class="modal-close">&times;</button>
      </div>
      <div class="modal-body">
        <p>Jeste li sigurni da želite obrisati bonus za <strong id="deleteName"></strong>?</p>
        <p class="text-danger">Ova akcija se ne može poništiti.</p>
      </div>
      <div class="modal-footer">
        <form action="<?= route('salebonus/delete') ?>" method="post" id="deleteForm">
          @csrf
          <input type="hidden" name="id" id="deleteId" value="">
          <input type="hidden" name="type" id="deleteType" value="">
          <button type="button" class="form-button secondary modal-cancel">Odustani</button>
          <button type="submit" class="form-button danger">Obriši</button>
        </form>
      </div>
    </div>
  </div>
</div>