@errormodalreturn

<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.editosoba'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1><?= isset($osoba->id) ? 'Uredi Osobu' : 'Dodaj Novu Osobu' ?></h1>
      <p>Unesi podatke o osobi i radnom mjestu</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('saleosoba/list') ?>" class="action-button secondary">
        <i class="fas fa-arrow-left"></i> Povratak na Popis
      </a>
    </div>
  </div>

  <div class="main-layout">
    <!-- Main form section -->
    <div class="main-section">
      <div class="card">
        <div class="card-header">
          <h3 class="card-title">
            <i class="fas fa-user-edit"></i> Detalji Osobe
          </h3>
        </div>
        <div class="card-body">
          <form action="" method="post" class="modern-form">
            
            @csrf
            
            <?php if (isset($edit_token)): ?>
              <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
            <?php endif; ?>

            <!-- Osnovni Podaci -->
            <div class="form-section">
              <h4 class="section-title">Osnovni Podaci</h4>
              
              <div class="form-grid">
                <div class="form-group">
                  <label for="name">Puno Ime</label>
                  <input type="text" 
                        class="form-control" 
                        id="name" 
                        name="osoba[name]" 
                        required 
                        value="<?= htmlspecialchars($osoba->name ?? ''); ?>"
                        placeholder="Unesi puno ime">
                  <small class="form-text">Puno ime osobe</small>
                </div>

                <div class="form-group">
                  <label for="radnomjesto">Radno Mjesto</label>
                  <div class="custom-select-wrapper">
                    <select class="form-control" 
                          id="radnomjesto" 
                          name="osoba[radnomjesto]" 
                          required>
                      <option value="" disabled <?= empty($osoba->radnomjesto) ? 'selected' : '' ?>>Odaberi Radno Mjesto</option>
                      <option value="Agent" <?= (isset($osoba->radnomjesto) && $osoba->radnomjesto == 'Agent') ? 'selected' : '' ?>>Agent</option>
                      <option value="Kontrolor" <?= (isset($osoba->radnomjesto) && $osoba->radnomjesto == 'Kontrolor') ? 'selected' : '' ?>>Kontrolor</option>
                      <option value="Supervisor" <?= (isset($osoba->radnomjesto) && $osoba->radnomjesto == 'Supervisor') ? 'selected' : '' ?>>Supervisor</option>
                      <option value="Administrator" <?= (isset($osoba->radnomjesto) && $osoba->radnomjesto == 'Administrator') ? 'selected' : '' ?>>Administrator</option>
                    </select>
                    <i class="fas fa-chevron-down select-arrow"></i>
                  </div>
                  <small class="form-text">Pozicija koju osoba obnaša</small>
                </div>
              </div>
            </div>
            
            <!-- Organizacijski Detalji -->
            <div class="form-section">
              <h4 class="section-title">Organizacijski Detalji</h4>
              
              <div class="form-grid">
                <div class="form-group">
                  <label for="area">Područje</label>
                  <div class="custom-select-wrapper">
                    <select class="form-control" 
                          id="area" 
                          name="osoba[area]" 
                          required>
                      <option value="" disabled <?= empty($osoba->area) ? 'selected' : '' ?>>Odaberi Područje</option>
                      <option value="" <?= (isset($osoba->area) && $osoba->area == '') ? 'selected' : '' ?>></option>
                      <option value="OS" <?= (isset($osoba->area) && $osoba->area == 'OS') ? 'selected' : '' ?>>OS</option>
                      <option value="VU" <?= (isset($osoba->area) && $osoba->area == 'VU') ? 'selected' : '' ?>>VU</option>
                    </select>
                    <i class="fas fa-chevron-down select-arrow"></i>
                  </div>
                  <small class="form-text">Radno područje osobe</small>
                </div>

                <div class="form-group">
                  <label for="orgjedinica">Organizacijska Jedinica</label>
                  <div class="custom-select-wrapper">
                    <select class="form-control" 
                          id="orgjedinica" 
                          name="osoba[orgjedinica]" 
                          required>
                      <option value="" disabled <?= empty($osoba->orgjedinica) ? 'selected' : '' ?>>Odaberi Organizacijsku Jedinicu</option>
                      <option value="Backoffice" <?= (isset($osoba->orgjedinica) && $osoba->orgjedinica == 'Backoffice') ? 'selected' : '' ?>>Backoffice</option>
                      <option value="Backoffice MNP" <?= (isset($osoba->orgjedinica) && $osoba->orgjedinica == 'Backoffice MNP') ? 'selected' : '' ?>>Backoffice MNP</option>
                      <option value="Backoffice Optika" <?= (isset($osoba->orgjedinica) && $osoba->orgjedinica == 'Backoffice Optika') ? 'selected' : '' ?>>Backoffice Optika</option>
                      <option value="Backoffice P2P" <?= (isset($osoba->orgjedinica) && $osoba->orgjedinica == 'Backoffice P2P') ? 'selected' : '' ?>>Backoffice P2P</option>
                    </select>
                    <i class="fas fa-chevron-down select-arrow"></i>
                  </div>
                  <small class="form-text">Organizacijska jedinica kojoj osoba pripada</small>
                </div>
              </div>
            </div>

            <!-- Status -->
            <div class="form-section">
              <h4 class="section-title">Status</h4>
              
              <div class="form-grid">
                <div class="form-group">
                  <label for="vidljivost">Status Aktivnosti</label>
                  <div class="toggle-container">
                    <input type="checkbox" id="vidljivost-toggle" class="toggle-switch" 
                          <?= (isset($osoba->vidljivost) && $osoba->vidljivost == 1) ? 'checked' : '' ?>>
                    <label for="vidljivost-toggle" class="toggle-label">
                      <span class="toggle-inner"></span>
                      <span class="toggle-switch-label">
                        <span class="status-text active">Aktivan</span>
                        <span class="status-text inactive">Neaktivan</span>
                      </span>
                    </label>
                    <input type="hidden" name="osoba[vidljivost]" id="vidljivost" 
                          value="<?= isset($osoba->vidljivost) ? $osoba->vidljivost : '1' ?>">
                  </div>
                  <small class="form-text">Status osobe u sustavu</small>
                </div>
              </div>
            </div>

            <div class="form-actions">
              <button type="button" class="form-button secondary" id="cancelButton">
                <i class="fas fa-times"></i> Odustani
              </button>
              <button type="submit" class="form-button primary" value="submit">
                <i class="fas fa-save"></i> Spremi
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Feedback sidebar -->
    <?php if (isset($osoba->name) && !empty($osoba->name)): ?>
    <div class="sidebar-section">
      <div class="feedback-section">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-comments"></i> Feedback & Ocjena
            </h3>
            <?php if ($can_manage_feedback): ?>
              <button type="button" class="action-button primary btn-sm" id="addFeedbackBtn">
                <i class="fas fa-plus"></i> Dodaj Feedback
              </button>
            <?php endif; ?>
          </div>
          <div class="card-body">
            
            <!-- Feedback Stats -->
            <?php if (!empty($feedback_stats) && $feedback_stats['total_feedbacks'] > 0): ?>
              <div class="feedback-stats">
                <div class="stats-grid">
                  <div class="stat-item">
                    <div class="stat-number"><?= $feedback_stats['total_feedbacks'] ?></div>
                    <div class="stat-label">Ukupno feedbackova</div>
                  </div>
                  <?php if ($feedback_stats['avg_ocjena']): ?>
                    <div class="stat-item">
                      <div class="stat-number rating-<?= $feedback_stats['avg_ocjena'] >= 4 ? 'excellent' : ($feedback_stats['avg_ocjena'] >= 3 ? 'good' : 'poor') ?>">
                        <?= number_format($feedback_stats['avg_ocjena'], 2) ?>
                      </div>
                      <div class="stat-label">Prosječna ocjena</div>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            <?php endif; ?>

            <!-- Latest Feedback -->
            <?php if ($latest_feedback): ?>
              <div class="latest-feedback">
                <h4 class="feedback-title">
                  <i class="fas fa-clock"></i> Najnoviji feedback
                  <span class="feedback-date"><?= date('d.m.Y', strtotime($latest_feedback->datum)) ?></span>
                </h4>
                
                <?php if ($latest_feedback->feedback): ?>
                  <div class="feedback-content">
                    <p><?= nl2br(htmlspecialchars($latest_feedback->feedback)) ?></p>
                  </div>
                <?php endif; ?>
                
                <?php if ($latest_feedback->ocjena): ?>
                  <div class="feedback-rating">
                    <span class="rating-label">Ocjena:</span>
                    <span class="rating-value rating-<?= $latest_feedback->ocjena >= 4 ? 'excellent' : ($latest_feedback->ocjena >= 3 ? 'good' : 'poor') ?>">
                      <?= number_format($latest_feedback->ocjena, 2) ?>/5.00
                    </span>
                    <div class="star-rating">
                      <?php 
                      $rating = $latest_feedback->ocjena;
                      for ($i = 1; $i <= 5; $i++): 
                      ?>
                        <i class="fas fa-star <?= $i <= $rating ? 'star-filled' : 'star-empty' ?>"></i>
                      <?php endfor; ?>
                    </div>
                  </div>
                <?php endif; ?>
                
                <div class="feedback-meta">
                  <small class="text-muted">
                    <i class="fas fa-user"></i> <?= htmlspecialchars($latest_feedback->created_by) ?>
                  </small>
                </div>
              </div>
            <?php else: ?>
              <div class="no-feedback">
                <div class="empty-state-mini">
                  <i class="fas fa-comment-slash"></i>
                  <p>Nema feedbacka za ovu osobu</p>
                </div>
              </div>
            <?php endif; ?>

            <!-- View All Feedbacks Button -->
            <?php if (!empty($feedback_stats) && $feedback_stats['total_feedbacks'] > 1): ?>
              <div class="feedback-actions">
                <button type="button" class="action-button secondary btn-block" id="viewAllFeedbacksBtn">
                  <i class="fas fa-history"></i> Prikaži sve feedbackove (<?= $feedback_stats['total_feedbacks'] ?>)
                </button>
              </div>
            <?php endif; ?>

          </div>
        </div>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>

<!-- Add Feedback Modal -->
<?php if ($can_manage_feedback && isset($osoba->name)): ?>
<div id="addFeedbackModal" class="modal">
  <div class="modal-content modal-lg">
    <div class="modal-header">
      <h3><i class="fas fa-plus-circle"></i> Dodaj Novi Feedback</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <form id="addFeedbackForm">
        <input type="hidden" name="person_name" value="<?= htmlspecialchars($osoba->name ?? '') ?>">
        
        <div class="form-group">
          <label for="newFeedback">Feedback</label>
          <textarea class="form-control" 
                  id="newFeedback" 
                  name="feedback" 
                  rows="5"
                  maxlength="2000"
                  placeholder="Unesite detaljnu procjenu rada, ponašanja i postignuća djelatnika..."></textarea>
          <small class="form-text">
            Detaljni opis rada i postignuća djelatnika (max 2000 znakova)
            <span class="char-counter" id="newFeedbackCounter">0/2000</span>
          </small>
        </div>

        <div class="form-group">
          <label for="newOcjena">Ocjena</label>
          <div class="rating-input-wrapper">
            <input type="number" 
                  class="form-control" 
                  id="newOcjena" 
                  name="ocjena" 
                  step="0.01"
                  min="0"
                  max="5"
                  placeholder="Unesite ocjenu (0.00 - 5.00)">
            <div class="rating-preview" id="newRatingPreview">
              <div class="stars">
                <i class="fas fa-star star-empty" data-rating="1"></i>
                <i class="fas fa-star star-empty" data-rating="2"></i>
                <i class="fas fa-star star-empty" data-rating="3"></i>
                <i class="fas fa-star star-empty" data-rating="4"></i>
                <i class="fas fa-star star-empty" data-rating="5"></i>
              </div>
            </div>
          </div>
          <small class="form-text">Numerička ocjena djelatnika (0.00 - 5.00)</small>
        </div>
      </form>
    </div>
    <div class="modal-footer">
      <button type="button" class="form-button secondary modal-cancel">Odustani</button>
      <button type="button" class="form-button primary" id="saveFeedbackBtn">
        <i class="fas fa-save"></i> Spremi Feedback
      </button>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- View All Feedbacks Modal (Timeline Style) -->
<div id="viewFeedbacksModal" class="modal">
  <div class="modal-content modal-xl">
    <div class="modal-header">
      <h3><i class="fas fa-history"></i> Svi Feedbackovi - <span id="viewFeedbacksPersonName"></span></h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <div id="feedbacksTimelineContainer">
        <!-- Will be populated by JavaScript -->
      </div>
    </div>
    <div class="modal-footer">
      <button type="button" class="form-button secondary" id="closeFeedbacksViewBtn">Zatvori</button>
    </div>
  </div>
</div>

<!-- Edit Feedback Modal -->
<?php if ($can_manage_feedback): ?>
<div id="editFeedbackModal" class="modal">
  <div class="modal-content modal-lg">
    <div class="modal-header">
      <h3><i class="fas fa-edit"></i> Uredi Feedback</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <form id="editFeedbackForm">
        <input type="hidden" name="feedback_id" id="editFeedbackId">
        
        <div class="form-group">
          <label for="editFeedback">Feedback</label>
          <textarea class="form-control" 
                  id="editFeedback" 
                  name="feedback" 
                  rows="5"
                  maxlength="2000"></textarea>
          <small class="form-text">
            Detaljni opis rada i postignuća djelatnika (max 2000 znakova)
            <span class="char-counter" id="editFeedbackCounter">0/2000</span>
          </small>
        </div>

        <div class="form-group">
          <label for="editOcjena">Ocjena</label>
          <div class="rating-input-wrapper">
            <input type="number" 
                  class="form-control" 
                  id="editOcjena" 
                  name="ocjena" 
                  step="0.01"
                  min="0"
                  max="5">
            <div class="rating-preview" id="editRatingPreview">
              <div class="stars">
                <i class="fas fa-star star-empty" data-rating="1"></i>
                <i class="fas fa-star star-empty" data-rating="2"></i>
                <i class="fas fa-star star-empty" data-rating="3"></i>
                <i class="fas fa-star star-empty" data-rating="4"></i>
                <i class="fas fa-star star-empty" data-rating="5"></i>
              </div>
            </div>
          </div>
          <small class="form-text">Numerička ocjena djelatnika (0.00 - 5.00)</small>
        </div>
      </form>
    </div>
    <div class="modal-footer">
      <button type="button" class="form-button secondary modal-cancel">Odustani</button>
      <button type="button" class="form-button primary" id="updateFeedbackBtn">
        <i class="fas fa-save"></i> Ažuriraj
      </button>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- Success/Error Notification -->
<div id="notification" class="notification">
  <div class="notification-content">
    <i class="notification-icon"></i>
    <span class="notification-message"></span>
  </div>
</div>