<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.listosoba'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1>Osobe</h1>
      <p>Pregled i upravljanje osobama u sustavu</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('saleosoba/edit') ?>" class="action-button primary">
        <i class="fas fa-user-plus"></i> Dodaj Novu Osobu
      </a>
      <button type="button" id="exportToggle" class="action-button secondary">
        <i class="fas fa-download"></i> Izvoz
      </button>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-users"></i> Popis Osoba
      </div>
      <div class="card-tools">
        <div class="search-container">
          <input type="text" id="dataSearch" placeholder="Pretraži osobe...">
          <i class="fas fa-search"></i>
        </div>
        <div class="filter-dropdown">
          <button class="filter-button">
            <i class="fas fa-filter"></i> Filter
          </button>
          <div class="filter-menu">
            <div class="filter-group">
              <label>Po Org. Jedinici:</label>
              <div class="filter-options" id="orgFilter">
                <!-- Će biti popunjeno JavaScript-om -->
              </div>
            </div>
            <div class="filter-group">
              <label>Po Prosječnoj Ocjeni:</label>
              <div class="filter-options" id="ocjenaFilter">
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="ocjena" data-value="0-2"> 
                  0.00 - 2.00
                </label>
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="ocjena" data-value="2-3"> 
                  2.01 - 3.00
                </label>
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="ocjena" data-value="3-4"> 
                  3.01 - 4.00
                </label>
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="ocjena" data-value="4-5"> 
                  4.01 - 5.00
                </label>
              </div>
            </div>
            <div class="filter-group">
              <label>Po Feedback Statusu:</label>
              <div class="filter-options">
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="feedback" data-value="has"> 
                  Ima feedback
                </label>
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="feedback" data-value="none"> 
                  Nema feedback
                </label>
              </div>
            </div>
            <div class="filter-group">
              <label>Po Statusu:</label>
              <div class="filter-options">
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="status" data-value="1"> 
                  Aktivan
                </label>
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="status" data-value="0"> 
                  Neaktivan
                </label>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="table-responsive">
      <table id="dataTable" class="data-table">
        <thead>
          <tr>
            <th width="120">Akcije</th>
            <th class="sortable">Ime Osobe</th>
            <th class="sortable">Radno Mjesto</th>
            <th class="sortable">Područje</th>
            <th class="sortable">Organizacijska Jedinica</th>
            <th class="sortable">Najnoviji Feedback</th>
            <th class="sortable">Prosječna Ocjena</th>
            <th class="sortable">Br. Feedbackova</th>
            <th class="sortable">Status</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($osobe as $osoba): ?>
          <tr data-status="<?= htmlspecialchars($osoba['vidljivost'] ?? '0', ENT_QUOTES, 'UTF-8') ?>" 
              data-ocjena="<?= htmlspecialchars($osoba['avg_ocjena'] ?? '0', ENT_QUOTES, 'UTF-8') ?>"
              data-feedback="<?= !empty($osoba['feedback']) ? 'has' : 'none' ?>"
              data-person-name="<?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>">
            <td>
              <div class="table-actions">
                <a href="<?= route('saleosoba/edit') ?>/<?= $osoba['id'] ?? '' ?>" 
                   class="action-btn edit" title="Uredi Osobu">
                  <i class="fas fa-edit"></i>
                </a>
                
                <!-- Quick Feedback Button -->
                <?php if ($can_manage_feedback): ?>
                  <button type="button" class="action-btn feedback" 
                          data-person-name="<?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>"
                          title="Dodaj/Uredi Feedback">
                    <i class="fas fa-comment-dots"></i>
                  </button>
                <?php endif; ?>
                
                <!-- View Feedbacks Button -->
                <?php if (!empty($osoba['total_feedbacks']) && $osoba['total_feedbacks'] > 0): ?>
                  <button type="button" class="action-btn view-feedbacks" 
                          data-person-name="<?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>"
                          title="Prikaži sve feedbackove (<?= $osoba['total_feedbacks'] ?>)">
                    <i class="fas fa-history"></i>
                    <span class="feedback-count"><?= $osoba['total_feedbacks'] ?></span>
                  </button>
                <?php endif; ?>
                
                <?php if ($can_manage_feedback): ?>
                  <button type="button" class="action-btn delete" 
                          data-id="<?= $osoba['id'] ?? '' ?>" 
                          data-name="<?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>"
                          title="Obriši Osobu">
                    <i class="fas fa-trash-alt"></i>
                  </button>
                <?php endif; ?>
              </div>
            </td>
            <td>
              <div class="person-name">
                <i class="fas fa-user person-icon"></i>
                <?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>
              </div>
            </td>
            <td>
              <?= htmlspecialchars($osoba['radnomjesto'] ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <?= htmlspecialchars($osoba['area'] ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <span class="org-badge">
                <?= htmlspecialchars($osoba['orgjedinica'] ?? '', ENT_QUOTES, 'UTF-8') ?>
              </span>
            </td>
            <td>
              <div class="feedback-cell">
                <?php if (!empty($osoba['feedback'])): ?>
                  <div class="feedback-preview">
                    <div class="feedback-text">
                      <?= htmlspecialchars(mb_substr($osoba['feedback'], 0, 50), ENT_QUOTES, 'UTF-8') ?>
                      <?= mb_strlen($osoba['feedback']) > 50 ? '...' : '' ?>
                    </div>
                    <div class="feedback-meta">
                      <small class="feedback-date">
                        <i class="fas fa-calendar"></i>
                        <?= date('d.m.Y', strtotime($osoba['datum'])) ?>
                      </small>
                      <small class="feedback-author">
                        <i class="fas fa-user"></i>
                        <?= htmlspecialchars($osoba['created_by']) ?>
                      </small>
                    </div>
                  </div>
                  <button type="button" class="feedback-expand-btn" 
                          data-person-name="<?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>">
                    <i class="fas fa-expand-alt"></i>
                  </button>
                <?php else: ?>
                  <div class="no-feedback">
                    <span class="no-feedback-text">Nema feedback-a</span>
                    <?php if ($can_manage_feedback): ?>
                      <button type="button" class="add-feedback-btn" 
                              data-person-name="<?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>">
                        <i class="fas fa-plus"></i> Dodaj
                      </button>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>
            </td>
            <td>
              <div class="rating-cell">
                <?php if ($osoba['avg_ocjena']): ?>
                  <span class="ocjena-badge <?= $osoba['avg_ocjena'] >= 4 ? 'high-rating' : ($osoba['avg_ocjena'] >= 2.5 ? 'medium-rating' : 'low-rating') ?>">
                    <?= number_format($osoba['avg_ocjena'], 2) ?>
                  </span>
                  <div class="star-rating-mini">
                    <?php 
                    $rating = $osoba['avg_ocjena'];
                    for ($i = 1; $i <= 5; $i++): 
                    ?>
                      <i class="fas fa-star <?= $i <= $rating ? 'star-filled' : 'star-empty' ?>"></i>
                    <?php endfor; ?>
                  </div>
                <?php else: ?>
                  <span class="no-rating">Nema ocjene</span>
                <?php endif; ?>
              </div>
            </td>
            <td>
              <div class="feedback-count-cell">
                <?php if (!empty($osoba['total_feedbacks']) && $osoba['total_feedbacks'] > 0): ?>
                  <span class="feedback-count-badge">
                    <i class="fas fa-comments"></i>
                    <?= $osoba['total_feedbacks'] ?>
                  </span>
                  <?php if ($osoba['total_feedbacks'] > 1): ?>
                    <button type="button" class="view-all-btn" 
                            data-person-name="<?= htmlspecialchars($osoba['name'], ENT_QUOTES, 'UTF-8') ?>">
                      <i class="fas fa-eye"></i>
                    </button>
                  <?php endif; ?>
                <?php else: ?>
                  <span class="no-feedback-count">0</span>
                <?php endif; ?>
              </div>
            </td>
            <td>
              <?php if(isset($osoba['vidljivost']) && $osoba['vidljivost'] == 1): ?>
                <span class="status-badge status-active">
                  <span class="status-pulse"></span>
                  Aktivan
                </span>
              <?php else: ?>
                <span class="status-badge status-inactive">Neaktivan</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Export Panel -->
  <div id="exportPanel" class="export-panel">
    <div class="card">
      <div class="card-header">
        <div class="card-title">
          <i class="fas fa-file-export"></i> Izvoz Podataka
        </div>
        <button id="closeExport" class="close-btn">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="card-body">
        <form action="" method="post" id="exportForm">
          @csrf
          
          <div class="form-group">
            <label for="file_type">Format Izvoza</label>
            <select name="file_type" id="file_type" class="form-control">
              <option value="Xlsx">Excel (XLSX)</option>
              <option value="Csv">CSV</option>
            </select>
          </div>
          
          <div class="form-group">
            <label>
              <input type="checkbox" name="include_feedback" value="1" checked>
              Uključi feedback podatke
            </label>
          </div>
          
          <div class="form-actions">
            <button type="submit" name="export" value="Export" class="form-button primary">
              <i class="fas fa-download"></i> Izvezi Podatke
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Quick Add Feedback Modal -->
<?php if ($can_manage_feedback): ?>
<div id="quickFeedbackModal" class="modal">
  <div class="modal-content modal-lg">
    <div class="modal-header">
      <h3><i class="fas fa-comment-dots"></i> Brzo Dodavanje Feedback-a</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <div class="person-info">
        <h4 id="quickFeedbackPersonName"></h4>
      </div>
      
      <form id="quickFeedbackForm">
        <input type="hidden" name="person_name" id="quickFeedbackPersonInput">
        
        <div class="form-group">
          <label for="quickFeedback">Feedback</label>
          <textarea class="form-control" 
                  id="quickFeedback" 
                  name="feedback" 
                  rows="4"
                  maxlength="2000"
                  placeholder="Kratki feedback o performansama..."></textarea>
          <small class="form-text">
            <span class="char-counter" id="quickFeedbackCounter">0/2000</span>
          </small>
        </div>

        <div class="form-group">
          <label for="quickOcjena">Ocjena</label>
          <div class="rating-input-wrapper">
            <input type="number" 
                  class="form-control" 
                  id="quickOcjena" 
                  name="ocjena" 
                  step="0.1"
                  min="0"
                  max="5"
                  placeholder="0.0 - 5.0">
            <div class="rating-preview" id="quickRatingPreview">
              <div class="stars">
                <i class="fas fa-star star-empty" data-rating="1"></i>
                <i class="fas fa-star star-empty" data-rating="2"></i>
                <i class="fas fa-star star-empty" data-rating="3"></i>
                <i class="fas fa-star star-empty" data-rating="4"></i>
                <i class="fas fa-star star-empty" data-rating="5"></i>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
    <div class="modal-footer">
      <button type="button" class="form-button secondary modal-cancel">Odustani</button>
      <button type="button" class="form-button primary" id="saveQuickFeedbackBtn">
        <i class="fas fa-save"></i> Spremi
      </button>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- View All Feedbacks Modal -->
<div id="viewFeedbacksModal" class="modal">
  <div class="modal-content modal-xl">
    <div class="modal-header">
      <h3><i class="fas fa-history"></i> Svi Feedbackovi - <span id="viewFeedbacksPersonName"></span></h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <div id="feedbacksTimelineContainer">
        <!-- Will be populated by JavaScript -->
      </div>
    </div>
    <div class="modal-footer">
      <button type="button" class="form-button secondary" id="closeFeedbacksViewBtn">Zatvori</button>
    </div>
  </div>
</div>

<!-- Edit Feedback Modal -->
<?php if ($can_manage_feedback): ?>
<div id="editFeedbackModal" class="modal">
  <div class="modal-content modal-lg">
    <div class="modal-header">
      <h3><i class="fas fa-edit"></i> Uredi Feedback</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <form id="editFeedbackForm">
        <input type="hidden" name="feedback_id" id="editFeedbackId">
        
        <div class="form-group">
          <label for="editFeedback">Feedback</label>
          <textarea class="form-control" 
                  id="editFeedback" 
                  name="feedback" 
                  rows="5"
                  maxlength="2000"></textarea>
          <small class="form-text">
            <span class="char-counter" id="editFeedbackCounter">0/2000</span>
          </small>
        </div>

        <div class="form-group">
          <label for="editOcjena">Ocjena</label>
          <div class="rating-input-wrapper">
            <input type="number" 
                  class="form-control" 
                  id="editOcjena" 
                  name="ocjena" 
                  step="0.01"
                  min="0"
                  max="5">
            <div class="rating-preview" id="editRatingPreview">
              <div class="stars">
                <i class="fas fa-star star-empty" data-rating="1"></i>
                <i class="fas fa-star star-empty" data-rating="2"></i>
                <i class="fas fa-star star-empty" data-rating="3"></i>
                <i class="fas fa-star star-empty" data-rating="4"></i>
                <i class="fas fa-star star-empty" data-rating="5"></i>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
    <div class="modal-footer">
      <button type="button" class="form-button secondary modal-cancel">Odustani</button>
      <button type="button" class="form-button primary" id="updateFeedbackBtn">
        <i class="fas fa-save"></i> Ažuriraj
      </button>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- Delete Confirmation Modal -->
<?php if ($can_manage_feedback): ?>
<div id="deleteModal" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h3>Potvrda Brisanja</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <p>Jeste li sigurni da želite obrisati osobu <strong id="deleteName"></strong>?</p>
      <p class="text-danger">Ova akcija će obrisati i sve povezane feedbackove.</p>
    </div>
    <div class="modal-footer">
      <form action="<?= route('saleosoba/delete') ?>" method="post" id="deleteForm">
        @csrf
        <input type="hidden" name="id" id="deleteId" value="">
        <button type="button" class="form-button secondary modal-cancel">Odustani</button>
        <button type="submit" class="form-button danger">Obriši</button>
      </form>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- Success/Error Notification -->
<div id="notification" class="notification">
  <div class="notification-content">
    <i class="notification-icon"></i>
    <span class="notification-message"></span>
  </div>
</div>