<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.admin'); ?>

<div class="admin-dashboard">
  <!-- Data container for charts -->
  <div id="sales-charts-data" 
    data-funnel='<?= json_encode($statistics['salesFunnel'] ?? []) ?>'
    data-monthly='<?= json_encode($statistics['monthlyTrends'] ?? []) ?>'
    data-services='<?= json_encode($statistics['topServices'] ?? []) ?>'
    data-agents='<?= json_encode($statistics['topAgents'] ?? []) ?>'
    data-status='<?= json_encode($statistics['statusDistribution'] ?? []) ?>'
    ></div>

  <div class="sidebar">
    <div class="sidebar-header">
      <h3>Sales Dashboard</h3>
      <button id="mobile-toggle" class="mobile-toggle">
        <i class="fas fa-bars"></i>
      </button>
    </div>
    
    <div class="sidebar-content">
      <ul class="sidebar-menu">
        <li class="sidebar-item active">
          <a href="#" class="sidebar-link" data-target="overview">
            <i class="fas fa-tachometer-alt"></i>
            <span>Pregled</span>
          </a>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="tables">
            <i class="fas fa-table"></i>
            <span>Tablice</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('salevrsta/list') ?>">
              <i class="fas fa-tasks"></i> Vrste - list & edit</a>
            </li>
            <li><a href="<?= route('saleosoba/list') ?>">
              <i class="fas fa-user-edit"></i> Djelatnici - list & edit</a>
            </li>
            <li><a href="<?= route('saletarget/list') ?>">
              <i class="fas fa-cog"></i> Team target setting</a>
            </li>
            <li><a href="<?= route('salebonus/list') ?>">
              <i class="fas fa-gift"></i> Bonus sheme - list & edit</a>
            </li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="exports">
            <i class="fas fa-file-export"></i>
            <span>Izvoz</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('sales/export') ?>">
              <i class="fas fa-file-excel"></i> Export sales -> xlsx</a>
            </li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="bonus">
            <i class="fas fa-gift"></i>
            <span>Bonus</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('teambonus') ?>">
              <i class="fas fa-users"></i> Team Bonus</a>
            </li>
            <li><a href="<?= route('teambonusfinancije') ?>">
              <i class="fas fa-euro-sign"></i> Team Bonus Financije</a>
            </li>
            <li><a href="<?= route('agentbonus') ?>">
              <i class="fas fa-user"></i> Agent Bonus</a>
            </li>
            <li><a href="<?= route('agentbonusbodovanje') ?>">
              <i class="fas fa-trophy"></i> Agent Bonus Bodovanje</a>
            </li>
          </ul>
        </li>

      </ul>
    </div>
  </div>

  <div class="main-content">
    <div class="content-header">
      <h2>Sales Dashboard</h2>
      <p>Stvarni podaci iz baze - analiza prodaje u realnom vremenu</p>
    </div>

    <div class="content-body">
      <!-- Key Performance Indicators -->
      <div class="dashboard-cards">
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-chart-line"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['totalSales'] ?? 0 ?></span>
            <span class="card-label">Ukupno prodaja</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-check-circle"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['activeSales'] ?? 0 ?></span>
            <span class="card-label">Aktivne prodaje</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-percentage"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= number_format($statistics['conversionRate'] ?? 0, 1) ?>%</span>
            <span class="card-label">Conversion Rate</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-exclamation-triangle"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= number_format($statistics['stornoRate'] ?? 0, 1) ?>%</span>
            <span class="card-label">Storno Rate</span>
          </div>
        </div>
      </div>

      <!-- Secondary KPIs -->
      <div class="secondary-kpis">
        <div class="kpi-item">
          <div class="kpi-icon">
            <i class="fas fa-calendar-day"></i>
          </div>
          <div class="kpi-data">
            <span class="kpi-value"><?= $statistics['todaySales'] ?? 0 ?></span>
            <span class="kpi-label">Danas</span>
          </div>
        </div>
        
        <div class="kpi-item">
          <div class="kpi-icon">
            <i class="fas fa-calendar-week"></i>
          </div>
          <div class="kpi-data">
            <span class="kpi-value"><?= $statistics['thisWeekSales'] ?? 0 ?></span>
            <span class="kpi-label">Ovaj tjedan</span>
          </div>
        </div>
        
        <div class="kpi-item">
          <div class="kpi-icon">
            <i class="fas fa-chart-line"></i>
          </div>
          <div class="kpi-data">
            <span class="kpi-value"><?= number_format($statistics['monthlyGrowth'] ?? 0, 1) ?>%</span>
            <span class="kpi-label">Mjesečni rast</span>
          </div>
        </div>
        
        <div class="kpi-item">
          <div class="kpi-icon">
            <i class="fas fa-clock"></i>
          </div>
          <div class="kpi-data">
            <span class="kpi-value"><?= $statistics['pendingActions'] ?? 0 ?></span>
            <span class="kpi-label">Pending akcije</span>
          </div>
        </div>
        
        <div class="kpi-item">
          <div class="kpi-icon">
            <i class="fas fa-hourglass-half"></i>
          </div>
          <div class="kpi-data">
            <span class="kpi-value"><?= $statistics['potentialSales'] ?? 0 ?></span>
            <span class="kpi-label">Potencijal</span>
          </div>
        </div>
      </div>
      
      <!-- Charts Row -->
      <div class="stats-cards">
        <!-- Sales Funnel -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-filter"></i> Sales Funnel</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="salesFunnelChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Monthly Trends -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-line"></i> Mjesečni trendovi</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="monthlyTrendsChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Status Distribution -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-pie"></i> Status distribucija</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="statusDistributionChart"></canvas>
            </div>
          </div>
        </div>
      </div>

      <!-- Performance Tables Row -->
      <div class="stats-cards">
        <!-- Top Services -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-star"></i> Najbolje usluge</h3>
          </div>
          <div class="stats-card-body">
            <div class="performance-table">
              <?php if (isset($statistics['topServices']) && count($statistics['topServices']) > 0): ?>
                <div class="performance-header">
                  <div class="perf-col">Usluga</div>
                  <div class="perf-col">Ukupno</div>
                  <div class="perf-col">Aktivno</div>
                  <div class="perf-col">Rate</div>
                </div>
                <?php foreach (array_slice($statistics['topServices'], 0, 8) as $service): ?>
                  <?php $rate = $service['total_count'] > 0 ? ($service['active_count'] / $service['total_count']) * 100 : 0; ?>
                  <div class="performance-row">
                    <div class="perf-col service-name"><?= htmlspecialchars($service['service']) ?></div>
                    <div class="perf-col"><?= $service['total_count'] ?></div>
                    <div class="perf-col"><?= $service['active_count'] ?></div>
                    <div class="perf-col">
                      <span class="performance-rate <?= $rate >= 60 ? 'high' : ($rate >= 40 ? 'medium' : 'low') ?>">
                        <?= number_format($rate, 1) ?>%
                      </span>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php else: ?>
                <div class="empty-state">
                  <p>Nema dostupnih podataka o uslugama</p>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Top Agents -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-trophy"></i> Najbolji djelatnici</h3>
          </div>
          <div class="stats-card-body">
            <div class="agents-list">
              <?php if (isset($statistics['topAgents']) && count($statistics['topAgents']) > 0): ?>
                <?php foreach (array_slice($statistics['topAgents'], 0, 8) as $index => $agent): ?>
                  <div class="agent-item">
                    <div class="agent-rank"><?= $index + 1 ?></div>
                    <div class="agent-info">
                      <span class="agent-name"><?= htmlspecialchars($agent['agent']) ?></span>
                      <div class="agent-stats">
                        <span class="agent-total"><?= $agent['total_sales'] ?> ukupno</span>
                        <span class="agent-active"><?= $agent['active_sales'] ?> aktivno</span>
                        <span class="agent-rate"><?= $agent['conversion_rate'] ?>% rate</span>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php else: ?>
                <div class="empty-state">
                  <p>Nema dostupnih podataka o djelatnicima</p>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Recent Activity -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-clock"></i> Nedavna aktivnost</h3>
          </div>
          <div class="stats-card-body">
            <div class="activity-list">
              <?php if (isset($statistics['recentConversions']) && count($statistics['recentConversions']) > 0): ?>
                <?php foreach ($statistics['recentConversions'] as $conversion): ?>
                  <div class="activity-item">
                    <div class="activity-icon">
                      <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="activity-details">
                      <div class="activity-text">
                        <strong><?= htmlspecialchars($conversion['sale_imeiprezime']) ?></strong>
                        - <?= htmlspecialchars($conversion['sale_prodanausluga']) ?>
                      </div>
                      <div class="activity-meta">
                        <span class="activity-agent"><?= htmlspecialchars($conversion['sale_djelatnik']) ?></span>
                        <span class="activity-date"><?= date('d.m.Y', strtotime($conversion['sale_statusdate'])) ?></span>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php else: ?>
                <div class="empty-state">
                  <p>Nema nedavnih konverzija</p>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>

      <!-- Current Month Highlights -->
      <div class="highlights-section">
        <div class="highlights-header">
          <h3><i class="fas fa-star"></i> Highlights ovog mjeseca</h3>
        </div>
        <div class="highlights-grid">
          <div class="highlight-item">
            <div class="highlight-icon">
              <i class="fas fa-user-tie"></i>
            </div>
            <div class="highlight-content">
              <span class="highlight-label">Najbolji djelatnik</span>
              <span class="highlight-value">
                <?= $statistics['bestAgentThisMonth'] ? htmlspecialchars($statistics['bestAgentThisMonth']) : 'N/A' ?>
              </span>
            </div>
          </div>
          
          <div class="highlight-item">
            <div class="highlight-icon">
              <i class="fas fa-award"></i>
            </div>
            <div class="highlight-content">
              <span class="highlight-label">Najtraženija usluga</span>
              <span class="highlight-value">
                <?= $statistics['topServiceThisMonth'] ? htmlspecialchars($statistics['topServiceThisMonth']) : 'N/A' ?>
              </span>
            </div>
          </div>
          
          <div class="highlight-item">
            <div class="highlight-icon">
              <i class="fas fa-calendar-check"></i>
            </div>
            <div class="highlight-content">
              <span class="highlight-label">Ovaj tjedan vs prošli</span>
              <span class="highlight-value">
                <?php 
                $thisWeek = $statistics['thisWeekSales'] ?? 0;
                $lastWeek = $statistics['lastWeekSales'] ?? 1;
                $weeklyChange = $lastWeek > 0 ? (($thisWeek - $lastWeek) / $lastWeek) * 100 : 0;
                $changeClass = $weeklyChange >= 0 ? 'positive' : 'negative';
                ?>
                <span class="change-indicator <?= $changeClass ?>">
                  <?= $weeklyChange >= 0 ? '+' : '' ?><?= number_format($weeklyChange, 1) ?>%
                </span>
              </span>
            </div>
          </div>
        </div>
      </div>

      <!-- Quick Actions -->
      <div class="management-cards">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-bolt"></i> Brze akcije
            </h3>
          </div>
          <div class="card-body">
            <div class="quick-actions">
              <a href="<?= route('sale/edit') ?>" class="action-button primary">
                <i class="fas fa-plus"></i> Nova prodaja
              </a>
              <a href="<?= route('sales/export') ?>" class="action-button secondary">
                <i class="fas fa-file-export"></i> Izvoz izvještaja
              </a>
              <a href="<?= route('salebonus/list') ?>?type=prijenos_bez_fokusa" class="action-button tertiary">
                <i class="fas fa-gift"></i> Bonus sheme
              </a>
              <a href="<?= route('teambonus') ?>" class="action-button tertiary">
                <i class="fas fa-users"></i> Team Bonus
              </a>
              <a href="<?= route('agentbonus') ?>" class="action-button tertiary">
                <i class="fas fa-user"></i> Agent Bonus
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>