<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('flatpickr');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.editsales'); ?>

@errormodalreturn

<div class="form-container">

    <div class="form-header" data-sale-id="<?= htmlspecialchars($sale->id ?? ''); ?>">
        <h2>
            <?php if(isset($sale->id)): ?>
                Uredi prodaju #<?= htmlspecialchars($sale->id ?? ''); ?>
            <?php else: ?>
                Nova prodaja
            <?php endif; ?>
        </h2>
    </div>

    <form method="post" class="modern-form">

        @csrf

        <?php if (isset($edit_token)): ?>
            <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>
        
        <div class="form-card">
            <div class="form-card-header">
                <i class="fas fa-user-circle"></i>
                <h3>Osobni podaci</h3>
            </div>
            
            <div class="form-card-body">
                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label for="sale_imeiprezime">Ime i prezime</label>
                        <input type="text" class="form-control" id="sale_imeiprezime" name="sale[sale_imeiprezime]" value="<?= htmlspecialchars($sale->sale_imeiprezime ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_oib">OIB</label>
                        <div class="input-group">
                            <input type="text" 
                            class="form-control" 
                            id="sale_oib" 
                            name="sale[sale_oib]" 
                            pattern="[0-9]{11}"
                            maxlength="11"
                            value="<?= htmlspecialchars($sale->sale_oib ?? ''); ?>">
                            <div class="input-group-append">
                                <span class="input-group-text" id="oib-warning">
                                    <i class="fas fa-exclamation-triangle text-warning"></i>
                                </span>
                            </div>
                        </div>
                        <small id="oib-warning-text" class="text-warning">
                            OIB već postoji u bazi
                        </small>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="sale_brojoi">Broj OI</label>
                        <input type="number" class="form-control" id="sale_brojoi" name="sale[sale_brojoi]" value="<?= htmlspecialchars($sale->sale_brojoi ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_datumrodj_input">Datum rođenja</label>
                        <div class="input-group">
                            <input type="text" id="sale_datumrodj_input" class="form-control" name="sale[sale_datumrodj]"
                                value="<?=isset($sale->sale_datumrodj) && $sale->sale_datumrodj ? date('d.m.Y',strtotime($sale->sale_datumrodj)) : ''?>" />
                            <div class="input-group-append">
                                <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-card">
            <div class="form-card-header">
                <i class="fas fa-map-marker-alt"></i>
                <h3>Kontakt informacije</h3>
            </div>
            
            <div class="form-card-body">
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="sale_adresa">Adresa</label>
                        <input type="text" class="form-control" id="sale_adresa" name="sale[sale_adresa]" value="<?= htmlspecialchars($sale->sale_adresa ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_kontaktbroj">Kontakt broj</label>
                        <input type="text" class="form-control" id="sale_kontaktbroj" name="sale[sale_kontaktbroj]" value="<?= htmlspecialchars($sale->sale_kontaktbroj ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_mail">E-mail</label>
                        <input type="text" class="form-control" id="sale_mail" name="sale[sale_mail]" value="<?= htmlspecialchars($sale->sale_mail ?? ''); ?>">
                    </div>
                </div>
            </div>
        </div>

        <div class="form-card">
            <div class="form-card-header">
                <i class="fas fa-exchange-alt"></i>
                <h3>Informacije o prijenosu usluge</h3>
            </div>
            
            <div class="form-card-body">
                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label for="sale_brojzaprijenos">Broj za prijenos (ako se radi MNP)</label>
                        <input type="text" class="form-control" id="sale_brojzaprijenos" name="sale[sale_brojzaprijenos]" value="<?= htmlspecialchars($sale->sale_brojzaprijenos ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_maticnioperator">Matični operator</label>
                        <select class="form-control" id="sale_maticnioperator" name="sale[sale_maticnioperator]">
                            <option value="<?= htmlspecialchars($sale->sale_maticnioperator ?? ''); ?>"><?= htmlspecialchars($sale->sale_maticnioperator ?? ''); ?></option>
                            <option>AKTON d.o.o.</option>
                            <option>4tel telekomunikacije d.o.o.</option>
                            <option>Amis Telekom d.d.</option>
                            <option>Bnet d.o.o.</option>
                            <option>Btnet d.o.o.</option>
                            <option>Chaos d.o.o.</option>
                            <option>DATABOX d.o.o.</option>
                            <option>ECO NET d.o.o.</option>
                            <option>Fenice Telekom Grupa d.o.o.</option>
                            <option>HAKOM</option>
                            <option>Hrvatski Telekom d.d.</option>
                            <option>INTERSAT telekomunikacije</option>
                            <option>Iskon Internet d.d.</option>
                            <option>Keter Telekom d.o.o.</option>
                            <option>Magic Net d.o.o.</option>
                            <option>Metronet d.d.</option>
                            <option>NOVI-NET TELEKOM</option>
                            <option>Novi-net mobile d.o.o.</option>
                            <option>Omonia d.o.o.</option>
                            <option>Optika kabel TV d.o.o.</option>
                            <option>PRO_PING (fixed)</option>
                            <option>Primatel d.o.o.</option>
                            <option>SIGNUM Telekomunikacije d.o.o.</option>
                            <option>Sedmi odjel d.o.o.</option>
                            <option>Softnet d.o.o.</option>
                            <option>TEHNOLINE Telekom d.o.o.</option>
                            <option>TOTALTV</option>
                            <option>TWILIO IRELAND LIMITED</option>
                            <option>Telemach Hrvatska d.o.o. fixed</option>
                            <option>Terrakom d.o.o.</option>
                            <option>VOXBONE</option>
                            <option>Vipnet d.o.o. (fixed)</option>
                            <option>Vodatel (fixed)</option>
                        </select>
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_brojzap2p">Broj za P2P</label>
                        <input type="text" class="form-control" id="sale_brojzap2p" name="sale[sale_brojzap2p]" value="<?= htmlspecialchars($sale->sale_brojzap2p ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_brojzafnp">Broj za prijenos (ako se radi FNP)</label>
                        <input type="text" class="form-control" id="sale_brojzafnp" name="sale[sale_brojzafnp]" value="<?= htmlspecialchars($sale->sale_brojzafnp ?? ''); ?>">
                    </div>
                </div>

                <!-- Novi red za informacije o prijenosu vlasništva -->
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="sale_imeiprezime_prijenosvl">Ime i prezime (prijenos vlasništva)</label>
                        <input type="text" class="form-control" id="sale_imeiprezime_prijenosvl" name="sale[sale_imeiprezime_prijenosvl]" value="<?= htmlspecialchars($sale->sale_imeiprezime_prijenosvl ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_oib_prijenosvl">OIB (prijenos vlasništva)</label>
                        <div class="input-group">
                            <input type="text" 
                            class="form-control" 
                            id="sale_oib_prijenosvl" 
                            name="sale[sale_oib_prijenosvl]" 
                            pattern="[0-9]{11}"
                            maxlength="11"
                            value="<?= htmlspecialchars($sale->sale_oib_prijenosvl ?? ''); ?>">
                            <div class="input-group-append">
                                <span class="input-group-text" id="oib-prijenosvl-warning">
                                    <i class="fas fa-exclamation-triangle text-warning"></i>
                                </span>
                            </div>
                        </div>
                        <small id="oib-prijenosvl-warning-text" class="text-warning">
                            OIB već postoji u bazi
                        </small>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_paketi">Paketi</label>
                        <select class="form-control" id="sale_paketi" name="sale[sale_paketi]">
                            <option value="<?= htmlspecialchars($sale->sale_paketi ?? ''); ?>"><?= htmlspecialchars($sale->sale_paketi ?? ''); ?></option>
                            <option>Obiteljski paket</option>
                            <option>Sportski paket</option>
                            <option>Filmski paket</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-card">
            <div class="form-card-header">
                <i class="fas fa-shopping-cart"></i>
                <h3>Usluge i proizvodi</h3>
            </div>
            
            <div class="form-card-body">
                <!-- Prvi red: Prodana usluga, TV usluga, Kućni telefon -->
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="sale_prodanausluga">Prodana usluga</label>
                        <select class="form-control" id="sale_prodanausluga" name="sale[sale_prodanausluga]">
                            <option value="<?= htmlspecialchars($sale->sale_prodanausluga ?? ''); ?>"><?= htmlspecialchars($sale->sale_prodanausluga ?? ''); ?></option>
                            <?php foreach ($vrste as $vrsta): ?>
                                <option><?= htmlspecialchars($vrsta->TARIFA ?? ''); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_tvusluga">TV usluga</label>
                        <select class="form-control" id="sale_tvusluga" name="sale[sale_tvusluga]">
                            <option value="<?= htmlspecialchars($sale->sale_tvusluga ?? ''); ?>"><?= htmlspecialchars($sale->sale_tvusluga ?? ''); ?></option>
                            <option>DA</option>
                            <option>NE</option>
                        </select>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_kucnitel">Kućni telefon</label>
                        <select class="form-control" id="sale_kucnitel" name="sale[sale_kucnitel]">
                            <option value="<?= htmlspecialchars($sale->sale_kucnitel ?? ''); ?>"><?= htmlspecialchars($sale->sale_kucnitel ?? ''); ?></option>
                            <option>DA</option>
                            <option>NE</option>
                        </select>
                    </div>
                </div>

                <!-- Drugi red: Mobilni uređaj, Uređaj (Navesti MM), Uređaj na rate -->
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="sale_mobilniuredaj">Mobilni uređaj</label>
                        <select class="form-control" id="sale_mobilniuredaj" name="sale[sale_mobilniuredaj]">
                            <option value="<?= htmlspecialchars($sale->sale_mobilniuredaj ?? ''); ?>"><?= htmlspecialchars($sale->sale_mobilniuredaj ?? ''); ?></option>
                            <option>DA</option>
                            <option>NE</option>
                        </select>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_uredajnavesti">Uređaj (Navesti MM)</label>
                        <input type="text" class="form-control" id="sale_uredajnavesti" name="sale[sale_uredajnavesti]" value="<?= htmlspecialchars($sale->sale_uredajnavesti ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-4">
                        <label for="sale_uredajnarate">Uređaj na rate</label>
                        <input type="text" class="form-control" id="sale_uredajnarate" name="sale[sale_uredajnarate]" value="<?= htmlspecialchars($sale->sale_uredajnarate ?? ''); ?>">
                    </div>
                </div>

                <!-- Treći red: Broj narudžbe, OIB za Mozaik, Promocija, Način primanja računa -->
                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label for="sale_brojnarudzbe">Broj narudžbe</label>
                        <input type="text" class="form-control sales-locked" id="sale_brojnarudzbe" name="sale[sale_brojnarudzbe]" value="<?= htmlspecialchars($sale->sale_brojnarudzbe ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_oibzamozaik">OIB za Mozaik</label>
                        <input type="text" class="form-control" id="sale_oibzamozaik" name="sale[sale_oibzamozaik]" value="<?= htmlspecialchars($sale->sale_oibzamozaik ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_promocija">Promocija (navesti koja je promocija prodana)</label>
                        <input type="text" class="form-control" id="sale_promocija" name="sale[sale_promocija]" value="<?= htmlspecialchars($sale->sale_promocija ?? ''); ?>">
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_nacinprimanja">Način primanja računa</label>
                        <input type="text" class="form-control" id="sale_nacinprimanja" name="sale[sale_nacinprimanja]" value="<?= htmlspecialchars($sale->sale_nacinprimanja ?? ''); ?>">
                    </div>
                </div>
            </div>
        </div>

        <div class="form-card">
            <div class="form-card-header">
                <i class="fas fa-user-shield"></i>
                <h3>Status prodaje i informacije</h3>
            </div>
            
            <div class="form-card-body">
                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label for="sale_djelatnik">Djelatnik</label>
                        <select class="form-control sales-locked" id="sale_djelatnik" name="sale[sale_djelatnik]">
                            <option value="<?= htmlspecialchars($sale->sale_djelatnik ?? ''); ?>"><?= htmlspecialchars($sale->sale_djelatnik ?? ''); ?></option>
                            <?php foreach ($osobe as $osoba): ?>
                                <?php if ($osoba->radnomjesto=="Agent"): ?>
                                    <option><?= htmlspecialchars($osoba->name ?? ''); ?></option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_kontrolor">Kontrolor</label>
                        <select class="form-control sales-locked" id="sale_kontrolor" name="sale[sale_kontrolor]">
                            <option value="<?= htmlspecialchars($sale->sale_kontrolor ?? ''); ?>"><?= htmlspecialchars($sale->sale_kontrolor ?? ''); ?></option>
                            <?php foreach ($osobe as $osoba): ?>
                                <?php if ($osoba->radnomjesto=="Kontrolor"): ?>
                                    <option><?= htmlspecialchars($osoba->name ?? ''); ?></option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_status">Status</label>
                        <select class="form-control sales-locked" id="sale_status" name="sale[sale_status]">
                            <option value="<?= htmlspecialchars($sale->sale_status ?? ''); ?>"><?= htmlspecialchars($sale->sale_status ?? ''); ?></option>
                            <option>Potencijal</option>
                            <option>Uneseno</option>
                            <option>Aktivno</option>
                            <option>Storno</option>
                        </select>
                    </div>

                    <div class="form-group col-md-3">
                        <label for="sale_kontrolnipoziv">Kontrolni poziv</label>
                        <select class="form-control sales-locked" id="sale_kontrolnipoziv" name="sale[sale_kontrolnipoziv]">
                            <option value="<?= htmlspecialchars($sale->sale_kontrolnipoziv ?? ''); ?>"><?= htmlspecialchars($sale->sale_kontrolnipoziv ?? ''); ?></option>
                            <option>DA</option>
                            <option>NE</option>
                        </select>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="sale_statusdate_input">Datum promjene statusa</label>
                        <div class="input-group">
                            <input type="text" id="sale_statusdate_input" class="form-control sales-locked" name="sale[sale_statusdate]" 
                                value="<?=isset($sale->sale_statusdate) && $sale->sale_statusdate ? date('d-m-Y',strtotime($sale->sale_statusdate)) : ''?>" />
                            <div class="input-group-append">
                                <div class="input-group-text sales-locked"><i class="fas fa-calendar"></i></div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="sale_comment">Komentar</label>
                        <textarea class="form-control" id="sale_comment" name="sale[sale_comment]" rows="3"><?= htmlspecialchars($sale->sale_comment ?? ''); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-actions">
            <button type="submit" name="btnSubmit" class="btn btn-primary">
                <i class="fas fa-save"></i> Spremi
            </button>
            <a href="<?= route('sales/list') ?>" class="btn btn-secondary">
                <i class="fas fa-times"></i> Odustani
            </a>
        </div>
        
    </form>
    
</div>