@errormodalreturn

<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.edittarget'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1><?= isset($target->id) ? 'Uredi target' : 'Dodaj novi target' ?></h1>
      <p>Unesite potrebne podatke za target</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('saletarget/list') ?>" class="action-button secondary">
        <i class="fas fa-arrow-left"></i> Natrag na popis
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <h3 class="card-title">
        <i class="fas fa-edit"></i> Podaci o targetu
      </h3>
    </div>
    <div class="card-body">
      <form action="" method="post" class="modern-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
          <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <div class="form-grid">
          <div class="form-group">
            <label for="prijenos">Prijenos</label>
            <input type="number" 
                   class="form-control" 
                   id="prijenos" 
                   name="target[prijenos]" 
                   required 
                   step="0.01"
                   value="<?= htmlspecialchars($target->prijenos ?? ''); ?>"
                   placeholder="Unesite cilj za prijenos">
            <small class="form-text">Target za prijenos</small>
          </div>

          <div class="form-group">
            <label for="p2p">P2P</label>
            <input type="number" 
                   class="form-control" 
                   id="p2p" 
                   name="target[p2p]" 
                   required 
                   step="0.01"
                   value="<?= htmlspecialchars($target->p2p ?? ''); ?>"
                   placeholder="Unesite P2P target">
            <small class="form-text">P2P target</small>
          </div>
          
          <div class="form-group">
            <label for="tomato">Tomato</label>
            <input type="number" 
                   class="form-control" 
                   id="tomato" 
                   name="target[tomato]" 
                   required 
                   step="0.01"
                   value="<?= htmlspecialchars($target->tomato ?? ''); ?>"
                   placeholder="Unesite Tomato target">
            <small class="form-text">Tomato target</small>
          </div>

          <div class="form-group">
            <label for="target_period">Target Period (YYYY-MM)</label>
            <input type="text" 
                  class="form-control" 
                  id="target_period" 
                  name="target[target_period]" 
                  required 
                  pattern="\d{4}-\d{2}"
                  placeholder="Enter target period (e.g., 2025-01)"
                  value="<?= htmlspecialchars($target->target_period ?? ''); ?>"
                  maxlength="7">
            <small class="form-text">Enter target period in YYYY-MM format</small>
          </div>
        </div>

        <div class="form-actions">
          <button type="button" class="form-button secondary" id="cancelButton">
            <i class="fas fa-times"></i> Odustani
          </button>
          <button type="submit" class="form-button primary" value="submit">
            <i class="fas fa-save"></i> Spremi
          </button>
        </div>
      </form>
    </div>
  </div>
</div>