<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.listtarget'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1>Tablica targeta</h1>
      <p>Pregled i upravljanje tablicom targeta</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('saletarget/edit') ?>" class="action-button primary">
        <i class="fas fa-plus"></i> Dodaj novi target
      </a>
      <button type="button" id="exportToggle" class="action-button secondary">
        <i class="fas fa-download"></i> Izvoz
      </button>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-list-ul"></i> Popis targeta
      </div>
      <div class="card-tools">
        <div class="search-container">
          <input type="text" id="dataSearch" placeholder="Pretraži targete...">
          <i class="fas fa-search"></i>
        </div>
        <div class="filter-dropdown">
          <button class="filter-button">
            <i class="fas fa-filter"></i> Filter
          </button>
          <div class="filter-menu">
            <div class="filter-group">
              <label>Po prijenosu:</label>
              <div class="filter-options" id="prijenosFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
            <div class="filter-group">
              <label>Po P2P:</label>
              <div class="filter-options" id="p2pFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="table-responsive">
      <table id="dataTable" class="data-table">
        <thead>
          <tr>
            <th width="80">Akcije</th>
            <th class="sortable">Prijenos</th>
            <th class="sortable">P2P</th>
            <th class="sortable">Tomato</th>
            <th class="sortable">Target Period</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($targets as $target): ?>
          <tr>
            <td>
              <div class="table-actions">
                <a href="<?= route('saletarget/edit') ?>/<?=$target->id?>" 
                   class="action-btn edit" title="Uredi target">
                  <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="action-btn delete" 
                        data-id="<?=$target->id?>" 
                        data-name="Target (P: <?= htmlspecialchars($target->prijenos ?? '', ENT_QUOTES, 'UTF-8') ?>, P2P: <?= htmlspecialchars($target->p2p ?? '', ENT_QUOTES, 'UTF-8') ?>)"
                        title="Obriši target">
                  <i class="fas fa-trash-alt"></i>
                </button>
              </div>
            </td>
            <td><?= htmlspecialchars($target->prijenos ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <td><?= htmlspecialchars($target->p2p ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <td><?= htmlspecialchars($target->tomato ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <td><?= htmlspecialchars($target->target_period ?? '', ENT_QUOTES, 'UTF-8') ?></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Export Panel -->
  <div id="exportPanel" class="export-panel">
    <div class="card">
      <div class="card-header">
        <div class="card-title">
          <i class="fas fa-file-export"></i> Izvoz podataka
        </div>
        <button id="closeExport" class="close-btn">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="card-body">
        <form action="" method="post" id="exportForm">
          
          @csrf
          
          <div class="form-group">
            <label for="file_type">Format izvoza</label>
            <select name="file_type" id="file_type" class="form-control">
              <option value="Xlsx">Excel (XLSX)</option>
              <option value="Csv">CSV</option>
            </select>
          </div>
          
          <div class="form-actions">
            <button type="submit" name="export" value="Export" class="form-button primary">
              <i class="fas fa-download"></i> Izvoz podataka
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Delete Confirmation Modal -->
  <div id="deleteModal" class="modal">
    <div class="modal-content">
      <div class="modal-header">
        <h3>Potvrda brisanja</h3>
        <button class="modal-close">&times;</button>
      </div>
      <div class="modal-body">
        <p>Jeste li sigurni da želite obrisati <strong id="deleteName"></strong>?</p>
        <p class="text-danger">Ova akcija se ne može poništiti.</p>
      </div>
      <div class="modal-footer">
        <form action="<?= route('saletarget/delete') ?>" method="post" id="deleteForm">
          
          @csrf

          <input type="hidden" name="id" id="deleteId" value="">
          <button type="button" class="form-button secondary modal-cancel">Odustani</button>
          <button type="submit" class="form-button danger">Obriši</button>
        </form>
      </div>
    </div>
  </div>
</div>