<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.teambonus'); ?>

<div class="admin-dashboard">
  <!-- Data container for charts -->
  <div id="teambonus-charts-data" 
    data-monthly='<?= json_encode($statistics['monthlyActiveSales'] ?? []) ?>'
    data-services='<?= json_encode($statistics['activeSalesByService'] ?? []) ?>'
    data-trends='<?= json_encode($statistics['serviceGrowthTrends'] ?? []) ?>'
    data-comparison='<?= json_encode($statistics['monthlyComparison'] ?? []) ?>'
    ></div>

  <div class="sidebar">
    <div class="sidebar-header">
      <h3>Team Bonus</h3>
      <button id="mobile-toggle" class="mobile-toggle">
        <i class="fas fa-bars"></i>
      </button>
    </div>
    
    <div class="sidebar-content">
      <ul class="sidebar-menu">
        <li class="sidebar-item active">
          <a href="#" class="sidebar-link" data-target="dashboard">
            <i class="fas fa-tachometer-alt"></i>
            <span>Dashboard</span>
          </a>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="reports">
            <i class="fas fa-chart-line"></i>
            <span>Izvještaji</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('teambonus/detail') ?>">
              <i class="fas fa-search"></i> Detaljni izvještaj</a>
            </li>
            <li><a href="<?= route('teambonus/print') ?>">
              <i class="fas fa-print"></i> Ispis</a>
            </li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="exports">
            <i class="fas fa-file-export"></i>
            <span>Izvoz</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('teambonus/export') ?>">
              <i class="fas fa-file-excel"></i> Excel izvoz</a>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>

  <div class="main-content">
    <div class="content-header">
      <h2>Team Bonus Dashboard</h2>
      <p>Pregled aktivnih prodaja po uslugama i mjesecima</p>
    </div>

    <div class="content-body">
      <!-- Summary Cards -->
      <div class="dashboard-cards">
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-chart-line"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['currentMonthActives'] ?? 0 ?></span>
            <span class="card-label">Aktivne prodaje ovaj mjesec</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-chart-bar"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['lastMonthActives'] ?? 0 ?></span>
            <span class="card-label">Aktivne prodaje prošli mjesec</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-layer-group"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['totalActiveServices'] ?? 0 ?></span>
            <span class="card-label">Ukupno vrsta usluga</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-percentage"></i>
          </div>
          <div class="card-data">
            <?php
            $currentMonth = $statistics['currentMonthActives'] ?? 0;
            $lastMonth = $statistics['lastMonthActives'] ?? 1;
            $growth = $lastMonth > 0 ? (($currentMonth - $lastMonth) / $lastMonth) * 100 : 0;
            ?>
            <span class="card-value"><?= number_format($growth, 1) ?>%</span>
            <span class="card-label">Mjesečni rast</span>
          </div>
        </div>
      </div>
      
      <!-- Charts Row -->
      <div class="stats-cards">
        <!-- Monthly Active Sales Chart -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-line"></i> Mjesečne aktivne prodaje</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="monthlyActivesChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Active Sales By Service Chart -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-pie"></i> Aktivne prodaje po uslugama</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="serviceActivesChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Service Growth Trends Chart -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-area"></i> Trend rasta usluga</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="serviceGrowthChart"></canvas>
            </div>
          </div>
        </div>
      </div>

      <!-- Data Tables Row -->
      <div class="stats-cards">
        <!-- Top Performing Services -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-trophy"></i> Najbolje usluge</h3>
          </div>
          <div class="stats-card-body">
            <div class="top-performers-list">
              <?php if (isset($statistics['topPerformingServices']) && count($statistics['topPerformingServices']) > 0): ?>
                <?php foreach ($statistics['topPerformingServices'] as $index => $service): ?>
                  <div class="performer-item">
                    <div class="performer-rank"><?= $index + 1 ?></div>
                    <div class="performer-info">
                      <span class="performer-name"><?= htmlspecialchars($service['service_type']) ?></span>
                      <div class="performer-stats">
                        <span class="performer-tasks"><i class="fas fa-chart-line"></i> <?= $service['active_count'] ?> aktivnih</span>
                        <span class="performer-work"><i class="fas fa-calendar"></i> <?= $service['current_month_count'] ?> ovaj mjesec</span>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php else: ?>
                <div class="empty-state">
                  <p>Nema dostupnih podataka o aktivnim uslugama</p>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Monthly Comparison Table -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-bar"></i> Mjesečna usporedba</h3>
          </div>
          <div class="stats-card-body">
            <?php if (isset($statistics['monthlyComparison']) && count($statistics['monthlyComparison']) > 0): ?>
              <div class="comparison-table">
                <div class="comparison-header">
                  <div class="comparison-col">Usluga</div>
                  <div class="comparison-col">Ovaj mjesec</div>
                  <div class="comparison-col">Prošli mjesec</div>
                  <div class="comparison-col">Promjena</div>
                </div>
                <?php foreach ($statistics['monthlyComparison'] as $comparison): ?>
                  <?php
                  $current = $comparison['current_month'];
                  $previous = $comparison['previous_month'];
                  $change = $previous > 0 ? (($current - $previous) / $previous) * 100 : 0;
                  $changeClass = $change > 0 ? 'positive' : ($change < 0 ? 'negative' : 'neutral');
                  ?>
                  <div class="comparison-row">
                    <div class="comparison-col service-name" data-label="Usluga"><?= htmlspecialchars($comparison['service_type']) ?></div>
                    <div class="comparison-col" data-label="Ovaj mjesec"><?= $current ?></div>
                    <div class="comparison-col" data-label="Prošli mjesec"><?= $previous ?></div>
                    <div class="comparison-col change <?= $changeClass ?>" data-label="Promjena">
                      <?= $change > 0 ? '+' : '' ?><?= number_format($change, 1) ?>%
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <p>Nema dostupnih podataka za usporedbu</p>
              </div>
            <?php endif; ?>
          </div>
        </div>

        <!-- Quick Actions -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-bolt"></i> Brze akcije</h3>
          </div>
          <div class="stats-card-body">
            <div class="quick-actions">
              <a href="<?= route('teambonus/detail') ?>" class="action-button primary">
                <i class="fas fa-search"></i> Detaljni izvještaj
              </a>
              <a href="<?= route('teambonus/export') ?>" class="action-button secondary">
                <i class="fas fa-file-export"></i> Izvoz podataka
              </a>
              <a href="<?= route('teambonus/print') ?>" class="action-button tertiary">
                <i class="fas fa-print"></i> Ispis
              </a>
            </div>
          </div>
        </div>
      </div>

      <!-- Total Monthly Stats -->
      <div class="management-cards">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-calendar-alt"></i> Mjesečni pregled aktivnih prodaja
            </h3>
          </div>
          <div class="card-body">
            <?php if (isset($statistics['totalActivesByMonth']) && count($statistics['totalActivesByMonth']) > 0): ?>
              <div class="monthly-overview">
                <?php foreach (array_slice($statistics['totalActivesByMonth'], 0, 6) as $monthData): ?>
                  <div class="month-card">
                    <div class="month-name">
                      <?= date('M Y', mktime(0, 0, 0, $monthData['month'], 1, $monthData['year'])) ?>
                    </div>
                    <div class="month-count"><?= $monthData['total_active_count'] ?></div>
                    <div class="month-label">aktivnih</div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <p>Nema dostupnih mjesečnih podataka</p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>