<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.teambonusfinancije'); ?>

<div class="admin-dashboard">
  <!-- Data container for charts -->
  <div id="teambonusfinancije-charts-data" 
    data-earnings='<?= json_encode($statistics['earnings'] ?? []) ?>'
    data-monthly-trend='<?= json_encode($statistics['monthlyTrend'] ?? []) ?>'
    data-comparison='<?= json_encode($statistics['comparison'] ?? []) ?>'
    ></div>

  <div class="sidebar">
    <div class="sidebar-header">
      <h3>Team Bonus Financije</h3>
      <button id="mobile-toggle" class="mobile-toggle">
        <i class="fas fa-bars"></i>
      </button>
    </div>
    
    <div class="sidebar-content">
      <ul class="sidebar-menu">
        <li class="sidebar-item active">
          <a href="#" class="sidebar-link" data-target="dashboard">
            <i class="fas fa-euro-sign"></i>
            <span>Dashboard</span>
          </a>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="reports">
            <i class="fas fa-chart-line"></i>
            <span>Izvještaji</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('teambonusfinancije/detail') ?>">
              <i class="fas fa-search"></i> Detaljni izvještaj</a>
            </li>
            <li><a href="<?= route('teambonusfinancije/print') ?>">
              <i class="fas fa-print"></i> Ispis</a>
            </li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="exports">
            <i class="fas fa-file-export"></i>
            <span>Izvoz</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('teambonusfinancije/export') ?>">
              <i class="fas fa-file-excel"></i> Excel izvoz</a>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>

  <div class="main-content">
    <div class="content-header">
      <h2>Team Bonus Financije Dashboard</h2>
      <p>Financijski pregled zarada po bonus tipovima za <?= date('F Y', mktime(0, 0, 0, $statistics['currentMonth'], 1, $statistics['currentYear'])) ?></p>
      
      <!-- Period Filter -->
      <div class="period-filter">
        <form method="GET" class="filter-form">
          <div class="filter-group">
            <label for="month">Mjesec:</label>
            <select name="month" id="month">
              <?php for ($m = 1; $m <= 12; $m++): ?>
                <option value="<?= str_pad($m, 2, '0', STR_PAD_LEFT) ?>" 
                  <?= $statistics['currentMonth'] == str_pad($m, 2, '0', STR_PAD_LEFT) ? 'selected' : '' ?>>
                  <?= date('F', mktime(0, 0, 0, $m, 1)) ?>
                </option>
              <?php endfor; ?>
            </select>
          </div>
          <div class="filter-group">
            <label for="year">Godina:</label>
            <select name="year" id="year">
              <?php for ($y = date('Y') - 2; $y <= date('Y') + 1; $y++): ?>
                <option value="<?= $y ?>" <?= $statistics['currentYear'] == $y ? 'selected' : '' ?>>
                  <?= $y ?>
                </option>
              <?php endfor; ?>
            </select>
          </div>
          <button type="submit" class="filter-button">
            <i class="fas fa-filter"></i> Filtriraj
          </button>
        </form>
      </div>
    </div>

    <div class="content-body">
      <!-- Main Financial Summary -->
      <div class="dashboard-cards">
        <div class="dashboard-card total-card">
          <div class="card-icon">
            <i class="fas fa-euro-sign"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= number_format($statistics['totalEarnings'] ?? 0, 2) ?> €</span>
            <span class="card-label">UKUPNA ZARADA</span>
            <span class="card-period">
              <?= date('F Y', mktime(0, 0, 0, $statistics['currentMonth'], 1, $statistics['currentYear'])) ?>
            </span>
          </div>
        </div>
        
        <div class="dashboard-card comparison-card">
          <div class="card-icon">
            <i class="fas fa-chart-line"></i>
          </div>
          <div class="card-data">
            <?php 
            $currentTotal = $statistics['totalEarnings'] ?? 0;
            $previousTotal = $statistics['comparison']['compare']['total'] ?? 0;
            ?>
            <span class="card-value"><?= number_format($previousTotal, 2) ?> €</span>
            <span class="card-label">PROŠLI MJESEC</span>
            <span class="card-period">
              <?php 
              $prevMonth = $statistics['currentMonth'] == 1 ? 12 : $statistics['currentMonth'] - 1;
              $prevYear = $statistics['currentMonth'] == 1 ? $statistics['currentYear'] - 1 : $statistics['currentYear'];
              echo date('F Y', mktime(0, 0, 0, $prevMonth, 1, $prevYear));
              ?>
            </span>
          </div>
        </div>
        
        <div class="dashboard-card growth-card">
          <div class="card-icon">
            <i class="fas fa-percentage"></i>
          </div>
          <div class="card-data">
            <?php $growth = $statistics['comparison']['growth_percent'] ?? 0; ?>
            <span class="card-value <?= $growth >= 0 ? 'positive' : 'negative' ?>">
              <?= $growth >= 0 ? '+' : '' ?><?= number_format($growth, 1) ?>%
            </span>
            <span class="card-label">MJESEČNI RAST</span>
            <span class="card-period">
              <?= number_format(abs($currentTotal - $previousTotal), 2) ?> € razlika
            </span>
          </div>
        </div>
      </div>
      
      <!-- Charts Row -->
      <div class="stats-cards">
        <!-- Monthly Earnings Trend -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-line"></i> Mjesečni trend ukupnih zarada</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="monthlyEarningsChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Earnings by Bonus Type Distribution -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-pie"></i> Distribucija zarada po tipovima</h3>
          </div>
          <div class="stats-card-body">
            <div class="chart-wrapper">
              <canvas id="bonusTypeChart"></canvas>
            </div>
          </div>
        </div>
      </div>

      <!-- Detailed Breakdown by Bonus Type - AŽURIRANO za 3 kartice -->
      <div class="bonus-breakdown-grid">
        <!-- Prijenos Detailed - UNIFIED -->
        <div class="bonus-card">
          <div class="bonus-card-header">
            <h3><i class="fas fa-exchange-alt"></i> Prijenos - Sve grupe</h3>
            <small>Sat, Homebox, Parica, MNP HT, Optika, MNP Telemach</small>
          </div>
          <div class="bonus-card-body">
            <?php $prijenos = $statistics['earnings']['prijenos'] ?? []; ?>
            <div class="bonus-summary">
              <div class="summary-row">
                <span class="summary-label">Prodano:</span>
                <span class="summary-value"><?= $prijenos['sold_count'] ?? 0 ?> usluga</span>
              </div>
              <div class="summary-row">
                <span class="summary-label">Cilj:</span>
                <span class="summary-value"><?= $prijenos['target'] ?? 0 ?> usluga</span>
              </div>
              <div class="summary-row">
                <span class="summary-label">Ostvarenje:</span>
                <span class="summary-value achievement-<?= ($prijenos['achievement_percent'] ?? 0) >= 100 ? 'good' : (($prijenos['achievement_percent'] ?? 0) >= 80 ? 'ok' : 'poor') ?>">
                  <?= number_format($prijenos['achievement_percent'] ?? 0, 1) ?>%
                </span>
              </div>
              <div class="summary-row total">
                <span class="summary-label">UKUPNA ZARADA:</span>
                <span class="summary-value"><?= number_format($prijenos['total_earnings'] ?? 0, 2) ?> €</span>
              </div>
            </div>
            
            <?php if (!empty($prijenos['services'])): ?>
              <div class="services-breakdown">
                <h4>Prodane tarife:</h4>
                <?php foreach ($prijenos['services'] as $service): ?>
                  <div class="service-item">
                    <span class="service-name"><?= htmlspecialchars($service['tarifa']) ?></span>
                    <span class="service-count"><?= $service['count'] ?>x</span>
                    <span class="service-earnings"><?= number_format($service['earnings'], 2) ?> €</span>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-info-circle"></i>
                <p>Nema prodanih prijenos usluga ovaj mjesec</p>
              </div>
            <?php endif; ?>
          </div>
        </div>

        <!-- P2P Detailed -->
        <div class="bonus-card">
          <div class="bonus-card-header">
            <h3><i class="fas fa-exchange-alt"></i> P2P detaljno</h3>
          </div>
          <div class="bonus-card-body">
            <?php $p2p = $statistics['earnings']['p2p'] ?? []; ?>
            <div class="bonus-summary">
              <div class="summary-row">
                <span class="summary-label">Prodano:</span>
                <span class="summary-value"><?= $p2p['sold_count'] ?? 0 ?> usluga</span>
              </div>
              <div class="summary-row">
                <span class="summary-label">Cilj:</span>
                <span class="summary-value"><?= $p2p['target'] ?? 0 ?> usluga</span>
              </div>
              <div class="summary-row">
                <span class="summary-label">Ostvarenje:</span>
                <span class="summary-value achievement-<?= ($p2p['achievement_percent'] ?? 0) >= 100 ? 'good' : (($p2p['achievement_percent'] ?? 0) >= 80 ? 'ok' : 'poor') ?>">
                  <?= number_format($p2p['achievement_percent'] ?? 0, 1) ?>%
                </span>
              </div>
              <div class="summary-row total">
                <span class="summary-label">UKUPNA ZARADA:</span>
                <span class="summary-value"><?= number_format($p2p['total_earnings'] ?? 0, 2) ?> €</span>
              </div>
            </div>
            
            <?php if (!empty($p2p['services'])): ?>
              <div class="services-breakdown">
                <h4>Prodane tarife:</h4>
                <?php foreach ($p2p['services'] as $service): ?>
                  <div class="service-item">
                    <span class="service-name"><?= htmlspecialchars($service['tarifa']) ?></span>
                    <span class="service-count"><?= $service['count'] ?>x</span>
                    <span class="service-earnings"><?= number_format($service['earnings'], 2) ?> €</span>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-info-circle"></i>
                <p>Nema prodanih P2P usluga ovaj mjesec</p>
              </div>
            <?php endif; ?>
          </div>
        </div>

        <!-- Tomato Detailed -->
        <div class="bonus-card">
          <div class="bonus-card-header">
            <h3><i class="fas fa-leaf"></i> Tomato detaljno</h3>
          </div>
          <div class="bonus-card-body">
            <?php $tomato = $statistics['earnings']['tomato'] ?? []; ?>
            <div class="bonus-summary">
              <div class="summary-row">
                <span class="summary-label">Prodano:</span>
                <span class="summary-value"><?= $tomato['sold_count'] ?? 0 ?> usluga</span>
              </div>
              <div class="summary-row">
                <span class="summary-label">Cilj:</span>
                <span class="summary-value"><?= $tomato['target'] ?? 0 ?> usluga</span>
              </div>
              <div class="summary-row">
                <span class="summary-label">Ostvarenje:</span>
                <span class="summary-value achievement-<?= ($tomato['achievement_percent'] ?? 0) >= 100 ? 'good' : (($tomato['achievement_percent'] ?? 0) >= 80 ? 'ok' : 'poor') ?>">
                  <?= number_format($tomato['achievement_percent'] ?? 0, 1) ?>%
                </span>
              </div>
              <div class="summary-row total">
                <span class="summary-label">UKUPNA ZARADA:</span>
                <span class="summary-value"><?= number_format($tomato['total_earnings'] ?? 0, 2) ?> €</span>
              </div>
            </div>
            
            <?php if (!empty($tomato['services'])): ?>
              <div class="services-breakdown">
                <h4>Prodane tarife:</h4>
                <?php foreach ($tomato['services'] as $service): ?>
                  <div class="service-item">
                    <span class="service-name"><?= htmlspecialchars($service['tarifa']) ?></span>
                    <span class="service-count"><?= $service['count'] ?>x</span>
                    <span class="service-earnings"><?= number_format($service['earnings'], 2) ?> €</span>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <i class="fas fa-info-circle"></i>
                <p>Nema prodanih Tomato usluga ovaj mjesec</p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Quick Actions -->
      <div class="management-cards">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-bolt"></i> Brze akcije
            </h3>
          </div>
          <div class="card-body">
            <div class="quick-actions">
              <a href="<?= route('teambonusfinancije/detail') ?>?month=<?= $statistics['currentMonth'] ?>&year=<?= $statistics['currentYear'] ?>" class="action-button primary">
                <i class="fas fa-search"></i> Detaljni izvještaj
              </a>
              <a href="<?= route('teambonusfinancije/export') ?>?month=<?= $statistics['currentMonth'] ?>&year=<?= $statistics['currentYear'] ?>" class="action-button secondary">
                <i class="fas fa-file-export"></i> Izvoz podataka
              </a>
              <a href="<?= route('teambonusfinancije/print') ?>?month=<?= $statistics['currentMonth'] ?>&year=<?= $statistics['currentYear'] ?>" class="action-button tertiary">
                <i class="fas fa-print"></i> Ispis
              </a>
              <a href="<?= route('teambonus') ?>" class="action-button tertiary">
                <i class="fas fa-users"></i> Team Bonus (količine)
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>