@errormodalreturn

<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.editvrsta'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1><?= isset($vrsta->id) ? 'Uredi vrstu' : 'Dodaj novu vrstu' ?></h1>
      <p>Unesite potrebne podatke za vrstu</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('salevrsta/list') ?>" class="action-button secondary">
        <i class="fas fa-arrow-left"></i> Natrag na popis
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <h3 class="card-title">
        <i class="fas fa-edit"></i> Podaci o vrsti
      </h3>
    </div>
    <div class="card-body">
      <form action="" method="post" class="modern-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
          <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <div class="form-grid">
          <div class="form-group">
            <label for="TARIFA">Tarifa</label>
            <input type="text" 
                   class="form-control" 
                   id="TARIFA" 
                   name="vrsta[TARIFA]" 
                   required 
                   value="<?= htmlspecialchars($vrsta->TARIFA ?? ''); ?>"
                   placeholder="Unesite tarifu">
            <small class="form-text">Tarifa</small>
          </div>

          <div class="form-group">
            <label for="GRUPA">Grupa</label>
            <div class="custom-select-wrapper">
              <select class="form-control" 
                      id="GRUPA" 
                      name="vrsta[GRUPA]" 
                      required>
                <option value="">Odaberite grupu</option>
                <option value="MNP HT" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'MNP HT') ? 'selected' : '' ?>>MNP HT</option>
                <option value="Parica" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'Parica') ? 'selected' : '' ?>>Parica</option>
                <option value="Homebox" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'Homebox') ? 'selected' : '' ?>>Homebox</option>
                <option value="Sat" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'Sat') ? 'selected' : '' ?>>Sat</option>
                <option value="MNP Telemach" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'MNP Telemach') ? 'selected' : '' ?>>MNP Telemach</option>
                <option value="Optika" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'Optika') ? 'selected' : '' ?>>Optika</option>
                <option value="P2P" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'P2P') ? 'selected' : '' ?>>P2P</option>
                <option value="Tomato" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'Tomato') ? 'selected' : '' ?>>Tomato</option>
                <option value="Tomato P2P" <?= (isset($vrsta->GRUPA) && $vrsta->GRUPA === 'Tomato P2P') ? 'selected' : '' ?>>Tomato P2P</option>
              </select>
              <i class="select-arrow fas fa-chevron-down"></i>
            </div>
            <small class="form-text">Odaberite grupu za vrstu</small>
          </div>

          <div class="form-group">
            <label for="BODOVI">Bodovi</label>
            <input type="number" 
                  class="form-control" 
                  id="BODOVI" 
                  name="vrsta[bodovi]" 
                  min="0"
                  max="100"
                  value="<?= htmlspecialchars($vrsta->bodovi ?? '0'); ?>"
                  placeholder="Unesite bodove (0-100)">
            <small class="form-text">Bodovi za agent bonus bodovanje sistem</small>
          </div>
        </div>

        <div class="form-actions">
          <button type="button" class="form-button secondary" id="cancelButton">
            <i class="fas fa-times"></i> Odustani
          </button>
          <button type="submit" class="form-button primary" value="submit">
            <i class="fas fa-save"></i> Spremi
          </button>
        </div>
      </form>
    </div>
  </div>
</div>