<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('sales.listvrsta'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1>Tablica vrsta</h1>
      <p>Pregled i upravljanje tablicom vrsta</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('salevrsta/edit') ?>" class="action-button primary">
        <i class="fas fa-plus"></i> Dodaj novu vrstu
      </a>
      <button type="button" id="exportToggle" class="action-button secondary">
        <i class="fas fa-download"></i> Izvoz
      </button>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-list-ul"></i> Popis vrsta
      </div>
      <div class="card-tools">
        <div class="search-container">
          <input type="text" id="dataSearch" placeholder="Pretraži vrste...">
          <i class="fas fa-search"></i>
        </div>
        <div class="filter-dropdown">
          <button class="filter-button">
            <i class="fas fa-filter"></i> Filter
          </button>
          <div class="filter-menu">
            <div class="filter-group">
              <label>Po tarifi:</label>
              <div class="filter-options" id="tarifaFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
            <div class="filter-group">
              <label>Po grupi:</label>
              <div class="filter-options" id="grupaFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="table-responsive">
      <table id="dataTable" class="data-table">
        <thead>
          <tr>
            <th width="80">Akcije</th>
            <th class="sortable">Tarifa</th>
            <th class="sortable">Grupa</th>
            <th class="sortable">Bodovi</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($vrste as $vrsta): ?>
          <tr>
            <td>
              <div class="table-actions">
                <a href="<?= route('salevrsta/edit') ?>/<?=$vrsta->id?>" 
                   class="action-btn edit" title="Uredi vrstu">
                  <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="action-btn delete" 
                        data-id="<?=$vrsta->id?>" 
                        data-name="<?= htmlspecialchars($vrsta->TARIFA ?? '', ENT_QUOTES, 'UTF-8') ?>"
                        title="Obriši vrstu">
                  <i class="fas fa-trash-alt"></i>
                </button>
              </div>
            </td>
            <td><?= htmlspecialchars($vrsta->TARIFA ?? '', ENT_QUOTES, 'UTF-8') ?></td>
            <td>
              <span class="group-badge group-<?= strtolower(str_replace(' ', '-', $vrsta->GRUPA ?? '')) ?>">
                <?= htmlspecialchars($vrsta->GRUPA ?? '', ENT_QUOTES, 'UTF-8') ?>
              </span>
            </td>
            <td><?= htmlspecialchars($vrsta->bodovi ?? '0') ?></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Export Panel -->
  <div id="exportPanel" class="export-panel">
    <div class="card">
      <div class="card-header">
        <div class="card-title">
          <i class="fas fa-file-export"></i> Izvoz podataka
        </div>
        <button id="closeExport" class="close-btn">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="card-body">
        <form action="" method="post" id="exportForm">
          
          @csrf
          
          <div class="form-group">
            <label for="file_type">Format izvoza</label>
            <select name="file_type" id="file_type" class="form-control">
              <option value="Xlsx">Excel (XLSX)</option>
              <option value="Csv">CSV</option>
            </select>
          </div>
          
          <div class="form-actions">
            <button type="submit" name="export" value="Export" class="form-button primary">
              <i class="fas fa-download"></i> Izvoz podataka
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h3>Potvrda brisanja</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <p>Jeste li sigurni da želite obrisati vrstu <strong id="deleteName"></strong>?</p>
      <p class="text-danger">Ova akcija se ne može poništiti.</p>
    </div>
    <div class="modal-footer">
      <form action="<?= route('salevrsta/delete') ?>" method="post" id="deleteForm">
        
        @csrf

        <input type="hidden" name="id" id="deleteId" value="">
        <button type="button" class="form-button secondary modal-cancel">Odustani</button>
        <button type="submit" class="form-button danger">Obriši</button>
      </form>
    </div>
  </div>
</div>